/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.flr;

import java.util.Map;
import org.jsefa.common.mapping.SimpleTypeMapping;
import org.jsefa.flr.FlrDeserializer;
import org.jsefa.flr.config.FlrConfiguration;
import org.jsefa.flr.lowlevel.Align;
import org.jsefa.flr.lowlevel.FlrLowLevelDeserializer;
import org.jsefa.flr.mapping.FlrSimpleTypeMapping;
import org.jsefa.rbf.RbfDeserializerImpl;
import org.jsefa.rbf.mapping.RbfEntryPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlrDeserializerImpl
extends RbfDeserializerImpl
implements FlrDeserializer {
    private final FlrLowLevelDeserializer lowLevelDeserializer;
    private final int prefixLength;

    FlrDeserializerImpl(FlrConfiguration config, Map<String, RbfEntryPoint> entryPointsByPrefixes, FlrLowLevelDeserializer lowLevelDeserializer) {
        super(config, entryPointsByPrefixes);
        this.prefixLength = entryPointsByPrefixes.keySet().iterator().next().length();
        this.lowLevelDeserializer = lowLevelDeserializer;
    }

    FlrDeserializerImpl(FlrConfiguration config, RbfEntryPoint entryPoint, FlrLowLevelDeserializer lowLevelDeserializer) {
        super(config, entryPoint);
        this.prefixLength = 0;
        this.lowLevelDeserializer = lowLevelDeserializer;
    }

    @Override
    protected Object readSimpleValue(SimpleTypeMapping<?> typeMapping) {
        FlrSimpleTypeMapping flrTypeMapping = (FlrSimpleTypeMapping)typeMapping;
        String stringValue = this.lowLevelDeserializer.nextField(flrTypeMapping.getLength(), flrTypeMapping.getAlign(), flrTypeMapping.getPadCharacter());
        if (stringValue == null || stringValue.length() == 0) {
            return null;
        }
        return typeMapping.getSimpleTypeConverter().fromString(stringValue);
    }

    @Override
    protected String readPrefix() {
        return this.lowLevelDeserializer.nextField(this.prefixLength, Align.LEFT, ' ');
    }

    @Override
    protected FlrLowLevelDeserializer getLowLevelDeserializer() {
        return this.lowLevelDeserializer;
    }
}

