/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.rbf;

import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jsefa.DeserializationException;
import org.jsefa.ObjectPathElement;
import org.jsefa.common.config.ValidationMode;
import org.jsefa.common.lowlevel.InputPosition;
import org.jsefa.common.lowlevel.filter.Line;
import org.jsefa.common.mapping.SimpleTypeMapping;
import org.jsefa.common.mapping.TypeMapping;
import org.jsefa.common.validator.ValidationException;
import org.jsefa.common.validator.ValidationResult;
import org.jsefa.common.validator.Validator;
import org.jsefa.rbf.RbfDeserializer;
import org.jsefa.rbf.config.RbfConfiguration;
import org.jsefa.rbf.lowlevel.RbfLowLevelDeserializer;
import org.jsefa.rbf.mapping.RbfComplexTypeMapping;
import org.jsefa.rbf.mapping.RbfEntryPoint;
import org.jsefa.rbf.mapping.RbfFieldDescriptor;
import org.jsefa.rbf.mapping.RbfListTypeMapping;
import org.jsefa.rbf.mapping.RbfNodeMapping;
import org.jsefa.rbf.mapping.RbfNodeType;
import org.jsefa.rbf.mapping.RbfTypeMappingRegistry;
import org.jsefa.rbf.mapping.RecordDescriptor;
import org.jsefa.rbf.mapping.RecordMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RbfDeserializerImpl
implements RbfDeserializer {
    private final RbfTypeMappingRegistry typeMappingRegistry;
    private final Map<String, RbfEntryPoint> entryPointsByPrefix;
    private final RbfEntryPoint entryPoint;
    private final boolean withPrefix;
    private RbfEntryPoint currentEntryPoint;
    private boolean validate;

    protected RbfDeserializerImpl(RbfConfiguration<?> config, Map<String, RbfEntryPoint> entryPointsByPrefixes) {
        this.typeMappingRegistry = (RbfTypeMappingRegistry)config.getTypeMappingRegistry();
        this.entryPointsByPrefix = entryPointsByPrefixes;
        this.withPrefix = true;
        this.entryPoint = null;
        this.validate = config.getValidationMode().equals((Object)ValidationMode.DESERIALIZATION) || config.getValidationMode().equals((Object)ValidationMode.BOTH);
    }

    protected RbfDeserializerImpl(RbfConfiguration<?> config, RbfEntryPoint entryPoint) {
        this.typeMappingRegistry = (RbfTypeMappingRegistry)config.getTypeMappingRegistry();
        this.entryPoint = entryPoint;
        this.withPrefix = false;
        this.entryPointsByPrefix = null;
        this.validate = config.getValidationMode().equals((Object)ValidationMode.DESERIALIZATION) || config.getValidationMode().equals((Object)ValidationMode.BOTH);
    }

    @Override
    public final void open(Reader reader) {
        this.currentEntryPoint = null;
        try {
            this.getLowLevelDeserializer().open(reader);
        }
        catch (Exception e) {
            throw new DeserializationException("Error while opening the deserialization stream");
        }
    }

    @Override
    public final boolean hasNext() {
        try {
            if (this.currentEntryPoint == null) {
                return this.moveToNextEntryPoint();
            }
            return true;
        }
        catch (DeserializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeserializationException(e).setInputPosition(this.getInputPosition());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final <T> T next() {
        try {
            if (!this.hasNext()) {
                return null;
            }
            try {
                Object result = this.readValue(this.getTypeMapping((String)this.currentEntryPoint.getDataTypeName()));
                if (this.validate && result != null) {
                    this.assertValueIsValid(result, this.currentEntryPoint);
                }
                Object object = result;
                return (T)object;
            }
            finally {
                this.currentEntryPoint = null;
            }
        }
        catch (DeserializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeserializationException(e).setInputPosition(this.getInputPosition());
        }
    }

    @Override
    public final void close(boolean closeReader) {
        try {
            this.getLowLevelDeserializer().close(closeReader);
        }
        catch (Exception e) {
            throw new DeserializationException("Error while closing the serialization stream", e);
        }
    }

    @Override
    public final InputPosition getInputPosition() {
        return this.getLowLevelDeserializer().getInputPosition();
    }

    @Override
    public List<Line> getStoredLines() {
        return this.getLowLevelDeserializer().getStoredLines();
    }

    protected abstract Object readSimpleValue(SimpleTypeMapping<?> var1);

    protected abstract String readPrefix();

    protected abstract RbfLowLevelDeserializer getLowLevelDeserializer();

    private Object readValue(TypeMapping<?> typeMapping) {
        if (typeMapping instanceof SimpleTypeMapping) {
            return this.readSimpleValue((SimpleTypeMapping)typeMapping);
        }
        if (typeMapping instanceof RbfComplexTypeMapping) {
            return this.readComplexValue((RbfComplexTypeMapping)typeMapping);
        }
        throw new UnsupportedOperationException("Unknown type mapping type");
    }

    private Object readComplexValue(RbfComplexTypeMapping typeMapping) {
        Object object = typeMapping.getObjectAccessor().createObject();
        boolean hasNonEmptyFields = this.readFields(object, typeMapping);
        boolean hasNonEmptySubRecords = this.readSubRecords(object, typeMapping);
        if (hasNonEmptyFields || hasNonEmptySubRecords) {
            return object;
        }
        return null;
    }

    private boolean readFields(Object object, RbfComplexTypeMapping typeMapping) {
        boolean hasContent = false;
        int relativeIndex = 0;
        while (true) {
            String fieldName = null;
            try {
                RbfNodeMapping nodeMapping = (RbfNodeMapping)typeMapping.getNodeMapping(new RbfFieldDescriptor(relativeIndex++));
                if (nodeMapping == null) break;
                fieldName = nodeMapping.getFieldDescriptor().getName();
                Object fieldValue = this.readValue(this.getTypeMapping((String)nodeMapping.getDataTypeName()));
                if (fieldValue == null) continue;
                typeMapping.getObjectAccessor().setValue(object, fieldName, fieldValue);
                hasContent = true;
            }
            catch (Exception e) {
                throw this.createException(e, typeMapping, fieldName);
            }
        }
        return hasContent;
    }

    private boolean readSubRecords(Object object, RbfComplexTypeMapping typeMapping) {
        RecordMapping subRecordNodeMapping;
        if (typeMapping.getFieldNames(RbfNodeType.RECORD).isEmpty() || !this.getLowLevelDeserializer().readNextRecord()) {
            return false;
        }
        boolean hasContent = false;
        RecordDescriptor recordDescriptor = new RecordDescriptor(this.readPrefix());
        while ((subRecordNodeMapping = (RecordMapping)typeMapping.getNodeMapping(recordDescriptor)) != null) {
            TypeMapping<?> subRecordTypeMapping = this.getTypeMapping((String)subRecordNodeMapping.getDataTypeName());
            String fieldName = subRecordNodeMapping.getFieldDescriptor().getName();
            try {
                if (subRecordTypeMapping instanceof RbfComplexTypeMapping) {
                    Object fieldValue = this.readValue(subRecordTypeMapping);
                    if (fieldValue != null) {
                        typeMapping.getObjectAccessor().setValue(object, fieldName, fieldValue);
                        hasContent = true;
                    }
                    if (!this.getLowLevelDeserializer().readNextRecord()) {
                        return hasContent;
                    }
                    recordDescriptor = new RecordDescriptor(this.readPrefix());
                } else if (subRecordTypeMapping instanceof RbfListTypeMapping) {
                    RecordMapping listItemRecordMapping;
                    RbfListTypeMapping subRecordListTypeMapping = (RbfListTypeMapping)subRecordTypeMapping;
                    Collection fieldValue = (Collection)subRecordListTypeMapping.getObjectAccessor().createObject();
                    boolean hasRecord = true;
                    while (hasRecord && (listItemRecordMapping = (RecordMapping)subRecordListTypeMapping.getNodeMapping(recordDescriptor)) != null) {
                        TypeMapping<?> listItemTypeMapping = this.getTypeMapping((String)listItemRecordMapping.getDataTypeName());
                        Object listItemValue = this.readValue(listItemTypeMapping);
                        if (listItemValue != null) {
                            fieldValue.add(listItemValue);
                        }
                        if (!(hasRecord = this.getLowLevelDeserializer().readNextRecord())) continue;
                        recordDescriptor = new RecordDescriptor(this.readPrefix());
                    }
                    if (!fieldValue.isEmpty()) {
                        typeMapping.getObjectAccessor().setValue(object, fieldName, fieldValue);
                        hasContent = true;
                    }
                    if (!hasRecord) {
                        return hasContent;
                    }
                }
            }
            catch (Exception e) {
                throw this.createException(e, typeMapping, fieldName);
            }
            if (hasContent) continue;
        }
        this.getLowLevelDeserializer().unreadRecord();
        return hasContent;
    }

    private TypeMapping<?> getTypeMapping(String dataTypeName) {
        TypeMapping<String> typeMapping = this.typeMappingRegistry.get(dataTypeName);
        if (typeMapping == null) {
            throw new DeserializationException("Unknown data type name: " + dataTypeName).setInputPosition(this.getInputPosition());
        }
        return typeMapping;
    }

    private boolean moveToNextEntryPoint() {
        if (this.withPrefix) {
            this.currentEntryPoint = null;
            while (this.getLowLevelDeserializer().readNextRecord()) {
                String prefix = this.readPrefix();
                this.currentEntryPoint = this.entryPointsByPrefix.get(prefix);
                if (this.currentEntryPoint == null) continue;
                return true;
            }
            return false;
        }
        if (this.getLowLevelDeserializer().readNextRecord()) {
            this.currentEntryPoint = this.entryPoint;
            return true;
        }
        this.currentEntryPoint = null;
        return false;
    }

    private DeserializationException createException(Exception cause, TypeMapping<?> typeMapping, String fieldName) {
        ObjectPathElement elem = new ObjectPathElement(typeMapping.getObjectType(), fieldName);
        if (cause instanceof DeserializationException) {
            return ((DeserializationException)cause).add(elem);
        }
        return new DeserializationException(cause).setInputPosition(this.getInputPosition()).add(elem);
    }

    private void assertValueIsValid(Object object, RbfEntryPoint entryPoint) {
        ValidationResult result;
        Validator validator = entryPoint.getValidator();
        if (validator != null && !(result = validator.validate(object)).isValid()) {
            throw new ValidationException(result);
        }
    }
}

