/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.rbf.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jsefa.common.accessor.ObjectAccessorProvider;
import org.jsefa.common.annotation.AnnotatedFieldsProvider;
import org.jsefa.common.annotation.AnnotationDataProvider;
import org.jsefa.common.annotation.AnnotationException;
import org.jsefa.common.annotation.TypeMappingFactory;
import org.jsefa.common.converter.SimpleTypeConverter;
import org.jsefa.common.converter.provider.SimpleTypeConverterProvider;
import org.jsefa.common.mapping.FieldDescriptor;
import org.jsefa.common.mapping.TypeMapping;
import org.jsefa.common.mapping.TypeMappingException;
import org.jsefa.common.validator.Validator;
import org.jsefa.common.validator.provider.ValidatorProvider;
import org.jsefa.rbf.annotation.RbfAnnotations;
import org.jsefa.rbf.annotation.Record;
import org.jsefa.rbf.mapping.FieldMapping;
import org.jsefa.rbf.mapping.RbfComplexTypeMapping;
import org.jsefa.rbf.mapping.RbfFieldDescriptor;
import org.jsefa.rbf.mapping.RbfListTypeMapping;
import org.jsefa.rbf.mapping.RbfNodeMapping;
import org.jsefa.rbf.mapping.RbfNodeType;
import org.jsefa.rbf.mapping.RbfTypeMappingRegistry;
import org.jsefa.rbf.mapping.RecordDescriptor;
import org.jsefa.rbf.mapping.RecordMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RbfTypeMappingFactory
extends TypeMappingFactory<String, RbfTypeMappingRegistry> {
    private final RbfAnnotations annotations;

    public RbfTypeMappingFactory(RbfTypeMappingRegistry typeMappingRegistry, SimpleTypeConverterProvider simpleTypeConverterProvider, ValidatorProvider validatorProvider, ObjectAccessorProvider objectAccessorProvider, RbfAnnotations annotations) {
        super(typeMappingRegistry, simpleTypeConverterProvider, validatorProvider, objectAccessorProvider);
        this.annotations = annotations;
    }

    @Override
    public final String createIfAbsent(Class<?> objectType) {
        if (!this.hasComplexType(objectType)) {
            throw new AnnotationException("The class " + objectType + " has no data type annotation");
        }
        String dataTypeName = this.createComplexTypeMappingIfAbsent(objectType, true);
        this.assertIsCycleFree(dataTypeName);
        return dataTypeName;
    }

    protected abstract TypeMapping<String> createSimpleTypeMapping(Class<?> var1, String var2, SimpleTypeConverter var3, Field var4);

    @Override
    protected String getAnnotatedDataTypeName(Annotation annotation, Class<?> annotationContextClass) {
        return (String)AnnotationDataProvider.get(annotation, "dataTypeName");
    }

    private String createSimpleTypeMappingIfAbsent(Class<?> objectType, Field field, Annotation fieldAnnotation) {
        String dataTypeName = this.createSimpleDataTypeName(field);
        if (this.prepareToCreate(objectType, dataTypeName)) {
            SimpleTypeConverter converter = this.createSimpleTypeConverter(objectType, field, fieldAnnotation);
            ((RbfTypeMappingRegistry)this.getTypeMappingRegistry()).register(this.createSimpleTypeMapping(objectType, dataTypeName, converter, field));
        }
        return dataTypeName;
    }

    private String createComplexTypeMappingIfAbsent(Class<?> objectType, boolean subRecordsAllowed) {
        String dataTypeName = this.createComplexDataTypeName(objectType);
        if (this.prepareToCreate(objectType, dataTypeName)) {
            ArrayList nodeMappings = new ArrayList();
            nodeMappings.addAll(this.createFieldMappings(objectType));
            if (subRecordsAllowed) {
                nodeMappings.addAll(this.createRecordMappings(objectType));
            } else {
                this.assertNoSubRecordsDeclared(objectType);
            }
            Validator validator = this.getValidatorFactory().createValidator(objectType, this.annotations.getFieldAnnotationClass(), this.annotations.getSubRecordAnnotationClass(), this.annotations.getSubRecordListAnnotationClass());
            RbfComplexTypeMapping complexTypeMapping = new RbfComplexTypeMapping(objectType, dataTypeName, this.getObjectAccessorProvider().get(objectType), nodeMappings, validator);
            ((RbfTypeMappingRegistry)this.getTypeMappingRegistry()).register(complexTypeMapping);
        }
        return dataTypeName;
    }

    private Collection<FieldMapping> createFieldMappings(Class<?> objectType) {
        ArrayList<FieldMapping> fieldMappings = new ArrayList<FieldMapping>();
        int relativeFieldIndex = 0;
        for (Field field : AnnotatedFieldsProvider.getSortedAnnotatedFields(objectType, this.annotations.getFieldAnnotationClass())) {
            Validator validator;
            Class<?> normalizedFieldObjectType;
            String fieldDataTypeName = (String)AnnotationDataProvider.get(field, "dataTypeName", this.annotations.getFieldAnnotationClass());
            Annotation fieldAnnotation = field.getAnnotation(this.annotations.getFieldAnnotationClass());
            if (this.hasSimpleType(field.getType())) {
                if (fieldDataTypeName == null) {
                    fieldDataTypeName = this.createSimpleTypeMappingIfAbsent(field.getType(), field, fieldAnnotation);
                } else {
                    this.assertTypeMappingExists(fieldDataTypeName);
                }
                normalizedFieldObjectType = ((RbfTypeMappingRegistry)this.getTypeMappingRegistry()).get(fieldDataTypeName).getObjectType();
                validator = this.getValidatorFactory().createContextualValidator(normalizedFieldObjectType, field, fieldAnnotation, this.annotations.getDataTypeAnnotationClass());
                fieldMappings.add(new FieldMapping(fieldDataTypeName, new RbfFieldDescriptor(relativeFieldIndex++), normalizedFieldObjectType, new FieldDescriptor(field.getName(), normalizedFieldObjectType), validator));
                continue;
            }
            if (this.hasComplexType(field.getType())) {
                if (fieldDataTypeName == null) {
                    fieldDataTypeName = this.createComplexTypeMappingIfAbsent(field.getType(), false);
                } else {
                    this.assertTypeMappingExists(fieldDataTypeName);
                }
                normalizedFieldObjectType = ((RbfTypeMappingRegistry)this.getTypeMappingRegistry()).get(fieldDataTypeName).getObjectType();
                validator = this.getValidatorFactory().createContextualValidator(normalizedFieldObjectType, field, fieldAnnotation, this.annotations.getDataTypeAnnotationClass());
                fieldMappings.add(new FieldMapping(fieldDataTypeName, new RbfFieldDescriptor(relativeFieldIndex++), normalizedFieldObjectType, new FieldDescriptor(field.getName(), normalizedFieldObjectType), validator));
                continue;
            }
            throw new TypeMappingException("Can not create a type mapping for field " + field.getName() + " of class " + objectType.getName());
        }
        return fieldMappings;
    }

    private Collection<RecordMapping> createRecordMappings(Class<?> objectType) {
        ArrayList<RecordMapping> recordMappings = new ArrayList<RecordMapping>();
        int requiredPrefixLength = this.getRequiredPrefixLength(objectType);
        for (Field field : AnnotatedFieldsProvider.getSortedAnnotatedFields(objectType, this.annotations.getSubRecordAnnotationClass(), this.annotations.getSubRecordListAnnotationClass())) {
            if (this.hasCollectionType(field.getType()) && field.getAnnotation(this.annotations.getSubRecordListAnnotationClass()) != null) {
                Record[] records;
                String listDataTypeName = this.createListTypeMappingIfAbsent(field, requiredPrefixLength);
                Annotation fieldAnnotation = field.getAnnotation(this.annotations.getSubRecordListAnnotationClass());
                for (Record record : records = this.getRecords(fieldAnnotation)) {
                    String listItemDataTypeName = this.createIfAbsent(field, record, records);
                    String prefix = record.prefix();
                    this.assertPrefixHasRequiredLength(field, prefix, requiredPrefixLength);
                    Class<?> normalizedListItemObjectType = ((RbfTypeMappingRegistry)this.getTypeMappingRegistry()).get(listItemDataTypeName).getObjectType();
                    Validator validator = this.getValidatorFactory().createContextualValidator(normalizedListItemObjectType, field, record, this.annotations.getDataTypeAnnotationClass());
                    recordMappings.add(new RecordMapping(listDataTypeName, new RecordDescriptor(prefix), normalizedListItemObjectType, new FieldDescriptor(field.getName(), Collection.class), true, validator));
                }
                Validator validator = this.getValidatorFactory().createContextualValidator(Collection.class, field, fieldAnnotation, this.annotations.getDataTypeAnnotationClass());
                recordMappings.add(new RecordMapping(listDataTypeName, new RecordDescriptor(null), Collection.class, new FieldDescriptor(field.getName(), Collection.class), false, validator));
                continue;
            }
            if (!this.hasComplexType(field.getType())) continue;
            String fieldDataTypeName = (String)AnnotationDataProvider.get(field, "dataTypeName", this.annotations.getSubRecordAnnotationClass());
            if (fieldDataTypeName == null) {
                fieldDataTypeName = this.createComplexTypeMappingIfAbsent(field.getType(), true);
            } else {
                this.assertTypeMappingExists(fieldDataTypeName);
            }
            String prefix = (String)AnnotationDataProvider.get(field, "prefix", this.annotations.getSubRecordAnnotationClass());
            if (prefix.length() != requiredPrefixLength) {
                throw new AnnotationException("The object type " + field.getType() + " must have a prefix with length " + requiredPrefixLength);
            }
            Class<?> normalizedFieldObjectType = ((RbfTypeMappingRegistry)this.getTypeMappingRegistry()).get(fieldDataTypeName).getObjectType();
            Annotation fieldAnnotation = field.getAnnotation(this.annotations.getSubRecordAnnotationClass());
            Validator validator = this.getValidatorFactory().createContextualValidator(normalizedFieldObjectType, field, fieldAnnotation, this.annotations.getDataTypeAnnotationClass());
            recordMappings.add(new RecordMapping(fieldDataTypeName, new RecordDescriptor(prefix), normalizedFieldObjectType, new FieldDescriptor(field.getName(), normalizedFieldObjectType), false, validator));
        }
        return recordMappings;
    }

    private void assertNoSubRecordsDeclared(Class<?> objectType) {
        int counter = AnnotatedFieldsProvider.getSortedAnnotatedFields(objectType, this.annotations.getSubRecordAnnotationClass(), this.annotations.getSubRecordListAnnotationClass()).size();
        if (counter > 0) {
            throw new TypeMappingException("No sub records nor sub record lists allowed within embedded type: " + objectType.getName());
        }
    }

    private String createListTypeMappingIfAbsent(Field field, int requiredPrefixLength) {
        Annotation subRecordListAnnotation = field.getAnnotation(this.annotations.getSubRecordListAnnotationClass());
        String dataTypeName = this.createListDataTypeName(field);
        if (this.prepareToCreate(Collection.class, dataTypeName)) {
            Record[] records;
            if (subRecordListAnnotation == null || this.getRecords(subRecordListAnnotation).length == 0) {
                throw new AnnotationException("No FlrSubRecordList annotation with proper content found");
            }
            ArrayList<RecordMapping> recordMappings = new ArrayList<RecordMapping>();
            for (Record record : records = this.getRecords(subRecordListAnnotation)) {
                String listItemDataTypeName = this.createIfAbsent(field, record, records);
                String prefix = record.prefix();
                this.assertPrefixHasRequiredLength(field, prefix, requiredPrefixLength);
                Class<?> normalizedListItemObjectType = ((RbfTypeMappingRegistry)this.getTypeMappingRegistry()).get(listItemDataTypeName).getObjectType();
                Validator validator = this.getValidatorFactory().createContextualValidator(normalizedListItemObjectType, field, record, this.annotations.getDataTypeAnnotationClass());
                recordMappings.add(new RecordMapping(listItemDataTypeName, new RecordDescriptor(prefix), normalizedListItemObjectType, new FieldDescriptor(field.getName(), Collection.class), false, validator));
            }
            ((RbfTypeMappingRegistry)this.getTypeMappingRegistry()).register(new RbfListTypeMapping(dataTypeName, recordMappings, this.getObjectAccessorProvider().get(field.getType())));
        }
        return dataTypeName;
    }

    private void assertPrefixHasRequiredLength(Field field, String prefix, int requiredPrefixLength) {
        if (prefix.length() != requiredPrefixLength) {
            throw new AnnotationException("All record annotations of the list field " + field.getName() + " of class " + field.getDeclaringClass().getName() + " must have a prefix with length " + requiredPrefixLength);
        }
    }

    private String createIfAbsent(Field field, Record record, Record[] records) {
        String listItemDataTypeName = (String)AnnotationDataProvider.get(record, "dataTypeName");
        if (listItemDataTypeName == null) {
            Class<?> listItemObjectType = this.getCollectionItemType(record, field, records.length == 1);
            this.assertHasComplexType(listItemObjectType, field);
            listItemDataTypeName = this.createComplexTypeMappingIfAbsent(listItemObjectType, true);
        } else {
            this.assertTypeMappingExists(listItemDataTypeName);
        }
        return listItemDataTypeName;
    }

    private void assertHasComplexType(Class<?> listItemObjectType, Field field) {
        if (listItemObjectType == null) {
            throw new AnnotationException("Neither dataTypeName nor objectType is given for list item of field: " + field.getName() + " of class " + field.getDeclaringClass().getName());
        }
        if (!this.hasComplexType(listItemObjectType)) {
            throw new AnnotationException("The sub record object type " + listItemObjectType.getName() + " must have a data type annotation");
        }
    }

    private Record[] getRecords(Annotation annotation) {
        return (Record[])AnnotationDataProvider.get(annotation, "records");
    }

    private boolean hasComplexType(Class<?> objectType) {
        return objectType.isAnnotationPresent(this.annotations.getDataTypeAnnotationClass());
    }

    private String createSimpleDataTypeName(Field field) {
        return field.getDeclaringClass().getName() + "." + field.getName();
    }

    private String createComplexDataTypeName(Class<?> objectType) {
        Annotation dataType = objectType.getAnnotation(this.annotations.getDataTypeAnnotationClass());
        if (dataType != null && AnnotationDataProvider.get(dataType, "name") != null) {
            return (String)AnnotationDataProvider.get(dataType, "name");
        }
        return objectType.getName();
    }

    private String createListDataTypeName(Field field) {
        return field.getDeclaringClass().getName() + "." + field.getName();
    }

    private int getRequiredPrefixLength(Class<?> objectType) {
        if (AnnotatedFieldsProvider.getSortedAnnotatedFields(objectType, this.annotations.getSubRecordAnnotationClass(), this.annotations.getSubRecordListAnnotationClass()).size() > 0) {
            Annotation dataTypeAnnotation = objectType.getAnnotation(this.annotations.getDataTypeAnnotationClass());
            String defaultPrefix = (String)AnnotationDataProvider.get(dataTypeAnnotation, "defaultPrefix");
            if (defaultPrefix.length() == 0) {
                throw new AnnotationException("A prefix must be defined for object type " + objectType.getName());
            }
            return defaultPrefix.length();
        }
        return 0;
    }

    private void assertIsCycleFree(String dataTypeName) {
        this.assertIsCycleFree(dataTypeName, new ArrayList());
    }

    private void assertIsCycleFree(String dataTypeName, List<Class<?>> objectTypePath) {
        TypeMapping<String> typeMapping = ((RbfTypeMappingRegistry)this.getTypeMappingRegistry()).get(dataTypeName);
        for (Class<?> objectTypeOnPath : objectTypePath) {
            if (!objectTypeOnPath.isAssignableFrom(typeMapping.getObjectType()) && !typeMapping.getObjectType().isAssignableFrom(objectTypeOnPath)) continue;
            objectTypePath.add(typeMapping.getObjectType());
            throw new TypeMappingException("Cycle in type graph detected. Path: " + objectTypePath);
        }
        objectTypePath.add(typeMapping.getObjectType());
        if (typeMapping instanceof RbfComplexTypeMapping) {
            RbfNodeMapping nodeMapping;
            RbfComplexTypeMapping complexTypeMapping = (RbfComplexTypeMapping)typeMapping;
            for (String fieldName : complexTypeMapping.getFieldNames(RbfNodeType.FIELD)) {
                nodeMapping = (RbfNodeMapping)complexTypeMapping.getNodeMapping(fieldName, Object.class);
                this.assertIsCycleFree((String)nodeMapping.getDataTypeName(), objectTypePath);
            }
            for (String fieldName : complexTypeMapping.getFieldNames(RbfNodeType.RECORD)) {
                nodeMapping = (RbfNodeMapping)complexTypeMapping.getNodeMapping(fieldName, Object.class);
                this.assertIsCycleFree((String)nodeMapping.getDataTypeName());
            }
        }
        objectTypePath.remove(typeMapping.getObjectType());
    }
}

