/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.rbf.lowlevel;

import java.io.IOException;
import java.io.Writer;
import org.jsefa.common.lowlevel.LowLevelSerializationException;
import org.jsefa.common.lowlevel.config.LowLevelConfiguration;
import org.jsefa.rbf.lowlevel.RbfLowLevelSerializer;
import org.jsefa.rbf.lowlevel.config.RbfLowLevelConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RbfLowLevelSerializerImpl<C extends RbfLowLevelConfiguration>
implements RbfLowLevelSerializer {
    private C config;
    private Writer writer;

    public RbfLowLevelSerializerImpl(C config) {
        this.config = config;
    }

    @Override
    public final void open(Writer writer) {
        this.writer = writer;
        this.afterOpen();
    }

    @Override
    public final void finishRecord() {
        this.beforeFinishRecord();
        this.writeRecordDelimiter();
    }

    @Override
    public void writeLine(String line) {
        this.writeString(line);
        this.writeLineBreak();
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new LowLevelSerializationException("Error while flushing the serialization stream", e);
        }
        catch (ClassCastException e) {
            return;
        }
    }

    @Override
    public final void close(boolean closeWriter) {
        if (closeWriter) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new LowLevelSerializationException("Error while closing the serialization stream", e);
            }
        }
    }

    protected final C getConfiguration() {
        return this.config;
    }

    protected void afterOpen() {
    }

    protected void beforeFinishRecord() {
    }

    protected final void writeChar(int character) {
        try {
            this.writer.write(character);
        }
        catch (IOException e) {
            throw new LowLevelSerializationException(e);
        }
    }

    protected final void writeString(String value) {
        try {
            this.writer.write(value);
        }
        catch (IOException e) {
            throw new LowLevelSerializationException(e);
        }
    }

    private void writeLineBreak() {
        try {
            this.writer.write(((LowLevelConfiguration)this.config).getLineBreak());
        }
        catch (IOException e) {
            throw new LowLevelSerializationException(e);
        }
    }

    private void writeRecordDelimiter() {
        if (((RbfLowLevelConfiguration)this.config).getSpecialRecordDelimiter() != null) {
            try {
                this.writer.write(((RbfLowLevelConfiguration)this.config).getSpecialRecordDelimiter().charValue());
            }
            catch (IOException e) {
                throw new LowLevelSerializationException(e);
            }
        } else {
            this.writeLineBreak();
        }
    }
}

