/*
 * Decompiled with CFR 0.152.
 */
package org.jsefa.xml.lowlevel;

import java.io.BufferedReader;
import java.io.Reader;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jsefa.common.lowlevel.InputPosition;
import org.jsefa.common.lowlevel.LowLevelDeserializationException;
import org.jsefa.xml.lowlevel.XmlLowLevelDeserializer;
import org.jsefa.xml.lowlevel.config.XmlLowLevelConfiguration;
import org.jsefa.xml.lowlevel.model.Attribute;
import org.jsefa.xml.lowlevel.model.AttributeImpl;
import org.jsefa.xml.lowlevel.model.ElementEndImpl;
import org.jsefa.xml.lowlevel.model.ElementStartImpl;
import org.jsefa.xml.lowlevel.model.TextContentImpl;
import org.jsefa.xml.lowlevel.model.XmlItem;
import org.jsefa.xml.lowlevel.model.XmlItemType;
import org.jsefa.xml.namespace.QName;

public final class StaxBasedXmlLowLevelDeserializer
implements XmlLowLevelDeserializer {
    private final XmlLowLevelConfiguration config;
    private Reader reader;
    private XMLStreamReader streamReader;
    private int depth = -1;
    private XmlItemType currentItemType;
    private XmlItem currentItem;
    private boolean eventPrefetched;
    private boolean decreaseDepthOnNextEvent;

    public StaxBasedXmlLowLevelDeserializer(XmlLowLevelConfiguration config) {
        this.config = config;
    }

    public void open(Reader reader) {
        this.open(reader, null);
    }

    public void open(Reader reader, String systemId) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            this.streamReader = systemId != null ? factory.createXMLStreamReader(systemId, this.reader) : factory.createXMLStreamReader(this.reader);
        }
        catch (XMLStreamException e) {
            throw new LowLevelDeserializationException("Error while opening the deserialization stream", e);
        }
        this.depth = -1;
        this.currentItem = null;
        this.currentItemType = XmlItemType.NONE;
        this.eventPrefetched = false;
        this.decreaseDepthOnNextEvent = false;
    }

    public boolean hasNext() {
        try {
            return this.eventPrefetched || this.streamReader.hasNext();
        }
        catch (XMLStreamException e) {
            throw new LowLevelDeserializationException(e);
        }
    }

    public void moveToNext() {
        if (this.decreaseDepthOnNextEvent) {
            --this.depth;
            this.decreaseDepthOnNextEvent = false;
        }
        if (!this.eventPrefetched && !this.hasNext()) {
            this.currentItemType = XmlItemType.NONE;
            this.currentItem = null;
            return;
        }
        try {
            int event;
            if (this.eventPrefetched) {
                event = this.streamReader.getEventType();
                this.eventPrefetched = false;
            } else {
                event = this.streamReader.next();
            }
            switch (event) {
                case 1: {
                    ++this.depth;
                    this.currentItemType = XmlItemType.ELEMENT_START;
                    break;
                }
                case 2: {
                    this.currentItemType = XmlItemType.ELEMENT_END;
                    this.decreaseDepthOnNextEvent = true;
                    break;
                }
                case 12: {
                    this.currentItemType = XmlItemType.TEXT_CONTENT;
                    break;
                }
                case 4: {
                    this.currentItemType = XmlItemType.TEXT_CONTENT;
                    break;
                }
                default: {
                    this.currentItemType = XmlItemType.UNKNOWN;
                }
            }
            this.currentItem = null;
        }
        catch (XMLStreamException e) {
            throw new LowLevelDeserializationException(e);
        }
    }

    public XmlItemType currentType() {
        return this.currentItemType;
    }

    public XmlItem current() {
        if (this.currentItem == null) {
            if (this.currentItemType == XmlItemType.ELEMENT_START) {
                QName name = this.getElementName();
                QName dataTypeName = this.getDataTypeName();
                Attribute[] attributes = this.getAttributes();
                this.currentItem = new ElementStartImpl(name, dataTypeName, attributes, this.depth);
            } else if (this.currentItemType == XmlItemType.ELEMENT_END) {
                QName name = this.getElementName();
                this.currentItem = new ElementEndImpl(name, this.depth);
            } else if (this.currentItemType == XmlItemType.TEXT_CONTENT) {
                try {
                    if (!this.streamReader.hasNext()) {
                        this.currentItem = new TextContentImpl(this.streamReader.getText());
                    } else {
                        String text = this.streamReader.getText();
                        int event = this.streamReader.next();
                        this.eventPrefetched = true;
                        if (event != 12 && event != 4) {
                            this.currentItem = new TextContentImpl(text);
                        } else {
                            StringBuilder buffer = new StringBuilder(text);
                            do {
                                buffer.append(this.streamReader.getText());
                            } while (((event = this.streamReader.next()) == 12 || event == 4) && this.streamReader.hasNext());
                            this.currentItem = new TextContentImpl(buffer.toString());
                        }
                    }
                }
                catch (XMLStreamException e) {
                    throw new LowLevelDeserializationException(e);
                }
            }
        }
        return this.currentItem;
    }

    public int currentDepth() {
        return this.depth;
    }

    public void close(boolean closeReader) {
        try {
            this.streamReader.close();
            if (closeReader) {
                this.reader.close();
            }
        }
        catch (Exception e) {
            throw new LowLevelDeserializationException("Error while closing the deserialization stream", e);
        }
        this.reader = null;
    }

    public InputPosition getInputPosition() {
        if (this.reader != null) {
            try {
                Location location = this.streamReader.getLocation();
                if (location != null && location.getLineNumber() >= 0 && location.getColumnNumber() >= 0) {
                    return new InputPosition(location.getLineNumber(), location.getColumnNumber());
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private QName getElementName() {
        return QName.create(this.normalizeURI(this.streamReader.getNamespaceURI()), this.streamReader.getLocalName());
    }

    private QName getDataTypeName() {
        QName dataTypeName = null;
        String dataTypeNameStr = this.streamReader.getAttributeValue(this.config.getDataTypeAttributeName().getUri(), this.config.getDataTypeAttributeName().getLocalName());
        if (dataTypeNameStr != null) {
            int delimiterPos = dataTypeNameStr.indexOf(":");
            if (delimiterPos == -1) {
                dataTypeName = QName.create(this.normalizeURI(this.streamReader.getNamespaceURI("")), dataTypeNameStr);
            } else {
                String prefix = dataTypeNameStr.substring(0, delimiterPos);
                String uri = this.streamReader.getNamespaceURI(prefix);
                String localName = "";
                if (delimiterPos < dataTypeNameStr.length() - 1) {
                    localName = dataTypeNameStr.substring(delimiterPos + 1);
                }
                dataTypeName = QName.create(this.normalizeURI(uri), localName);
            }
        }
        return dataTypeName;
    }

    private Attribute[] getAttributes() {
        int attributeCount = this.streamReader.getAttributeCount();
        Attribute[] attributes = new Attribute[attributeCount];
        for (int i = 0; i < attributeCount; ++i) {
            QName name = QName.create(this.normalizeURI(this.streamReader.getAttributeNamespace(i)), this.streamReader.getAttributeLocalName(i));
            String value = this.streamReader.getAttributeValue(i);
            attributes[i] = new AttributeImpl(name, value);
        }
        return attributes;
    }

    private String normalizeURI(String uri) {
        if (uri != null) {
            return uri;
        }
        return "";
    }
}

