/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.core;

import com.sun.corba.se.internal.core.ORBVersion;
import com.sun.corba.se.internal.core.ORBVersionImpl;
import com.sun.corba.se.internal.util.Utility;
import org.omg.CORBA.portable.InputStream;

public class ORBVersionFactory {
    private ORBVersionFactory() {
    }

    public static ORBVersion getORBVersion() {
        return ORBVersionImpl.JDK1_3_1_01;
    }

    public static ORBVersion create(byte[] byArray, int n) {
        byte by = byArray[n];
        return ORBVersionFactory.byteToVersion(by);
    }

    public static ORBVersion create(InputStream inputStream) {
        byte by = inputStream.read_octet();
        return ORBVersionFactory.byteToVersion(by);
    }

    public static ORBVersion createFromObjectKey(byte[] byArray) {
        if (byArray == null || byArray.length < 4) {
            return ORBVersionFactory.getORBVersion();
        }
        int n = Utility.bytesToInt(byArray, 0);
        if (n == -1347695874) {
            return ORBVersionImpl.OLD;
        }
        if (n != -1347695873) {
            return ORBVersionFactory.getORBVersion();
        }
        int n2 = Utility.bytesToInt(byArray, 12);
        if (byArray.length == 16 + n2) {
            return ORBVersionImpl.NEW;
        }
        return ORBVersionFactory.getORBVersion();
    }

    private static ORBVersion byteToVersion(byte by) {
        switch (by) {
            case 0: {
                return ORBVersionImpl.FOREIGN;
            }
            case 1: {
                return ORBVersionImpl.OLD;
            }
            case 2: {
                return ORBVersionImpl.NEW;
            }
            case 3: {
                return ORBVersionImpl.JDK1_3_1_01;
            }
            case 10: {
                return ORBVersionImpl.NEWER;
            }
        }
        return ORBVersionImpl.NEWER;
    }
}

