/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.StyleProperties;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.text.ParagraphStyle;
import org.jopendocument.dom.text.TextStyle;

public class GraphicStyle
extends StyleStyle {
    public static final String STYLE_FAMILY = "graphic";
    public static final StyleDesc<GraphicStyle> DESC = new StyleDesc<GraphicStyle>(GraphicStyle.class, XMLVersion.OD, "graphic", "fr", "draw", Arrays.asList("dr3d:cube", "dr3d:extrude", "dr3d:rotate", "dr3d:scene", "dr3d:sphere", "draw:caption", "draw:circle", "draw:connector", "draw:control", "draw:custom-shape", "draw:ellipse", "draw:frame", "draw:g", "draw:line", "draw:measure", "draw:page-thumbnail", "draw:path", "draw:polygon", "draw:polyline", "draw:rect", "draw:regular-polygon", "office:annotation")){

        @Override
        public GraphicStyle create(ODPackage oDPackage, Element element) {
            return new GraphicStyle(oDPackage, element);
        }
    };
    private TextStyle.SyleTextProperties textProps = null;
    private ParagraphStyle.SyleParagraphProperties pProps = null;
    private SyleGraphicProperties graphProps = null;

    public GraphicStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element);
    }

    public final TextStyle.SyleTextProperties getTextProperties() {
        if (this.textProps == null) {
            this.textProps = new TextStyle.SyleTextProperties(this);
        }
        return this.textProps;
    }

    public final ParagraphStyle.SyleParagraphProperties getParagraphProperties() {
        if (this.pProps == null) {
            this.pProps = new ParagraphStyle.SyleParagraphProperties(this);
        }
        return this.pProps;
    }

    public final SyleGraphicProperties getGraphicProperties() {
        if (this.graphProps == null) {
            this.graphProps = new SyleGraphicProperties(this);
        }
        return this.graphProps;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SyleGraphicProperties
    extends StyleProperties {
        private static Pattern split = Pattern.compile(" ");

        public SyleGraphicProperties(StyleStyle styleStyle) {
            super(styleStyle, GraphicStyle.STYLE_FAMILY);
        }

        public final String getHorizontalPosition() {
            return this.getElement().getAttributeValue("horizontal-pos", this.getElement().getNamespace("style"));
        }

        public final String getHorizontalRelation() {
            return this.getElement().getAttributeValue("horizontal-rel", this.getElement().getNamespace("style"));
        }

        public final String getVerticalPosition() {
            return this.getElement().getAttributeValue("vertical-pos", this.getElement().getNamespace("style"));
        }

        public final String getVerticalRelation() {
            return this.getElement().getAttributeValue("vertical-rel", this.getElement().getNamespace("style"));
        }

        public final List<String> getProtected() {
            String string = this.getElement().getAttributeValue("protect", this.getElement().getNamespace("style"));
            if (string == null || "none".equals(string)) {
                return Collections.emptyList();
            }
            return Arrays.asList(split.split(string));
        }

        public final boolean isContentPrinted() {
            return this.parseBoolean(this.getElement().getAttributeValue("print-content", this.getElement().getNamespace("style")), true);
        }
    }
}

