/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.math.BigDecimal;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.GraphicStyle;
import org.jopendocument.dom.ImmutableDocStyledNode;
import org.jopendocument.dom.LengthUnit;
import org.jopendocument.dom.ODDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODFrame<D extends ODDocument>
extends ImmutableDocStyledNode<GraphicStyle, D> {
    private final BigDecimal width = ODFrame.parseLengthDecimal(this.getSVGAttr("width"), this.getUnit());
    private final BigDecimal height = ODFrame.parseLengthDecimal(this.getSVGAttr("height"), this.getUnit());

    public static final float parseLength(String string, LengthUnit lengthUnit) {
        return ODFrame.parseLengthDecimal(string, lengthUnit).floatValue();
    }

    public static final BigDecimal parseLengthDecimal(String string, LengthUnit lengthUnit) {
        if (string == null) {
            return null;
        }
        return LengthUnit.parseLength(string, lengthUnit).stripTrailingZeros();
    }

    public ODFrame(D d, Element element) {
        super(d, element, GraphicStyle.class);
    }

    public final BigDecimal getWidth() {
        return this.getWidth(this.getUnit());
    }

    public final BigDecimal getWidth(LengthUnit lengthUnit) {
        return this.getUnit().convertTo(this.width, lengthUnit);
    }

    public final BigDecimal getHeight() {
        return this.getHeight(this.getUnit());
    }

    public final BigDecimal getHeight(LengthUnit lengthUnit) {
        return this.getUnit().convertTo(this.height, lengthUnit);
    }

    private Namespace getSVG() {
        return this.getElement().getNamespace("svg");
    }

    public String getSVGAttr(String string) {
        return this.getElement().getAttributeValue(string, this.getSVG());
    }

    public void setSVGAttr(String string, String string2) {
        this.getElement().setAttribute(string, string2, this.getSVG());
    }

    public void setSVGAttr(String string, Number number) {
        this.setSVGAttr(string, number + this.getUnit().getSymbol());
    }

    public final double getRatio() {
        return this.getWidth().doubleValue() / this.getHeight().doubleValue();
    }

    public final BigDecimal getX() {
        return ODFrame.parseLengthDecimal(this.getSVGAttr("x"), this.getUnit());
    }

    public final BigDecimal getY() {
        return ODFrame.parseLengthDecimal(this.getSVGAttr("y"), this.getUnit());
    }

    public final LengthUnit getUnit() {
        return LengthUnit.MM;
    }
}

