/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jopendocument.dom.ChildCreator;
import org.jopendocument.dom.ODNode;
import org.jopendocument.dom.ODUserDefinedMeta;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.XMLVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODMeta
extends ODNode {
    private static final Map<XMLVersion, List<Element>> ELEMS_ORDER = new HashMap<XMLVersion, List<Element>>(2);
    private final ODXMLDocument parent;
    private final ChildCreator childCreator;

    static ODMeta create(ODXMLDocument oDXMLDocument) {
        Element element = oDXMLDocument.getChild("meta");
        return element == null ? null : new ODMeta(element, oDXMLDocument);
    }

    private static final List<Element> createChildren(XMLVersion xMLVersion) {
        Namespace namespace = xMLVersion.getMETA();
        Namespace namespace2 = xMLVersion.getNS("dc");
        ArrayList<Element> arrayList = new ArrayList<Element>(8);
        arrayList.add(new Element("generator", namespace));
        arrayList.add(new Element("title", namespace2));
        arrayList.add(new Element("description", namespace2));
        arrayList.add(new Element("subject", namespace2));
        arrayList.add(new Element("keyword", namespace));
        arrayList.add(new Element("initial-creator", namespace));
        arrayList.add(new Element("creator", namespace2));
        arrayList.add(new Element("printed-by", namespace));
        arrayList.add(new Element("creation-date", namespace));
        arrayList.add(new Element("date", namespace2));
        arrayList.add(new Element("print-date", namespace));
        arrayList.add(new Element("template", namespace));
        arrayList.add(new Element("auto-reload", namespace));
        arrayList.add(new Element("hyperlink-behaviour", namespace));
        arrayList.add(new Element("language", namespace2));
        arrayList.add(new Element("editing-cycles", namespace));
        arrayList.add(new Element("editing-duration", namespace));
        arrayList.add(new Element("document-statistic", namespace));
        arrayList.add(new Element("user-defined", namespace));
        return arrayList;
    }

    private ODMeta(Element element, ODXMLDocument oDXMLDocument) {
        super(element);
        this.parent = oDXMLDocument;
        this.childCreator = new ChildCreator(this.getElement(), ELEMS_ORDER.get((Object)this.getNS()));
    }

    protected final ODXMLDocument getParent() {
        return this.parent;
    }

    private final XMLVersion getNS() {
        return this.getParent().getVersion();
    }

    public final String getGenerator() {
        return this.getMetaChild("generator").getTextTrim();
    }

    public final void setGenerator(String string) {
        this.getMetaChild("generator").setText(string);
    }

    public final String getTitle() {
        return this.getDCChild("title").getTextTrim();
    }

    public final void setTitle(String string) {
        this.getDCChild("title").setText(string);
    }

    public final String getDescription() {
        return this.getDCChild("description").getTextTrim();
    }

    public final void setDescription(String string) {
        this.getDCChild("description").setText(string);
    }

    public final String getSubject() {
        return this.getDCChild("subject").getTextTrim();
    }

    public final void setSubject(String string) {
        this.getDCChild("subject").setText(string);
    }

    public final List<String> getKeywords() {
        List<Element> list = this.getKeywordElems();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Element element : list) {
            arrayList.add(element.getTextTrim());
        }
        return arrayList;
    }

    private List<Element> getKeywordElems() {
        return this.getElement().getChildren("keyword", this.getNS().getMETA());
    }

    public final void setKeywords(List<String> list) {
        this.getKeywordElems().clear();
        for (String string : list) {
            this.childCreator.addChild(this.getNS().getMETA(), "keyword").setText(string);
        }
    }

    public final String getInitialCreator() {
        return this.getMetaChild("initial-creator").getTextTrim();
    }

    public final void setInitialCreator(String string) {
        this.getMetaChild("initial-creator").setText(string);
    }

    public final String getCreator() {
        return this.getDCChild("creator").getTextTrim();
    }

    public final void setCreator(String string) {
        this.getDCChild("creator").setText(string);
    }

    public final Calendar getCreationDate() {
        return this.getDateChild("creation-date", this.getNS().getMETA());
    }

    public final void setCreationDate(Calendar calendar) {
        this.setDateChild(calendar, "creation-date", this.getNS().getMETA());
    }

    public final Calendar getModifDate() {
        return this.getDateChild("date", this.getNS().getNS("dc"));
    }

    public final void setModifDate(Calendar calendar) {
        this.setDateChild(calendar, "date", this.getNS().getNS("dc"));
    }

    public final String getLanguage() {
        return this.getDCChild("language").getTextTrim();
    }

    public final void setLanguage(String string) {
        this.getDCChild("language").setText(string);
    }

    public final int getEditingCycles() {
        return Integer.parseInt(this.getMetaChild("editing-cycles").getTextTrim());
    }

    public final void setInitialCreator(int n) {
        this.getMetaChild("editing-cycles").setText(n + "");
    }

    public final ODUserDefinedMeta getUserMeta(String string) {
        return this.getUserMeta(string, false);
    }

    public final ODUserDefinedMeta getUserMeta(String string, boolean bl) {
        Element element = ODUserDefinedMeta.getElement(this.getElement(), string, this.getNS());
        if (element != null) {
            return new ODUserDefinedMeta(element, this.getParent());
        }
        if (bl) {
            ODUserDefinedMeta oDUserDefinedMeta = ODUserDefinedMeta.create(string, this.getParent());
            this.getElement().addContent(oDUserDefinedMeta.getElement());
            return oDUserDefinedMeta;
        }
        return null;
    }

    public final void removeUserMeta(String string) {
        ODUserDefinedMeta oDUserDefinedMeta = this.getUserMeta(string, false);
        if (oDUserDefinedMeta != null) {
            oDUserDefinedMeta.getElement().detach();
        }
    }

    public final List<String> getUserMetaNames() throws JDOMException {
        return ODUserDefinedMeta.getNames(this.getElement(), this.getNS());
    }

    public final Element getMetaChild(String string) {
        return this.getChild(string, this.getNS().getMETA());
    }

    public final Element getDCChild(String string) {
        return this.getChild(string, this.getNS().getNS("dc"));
    }

    private final Element getChild(String string, Namespace namespace) {
        return this.childCreator.getChild(namespace, string, true);
    }

    private final Calendar getDateChild(String string, Namespace namespace) {
        String string2 = this.getChild(string, namespace).getTextTrim();
        if (string2.length() == 0) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime((Date)OOUtils.DATE_FORMAT.parseObject(string2));
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("wrong date: " + string2, parseException);
        }
        return calendar;
    }

    private final void setDateChild(Calendar calendar, String string, Namespace namespace) {
        this.getChild(string, namespace).setText(OOUtils.DATE_FORMAT.format(calendar.getTime()));
    }

    static {
        ELEMS_ORDER.put(XMLVersion.getOOo(), ODMeta.createChildren(XMLVersion.getOOo()));
        ELEMS_ORDER.put(XMLVersion.getOD(), ODMeta.createChildren(XMLVersion.getOD()));
    }
}

