/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.Format;
import java.text.SimpleDateFormat;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.util.FileUtils;
import org.jopendocument.util.FormatGroup;
import org.jopendocument.util.JDOMUtils;
import org.jopendocument.util.XMLDateFormat;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class OOUtils {
    public static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("'PT'HH'H'mm'M'ss'S'");
    public static final Format DATE_FORMAT = new FormatGroup(new XMLDateFormat(), new SimpleDateFormat("yyyy-MM-dd'T'HH':'mm':'ss"), new SimpleDateFormat("yyyy-MM-dd"));
    private static final String[] executables = new String[]{"ooffice2", "ooffice", "soffice"};

    public static void open(File file) throws IOException {
        FileUtils.open(file, executables);
    }

    public static SAXBuilder getBuilder() {
        SAXBuilder sAXBuilder = new SAXBuilder();
        sAXBuilder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) {
                if (string2.endsWith(".dtd")) {
                    InputSource inputSource = new InputSource();
                    inputSource.setCharacterStream(new StringReader(""));
                    return inputSource;
                }
                return null;
            }
        });
        return sAXBuilder;
    }

    public static SAXBuilder getBuilderLoadDTD() {
        SAXBuilder sAXBuilder = new SAXBuilder(){

            public Document build(InputSource inputSource) throws JDOMException, IOException {
                inputSource.setSystemId(OOUtils.class.getResource("oofficeDTDs/").toExternalForm());
                return super.build(inputSource);
            }
        };
        return sAXBuilder;
    }

    public static Document parseDocument(String string) throws JDOMException {
        return JDOMUtils.parseStringDocument(string, OOUtils.getBuilder());
    }

    public static final XPath getXPath(String string, XMLVersion xMLVersion) throws JDOMException {
        XPath xPath = XPath.newInstance(string);
        for (Namespace namespace : xMLVersion.getALL()) {
            xPath.addNamespace(namespace);
        }
        return xPath;
    }

    public static String encodeRGB(Color color) {
        return "#" + Integer.toHexString(color.getRGB()).substring(2).toUpperCase();
    }

    public static Color decodeRGB(String string) {
        return string == null ? null : Color.decode(string.trim());
    }
}

