/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.Row;
import org.jopendocument.dom.spreadsheet.TableCalcNode;
import org.jopendocument.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell<D extends ODDocument>
extends TableCalcNode<CellStyle, D> {
    private static final Pattern multiSpacePattern = Pattern.compile("[\t\r\n ]+");
    private static boolean OO_MODE = true;
    private final Row<D> row;

    public static void setTextValueMode(boolean bl) {
        OO_MODE = bl;
    }

    public static boolean getTextValueMode() {
        return OO_MODE;
    }

    static final Element createEmpty(XMLVersion xMLVersion) {
        return Cell.createEmpty(xMLVersion, 1);
    }

    static final Element createEmpty(XMLVersion xMLVersion, int n) {
        Element element = new Element("table-cell", xMLVersion.getTABLE());
        if (n > 1) {
            element.setAttribute("number-columns-repeated", n + "", xMLVersion.getTABLE());
        }
        return element;
    }

    Cell(Row<D> row, Element element) {
        super(row.getODDocument(), element, CellStyle.class);
        this.row = row;
    }

    protected final Row<D> getRow() {
        return this.row;
    }

    protected final XMLVersion getNS() {
        return this.getODDocument().getVersion();
    }

    protected final Namespace getValueNS() {
        XMLVersion xMLVersion = this.getNS();
        return xMLVersion == XMLVersion.OD ? xMLVersion.getOFFICE() : xMLVersion.getTABLE();
    }

    protected final String getType() {
        return this.getElement().getAttributeValue("value-type", this.getValueNS());
    }

    public final ODValueType getValueType() {
        String string = this.getType();
        return string == null ? null : ODValueType.get(string);
    }

    @Override
    protected String getStyleName() {
        throw new UnsupportedOperationException("cannot resolve our style, use MutableCell");
    }

    String getStyleAttr() {
        return this.getElement().getAttributeValue("style-name", this.getNS().getTABLE());
    }

    private final String getValue(String string) {
        return this.getElement().getAttributeValue(string, this.getValueNS());
    }

    public Object getValue() {
        ODValueType oDValueType = this.getValueType();
        if (oDValueType == null || oDValueType == ODValueType.STRING) {
            String string;
            String string2 = string = oDValueType == null ? null : this.getValue(oDValueType.getValueAttribute());
            if (string != null) {
                return string;
            }
            return this.getTextValue();
        }
        return oDValueType.parse(this.getValue(oDValueType.getValueAttribute()));
    }

    public String getTextValue() {
        return this.getTextValue(Cell.getTextValueMode());
    }

    public String getTextValue(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : this.getElement().getChildren()) {
            Element element = (Element)e;
            if (!element.getName().equals("p") && !element.getName().equals("h") || !element.getNamespacePrefix().equals("text")) continue;
            arrayList.add(this.getStringValue(element, bl));
        }
        return CollectionUtils.join(arrayList, "\n");
    }

    private String getStringValue(Element element, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Namespace namespace = element.getNamespace();
        boolean bl2 = false;
        Iterator iterator = element.getDescendants();
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            if (e instanceof Text) {
                object = multiSpacePattern.matcher(((Text)e).getText()).replaceAll(" ");
                if (!bl && ((String)object).startsWith(" ") && (bl2 || stringBuilder.length() == 0)) {
                    stringBuilder.append(((String)object).substring(1));
                } else {
                    stringBuilder.append((String)object);
                }
                bl2 = ((String)object).endsWith(" ");
                continue;
            }
            if (!(e instanceof Element)) continue;
            object = (Element)e;
            if (((Element)object).getName().equals("tab") && ((Element)object).getNamespace().equals(namespace)) {
                stringBuilder.append("\t");
                continue;
            }
            if (((Element)object).getName().equals("line-break") && ((Element)object).getNamespace().equals(namespace)) {
                stringBuilder.append("\n");
                continue;
            }
            if (!((Element)object).getName().equals("s") || !((Element)object).getNamespace().equals(namespace)) continue;
            int n = Integer.valueOf(((Element)object).getAttributeValue("c", namespace, "1"));
            char[] cArray = new char[n];
            Arrays.fill(cArray, ' ');
            stringBuilder.append(cArray);
        }
        if (!bl && bl2) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public boolean isValid() {
        return !this.getElement().getName().equals("covered-table-cell");
    }

    public final int getColumnsSpanned() {
        return Integer.parseInt(this.getElement().getAttributeValue("number-columns-spanned", this.getNS().getTABLE(), "1"));
    }

    public final int getRowsSpanned() {
        return Integer.parseInt(this.getElement().getAttributeValue("number-rows-spanned", this.getNS().getTABLE(), "1"));
    }

    protected final boolean coversOtherCells() {
        return this.getColumnsSpanned() > 1 || this.getRowsSpanned() > 1;
    }
}

