/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.MutableCell;
import org.jopendocument.dom.spreadsheet.RowStyle;
import org.jopendocument.dom.spreadsheet.Table;
import org.jopendocument.dom.spreadsheet.TableCalcNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Row<D extends ODDocument>
extends TableCalcNode<RowStyle, D> {
    private final Table<D> parent;
    private final int index;
    private final List<Cell<D>> cells;

    static Element createEmpty(XMLVersion xMLVersion) {
        return new Element("table-row", xMLVersion.getTABLE());
    }

    Row(Table<D> table, Element element, int n) {
        super(table.getODDocument(), element, RowStyle.class);
        this.parent = table;
        this.index = n;
        this.cells = new ArrayList<Cell<D>>();
        for (Element element2 : this.getCellElements()) {
            this.addCellElem(element2);
        }
    }

    protected final Table<D> getSheet() {
        return this.parent;
    }

    final int getY() {
        return this.index;
    }

    final int getX(MutableCell<D> mutableCell) {
        return this.cells.indexOf(mutableCell);
    }

    private void addCellElem(Element element) {
        Cell cell = new Cell(this, element);
        this.cells.add(cell);
        String string = element.getAttributeValue("number-columns-repeated", this.getSheet().getTABLE());
        if (string != null) {
            int n = Integer.parseInt(string) - 1;
            for (int i = 0; i < n; ++i) {
                this.cells.add(cell);
            }
        }
    }

    private List<Element> getCellElements() {
        return this.getElement().getChildren();
    }

    protected final Cell<D> getCellAt(int n) {
        return this.cells.get(n);
    }

    protected final Cell<D> getValidCellAt(int n) {
        Cell<D> cell = this.getCellAt(n);
        if (!cell.isValid()) {
            throw new IllegalArgumentException("invalid cell " + cell);
        }
        return cell;
    }

    public final MutableCell<D> getMutableCellAt(int n) {
        Cell<D> cell = this.getValidCellAt(n);
        if (!(cell instanceof MutableCell)) {
            Element element = cell.getElement();
            String string = element.getAttributeValue("number-columns-repeated", this.getSheet().getTABLE());
            if (string != null) {
                int n2 = Integer.parseInt(string);
                int n3 = this.cells.indexOf(cell);
                int n4 = n3 + n2 - 1;
                int n5 = n - n3;
                int n6 = n4 - n;
                this.casse(element, n3, n5, true);
                element.removeAttribute("number-columns-repeated", this.getSheet().getTABLE());
                this.casse(element, n + 1, n6, false);
            }
            this.cells.set(n, new MutableCell(this, element));
        }
        return (MutableCell)this.getValidCellAt(n);
    }

    private final void casse(Element element, int n, int n2, boolean bl) {
        if (n2 > 0) {
            Element element2 = (Element)element.clone();
            element.getParentElement().addContent(element.getParent().indexOf(element) + (bl ? 0 : 1), element2);
            element2.setAttribute("number-columns-repeated", n2 + "", this.getSheet().getTABLE());
            Cell cell = new Cell(this, element2);
            for (int i = 0; i < n2; ++i) {
                this.cells.set(n + i, cell);
            }
        }
    }

    void columnCountChanged() {
        int n = this.getSheet().getColumnCount() - this.cells.size();
        if (n < 0) {
            throw new IllegalStateException("should have used Table.removeColumn()");
        }
        if (n > 0) {
            Element element = Cell.createEmpty(this.getSheet().getODDocument().getVersion(), n);
            this.getElement().addContent(element);
            this.addCellElem(element);
        }
        if (this.cells.size() != this.getSheet().getColumnCount()) {
            throw new IllegalStateException();
        }
    }

    void checkRemove(int n, int n2) {
        if (n2 > this.cells.size()) {
            throw new IndexOutOfBoundsException(n2 + " > " + this.cells.size());
        }
        if (!this.getCellAt(n).isValid()) {
            throw new IllegalArgumentException("unable to remove covered cell at " + n);
        }
    }

    void removeCells(int n, int n2) {
        int n3;
        this.checkRemove(n, n2);
        this.getMutableCellAt(n).unmerge();
        if (n2 < this.cells.size()) {
            if (!this.getCellAt(n2 - 1).isValid()) {
                n3 = n2 - 2;
                while (!this.getCellAt(n3).isValid()) {
                    --n3;
                }
                this.getMutableCellAt(n3).unmerge();
            }
            this.getMutableCellAt(n2 - 1).unmerge();
        }
        for (n3 = n; n3 < n2; ++n3) {
            this.cells.remove(n).getElement().detach();
        }
    }
}

