/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.model.office.OfficeForms;
import org.jopendocument.model.office.OfficeSpreadsheet;
import org.jopendocument.model.style.StyleMasterPage;
import org.jopendocument.model.style.StylePageLayout;
import org.jopendocument.model.style.StylePageLayoutProperties;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.table.TableScenario;
import org.jopendocument.model.table.TableShapes;
import org.jopendocument.model.table.TableTableColumn;
import org.jopendocument.model.table.TableTableRow;
import org.jopendocument.model.table.TableTableSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableTable {
    Vector<TableTableColumn> allColumns;
    ArrayList<TableTableColumn> columns = new ArrayList();
    protected OfficeForms officeForms;
    private int printStartCol = 0;
    private int printStartRow = 0;
    private int printStopCol = 0;
    private int printStopRow = 0;
    ArrayList<TableTableRow> rows = new ArrayList();
    private OfficeSpreadsheet spreadsheet;
    protected String tableAutomaticPrintRange;
    protected String tableName;
    protected String tablePrintRanges;
    protected String tableProtected;
    protected String tableProtectionKey;
    protected TableScenario tableScenario;
    protected TableShapes tableShapes;
    protected String tableStyleName;
    protected List<Object> tableTableColumnsOrTableTableColumnOrTableTableColumnGroupOrTableTableHeaderColumns;
    protected List<Object> tableTableRowsOrTableTableRowOrTableTableRowGroupOrTableTableHeaderRows;
    protected TableTableSource tableTableSource;

    public void addColumn(TableTableColumn tableTableColumn) {
        for (int i = 0; i < tableTableColumn.getTableNumberColumnsRepeated(); ++i) {
            this.columns.add(tableTableColumn);
        }
        tableTableColumn.setTable(this);
    }

    public void addRow(TableTableRow tableTableRow) {
        for (int i = 0; i < tableTableRow.getTableNumberRowsRepeated(); ++i) {
            this.rows.add(tableTableRow);
        }
        tableTableRow.setTable(this);
    }

    public StyleStyle getCellStyle(String string) {
        return this.spreadsheet.getBody().getDocument().getAutomaticStyles().getCellStyle(string);
    }

    public TableTableColumn getColumn(int n) {
        return this.columns.get(n);
    }

    public TableTableColumn getColumnAtPosition(int n) {
        if (this.allColumns == null) {
            this.allColumns = new Vector();
            for (int i = 0; i < this.columns.size(); ++i) {
                TableTableColumn tableTableColumn = this.getColumn(i);
                for (int j = 0; j < tableTableColumn.getTableNumberColumnsRepeated(); ++j) {
                    this.allColumns.add(tableTableColumn);
                }
            }
        }
        return this.allColumns.get(n);
    }

    public List<TableTableColumn> getColumns() {
        return this.columns;
    }

    public List<TableTableColumn> getColumnsInRange(int n, int n2) {
        Vector<TableTableColumn> vector = new Vector<TableTableColumn>(n2 - n + 1);
        for (int i = n; i <= n2; ++i) {
            vector.add(this.columns.get(i));
        }
        return vector;
    }

    public StyleStyle getColumnStyle(String string) {
        return this.spreadsheet.getBody().getDocument().getAutomaticStyles().getColumnStyle(string);
    }

    public int getHeight(int n, int n2) {
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            TableTableRow tableTableRow = this.rows.get(i);
            n3 += tableTableRow.getHeight();
        }
        return n3;
    }

    public OfficeForms getOfficeForms() {
        return this.officeForms;
    }

    public StylePageLayoutProperties getPageLayoutProperties() {
        if (this.tableStyleName == null) {
            return null;
        }
        OpenDocument openDocument = this.getSpreadsheet().getBody().getDocument();
        StyleStyle styleStyle = openDocument.getAutomaticStyles().getTableStyle(this.tableStyleName);
        String string = styleStyle.getMasterPageName();
        StyleMasterPage styleMasterPage = openDocument.getMasterStyles().getMasterPageFromStyleName(string);
        String string2 = styleMasterPage.getStylePageLayoutName();
        StylePageLayout stylePageLayout = openDocument.getAutomaticStyles().getStylePageLayoutFromStyleName(string2);
        return stylePageLayout.getPageLayoutProperties();
    }

    public int getPrintHeight() {
        int n = 0;
        List<TableTableRow> list = this.getRowsInRange(this.getPrintStartRow(), this.getPrintStopRow());
        for (TableTableRow tableTableRow : list) {
            n += tableTableRow.getHeight();
        }
        return n;
    }

    public int getPrintHeight(double d) {
        int n = 0;
        List<TableTableRow> list = this.getRowsInRange(this.getPrintStartRow(), this.getPrintStopRow());
        for (TableTableRow tableTableRow : list) {
            n = (int)((double)n + (double)tableTableRow.getHeight() / d);
        }
        return n;
    }

    public int getPrintStartCol() {
        return this.printStartCol;
    }

    public int getPrintStartRow() {
        return this.printStartRow;
    }

    public int getPrintStopCol() {
        return this.printStopCol;
    }

    public int getPrintStopRow() {
        return this.printStopRow;
    }

    public int getPrintWidth() {
        int n = 0;
        List<TableTableColumn> list = this.getColumnsInRange(this.getPrintStartCol(), this.getPrintStopCol());
        for (TableTableColumn tableTableColumn : list) {
            n += tableTableColumn.getWidth();
        }
        return n;
    }

    public int getPrintWidth(double d) {
        int n = 0;
        List<TableTableColumn> list = this.getColumnsInRange(this.getPrintStartCol(), this.getPrintStopCol());
        for (TableTableColumn tableTableColumn : list) {
            n = (int)((double)n + (double)tableTableColumn.getWidth() / d);
        }
        return n;
    }

    public List<TableTableRow> getRows() {
        return this.rows;
    }

    public List<TableTableRow> getRowsInRange(int n, int n2) {
        ArrayList<TableTableRow> arrayList = new ArrayList<TableTableRow>(n2 - n + 1);
        for (int i = n; i <= n2; ++i) {
            if (i >= this.rows.size()) continue;
            arrayList.add(this.rows.get(i));
        }
        return arrayList;
    }

    public StyleStyle getRowStyle(String string) {
        return this.spreadsheet.getBody().getDocument().getAutomaticStyles().getRowStyle(string);
    }

    public OfficeSpreadsheet getSpreadsheet() {
        return this.spreadsheet;
    }

    public String getTableAutomaticPrintRange() {
        return this.tableAutomaticPrintRange;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableProtected() {
        if (this.tableProtected == null) {
            return "false";
        }
        return this.tableProtected;
    }

    public String getTableProtectionKey() {
        return this.tableProtectionKey;
    }

    public TableScenario getTableScenario() {
        return this.tableScenario;
    }

    public TableShapes getTableShapes() {
        return this.tableShapes;
    }

    public String getTableStyleName() {
        return this.tableStyleName;
    }

    public TableTableSource getTableTableSource() {
        return this.tableTableSource;
    }

    public void setOfficeForms(OfficeForms officeForms) {
        this.officeForms = officeForms;
    }

    public void setSpreadsheet(OfficeSpreadsheet officeSpreadsheet) {
        this.spreadsheet = officeSpreadsheet;
    }

    public void setTableAutomaticPrintRange(String string) {
        this.tableAutomaticPrintRange = string;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setTablePrintRanges(String string) {
        int n;
        char c;
        if (string == null || !string.contains(":")) {
            throw new IllegalArgumentException("ranges is null");
        }
        this.tablePrintRanges = string;
        int n2 = string.indexOf(58);
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        String string4 = string2.substring(string2.indexOf(46) + 1);
        String string5 = string3.substring(string3.indexOf(46) + 1);
        string4 = this.removeDollars(string4);
        string5 = this.removeDollars(string5);
        int n3 = 0;
        for (int i = string4.length() - 1; i >= 0; --i) {
            c = string4.charAt(i);
            if (Character.isLetter((int)c)) {
                n = c - 65 + 1;
                this.printStartCol = (int)((double)this.printStartCol + (double)n * Math.pow(26.0, n3));
                ++n3;
                continue;
            }
            this.printStartRow = i;
        }
        String string6 = string4.substring(n3);
        this.printStartRow = Integer.valueOf(string6) - 1;
        --this.printStartCol;
        n3 = 0;
        for (int i = string5.length() - 1; i >= 0; --i) {
            c = string5.charAt(i);
            if (Character.isLetter((int)c)) {
                n = c - 65 + 1;
                this.printStopCol = (int)((double)this.printStopCol + (double)n * Math.pow(26.0, n3));
                ++n3;
                continue;
            }
            this.printStopRow = i;
        }
        String string7 = string5.substring(n3);
        this.printStopRow = Integer.valueOf(string7) - 1;
        --this.printStopCol;
    }

    private final String removeDollars(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '$') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public void setTableProtected(String string) {
        this.tableProtected = string;
    }

    public void setTableProtectionKey(String string) {
        this.tableProtectionKey = string;
    }

    public void setTableScenario(TableScenario tableScenario) {
        this.tableScenario = tableScenario;
    }

    public void setTableShapes(TableShapes tableShapes) {
        this.tableShapes = tableShapes;
    }

    public void setTableStyleName(String string) {
        this.tableStyleName = string;
    }

    public void setTableTableSource(TableTableSource tableTableSource) {
        this.tableTableSource = tableTableSource;
    }

    public String toString() {
        return "TableTable: print:" + this.getPrintStartCol() + "," + this.getPrintStartRow() + " : " + this.getPrintStopCol() + "," + this.getPrintStopRow();
    }
}

