/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.panel.Messages;
import org.jopendocument.print.DocumentPrinter;
import org.jopendocument.renderer.ODTRenderer;

public class ODSViewerPanel
extends JPanel {
    private static final long serialVersionUID = -6113257667157151508L;
    private final ODTRenderer renderer;
    private int mode;
    private int zoom = 100;
    private static final int MODE_PAGE = 0;
    private static final int MODE_WIDTH = 1;
    private static final int MODE_ZOOM = 2;
    private JScrollPane scroll;
    private final JPanel viewer = new JPanel();
    private final JTextField textFieldZoomValue = new JTextField(5);
    private int currentPageIndex = 0;

    public ODSViewerPanel(OpenDocument openDocument) {
        this(openDocument, null);
    }

    public ODSViewerPanel(OpenDocument openDocument, boolean bl) {
        this(openDocument, null, bl);
    }

    public ODSViewerPanel(OpenDocument openDocument, DocumentPrinter documentPrinter) {
        this(openDocument, documentPrinter, true);
    }

    public ODSViewerPanel(final OpenDocument openDocument, final DocumentPrinter documentPrinter, boolean bl) {
        JComponent jComponent;
        Toolkit.getDefaultToolkit().setDynamicLayout(false);
        this.setOpaque(false);
        this.renderer = new ODTRenderer(openDocument);
        this.renderer.setIgnoreMargins(bl);
        this.updateMode(2, this.zoom);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(Messages.getString("ODSViewerPanel.normalSize"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ODSViewerPanel.this.updateMode(2, 100);
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("ODSViewerPanel.fitPage"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ODSViewerPanel.this.mode != 0) {
                    double d;
                    int n = (int)ODSViewerPanel.this.scroll.getViewportBorderBounds().getWidth();
                    int n2 = (int)ODSViewerPanel.this.scroll.getViewportBorderBounds().getHeight();
                    double d2 = ODSViewerPanel.this.renderer.getPageWidth() / (double)n;
                    double d3 = d = ODSViewerPanel.this.renderer.getPageHeight() / (double)n2;
                    if (d2 > d) {
                        d3 = d2;
                    }
                    ODSViewerPanel.this.updateMode(0, (int)(36000.0 / d3));
                }
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(Messages.getString("ODSViewerPanel.fitWidth"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = (int)ODSViewerPanel.this.scroll.getViewportBorderBounds().getWidth();
                double d = ODSViewerPanel.this.renderer.getPageWidth() / (double)n;
                ODSViewerPanel.this.updateMode(1, (int)(36000.0 / d));
            }
        });
        jPanel.add(jButton3);
        JButton jButton4 = new JButton("-");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ODSViewerPanel.this.zoom > 30) {
                    ODSViewerPanel.this.updateMode(ODSViewerPanel.this.mode, ODSViewerPanel.this.zoom - 20);
                }
            }
        });
        jPanel.add(jButton4);
        this.textFieldZoomValue.setEditable(false);
        jPanel.add(this.textFieldZoomValue);
        JButton jButton5 = new JButton("+");
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ODSViewerPanel.this.zoom + 20;
                if (n > 400) {
                    n = 400;
                }
                ODSViewerPanel.this.updateMode(ODSViewerPanel.this.mode, n);
            }
        });
        jPanel.add(jButton5);
        this.viewer.setOpaque(false);
        this.viewer.setBackground(Color.DARK_GRAY);
        this.viewer.setLayout(null);
        this.renderer.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        this.viewer.add(this.renderer);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.scroll = new JScrollPane(this.viewer);
        this.scroll.setOpaque(false);
        this.scroll.getHorizontalScrollBar().setUnitIncrement(30);
        this.scroll.getVerticalScrollBar().setUnitIncrement(30);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.scroll.setHorizontalScrollBarPolicy(32);
        ((JComponent)this.scroll.getViewport().getView()).setOpaque(false);
        this.add((Component)this.scroll, "Center");
        this.updateMode(2, this.zoom);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ODSViewerPanel.this.updateMode(ODSViewerPanel.this.mode, ODSViewerPanel.this.zoom);
            }
        });
        if (openDocument.getPrintedPageCount() > 1) {
            jComponent = new JTextField(5);
            ((JTextField)jComponent).setHorizontalAlignment(0);
            JButton jButton6 = new JButton("<");
            jButton6.addActionListener(new ActionListener((JTextField)jComponent){
                final /* synthetic */ JTextField val$page;
                {
                    this.val$page = jTextField;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ODSViewerPanel.this.currentPageIndex > 0) {
                        ODSViewerPanel.this.currentPageIndex--;
                        ODSViewerPanel.this.updatePage(ODSViewerPanel.this.currentPageIndex);
                        ODSViewerPanel.this.updatePageCount(openDocument, this.val$page);
                    }
                }
            });
            JButton jButton7 = new JButton(">");
            jButton7.addActionListener(new ActionListener((JTextField)jComponent){
                final /* synthetic */ JTextField val$page;
                {
                    this.val$page = jTextField;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ODSViewerPanel.this.currentPageIndex < openDocument.getPrintedPageCount() - 1) {
                        ODSViewerPanel.this.currentPageIndex++;
                        ODSViewerPanel.this.updatePage(ODSViewerPanel.this.currentPageIndex);
                        ODSViewerPanel.this.updatePageCount(openDocument, this.val$page);
                    }
                }
            });
            jPanel.add(jButton6);
            this.updatePageCount(openDocument, (JTextField)jComponent);
            jPanel.add(jComponent);
            jPanel.add(jButton7);
        }
        if (documentPrinter != null) {
            jComponent = new JButton(Messages.getString("ODSViewerPanel.print"));
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    documentPrinter.print(openDocument);
                }
            });
            jPanel.add(jComponent);
        }
    }

    private void updatePageCount(OpenDocument openDocument, JTextField jTextField) {
        jTextField.setText(this.currentPageIndex + 1 + "/" + openDocument.getPrintedPageCount());
    }

    protected void updatePage(int n) {
        this.renderer.setCurrentPage(n);
    }

    private void updateMode(int n, int n2) {
        this.mode = n;
        this.zoom = n2;
        this.textFieldZoomValue.setText(this.zoom + " %");
        this.renderer.setResizeFactor(36000 / n2);
        int n3 = this.renderer.getPageWidthInPixel();
        int n4 = this.renderer.getPageHeightInPixel();
        int n5 = 0;
        int n6 = 0;
        if (this.scroll != null) {
            n5 = (this.scroll.getViewportBorderBounds().width - n3) / 2;
            n6 = (this.scroll.getViewportBorderBounds().height - n4) / 2;
        }
        if (n6 > 10) {
            n6 = 10;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        this.renderer.setLocation(n5, n6);
        Dimension dimension = new Dimension(n3, n4);
        this.viewer.setPreferredSize(dimension);
        this.viewer.revalidate();
        this.repaint();
    }

    public ODTRenderer getRenderer() {
        return this.renderer;
    }
}

