/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jopendocument.io.ODTContentExtractor;

public class ContentFinder
extends JFrame {
    private static final long serialVersionUID = -8535510980733968129L;
    private File selectedDir;
    final JTextField textFieldFolder = new JTextField(200);

    public ContentFinder() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel("Explore folder:"), "West");
        jPanel.add((Component)this.textFieldFolder, "Center");
        JButton jButton = new JButton("Select folder");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ContentFinder.this.openSelectionDialog();
            }
        });
        jPanel.add((Component)jButton, "East");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)new JLabel("Find text:"), "West");
        final JTextField jTextField = new JTextField(200);
        jPanel2.add((Component)jTextField, "Center");
        final JLabel jLabel = new JLabel("");
        jPanel2.add((Component)jLabel, "South");
        final JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        final JButton jButton2 = new JButton("Find");
        jButton2.setEnabled(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel3.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel3.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel3.add((Component)jButton2, gridBagConstraints);
        this.setContentPane(jPanel3);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton2.setEnabled(false);
                if (ContentFinder.this.selectedDir == null) {
                    ContentFinder.this.openSelectionDialog();
                }
                Runnable runnable = new Runnable(){

                    public void run() {
                        if (ContentFinder.this.selectedDir != null && ContentFinder.this.selectedDir.isDirectory()) {
                            File[] fileArray = ContentFinder.this.selectedDir.listFiles();
                            jTextArea.setText("");
                            for (int i = 0; i < fileArray.length; ++i) {
                                File file = fileArray[i];
                                String string = file.getName();
                                if (string.endsWith(".sxw") || string.endsWith(".sxc") || string.endsWith(".ods") || string.endsWith(".odt")) {
                                    this.updateStatus("Looking at:" + file.getAbsolutePath());
                                    ODTContentExtractor oDTContentExtractor = new ODTContentExtractor(file);
                                    try {
                                        oDTContentExtractor.load();
                                    }
                                    catch (IOException iOException) {
                                        iOException.printStackTrace();
                                    }
                                    if (oDTContentExtractor.containsIgnoreCase(jTextField.getText())) {
                                        jTextArea.append(file.getAbsolutePath() + "\n");
                                    }
                                }
                                this.updateStatus("Done");
                            }
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                jButton2.setEnabled(true);
                            }
                        });
                    }

                    private void updateStatus(final String string) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                jLabel.setText(string);
                            }
                        });
                    }
                };
                Thread thread = new Thread(runnable);
                thread.start();
            }
        });
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.checkDocument();
            }

            private void checkDocument() {
                if (jTextField.getText().trim().length() == 0) {
                    jButton2.setEnabled(false);
                } else {
                    jButton2.setEnabled(true);
                }
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.checkDocument();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.checkDocument();
            }
        });
        this.textFieldFolder.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.checkDocument();
            }

            private void checkDocument() {
                String string = ContentFinder.this.textFieldFolder.getText().trim();
                File file = new File(string);
                if (file.exists() && file.isDirectory()) {
                    ContentFinder.this.selectedDir = file;
                    ContentFinder.this.textFieldFolder.setBackground(Color.WHITE);
                } else {
                    ContentFinder.this.textFieldFolder.setBackground(new Color(255, 220, 110));
                }
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.checkDocument();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.checkDocument();
            }
        });
    }

    protected void openSelectionDialog() {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setApproveButtonText("Look in folder...");
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null && file.isDirectory()) {
            this.selectedDir = file;
            this.textFieldFolder.setText(file.getAbsolutePath());
        }
    }

    public static void main(String[] stringArray) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        ContentFinder contentFinder = new ContentFinder();
        contentFinder.setDefaultCloseOperation(3);
        contentFinder.setSize(new Dimension(800, 400));
        contentFinder.setLocation(100, 100);
        contentFinder.setVisible(true);
    }
}

