/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static String firstUpThenLow(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (string.length() == 1) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }

    public static String firstUp(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (string.length() == 1) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static final List<String> fastSplit(String string, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != c) continue;
            arrayList.add(new String(cArray, n2, i - n2));
            n2 = i + 1;
        }
        if (n2 < n) {
            arrayList.add(new String(cArray, n2, n - n2));
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Escaper {
        private final char esc;
        private final Map<Character, Character> substitution;
        private final Map<Character, Character> inv;

        public Escaper(char c, char c2) {
            this.esc = c;
            this.substitution = new LinkedHashMap<Character, Character>();
            this.inv = new HashMap<Character, Character>();
            this.add(c, c2);
        }

        public Escaper add(char c, char c2) {
            if (this.inv.containsKey(Character.valueOf(c2))) {
                throw new IllegalArgumentException(c2 + " already replaces " + this.inv.get(Character.valueOf(c2)));
            }
            this.substitution.put(Character.valueOf(c), Character.valueOf(c2));
            this.inv.put(Character.valueOf(c2), Character.valueOf(c));
            return this;
        }

        public final Set<Character> getEscapedChars() {
            HashSet<Character> hashSet = new HashSet<Character>(this.substitution.keySet());
            hashSet.remove(Character.valueOf(this.esc));
            return hashSet;
        }

        public final String escape(String string) {
            String string2 = string;
            for (Character c : this.substitution.keySet()) {
                string2 = string2.replace(c + "", this.getEscaped(c));
            }
            return string2;
        }

        private String getEscaped(Character c) {
            return this.esc + "" + this.substitution.get(c);
        }

        public final String unescape(String string) {
            String string2 = string;
            ArrayList<Character> arrayList = new ArrayList<Character>(this.substitution.keySet());
            Collections.reverse(arrayList);
            for (Character c : arrayList) {
                string2 = string2.replaceAll(this.getEscaped(c), c + "");
            }
            return string2;
        }

        public boolean equals(Object object) {
            if (object instanceof Escaper) {
                Escaper escaper = (Escaper)object;
                return this.esc == escaper.esc && ((Object)this.substitution).equals(escaper.substitution);
            }
            return false;
        }

        public int hashCode() {
            return this.esc + ((Object)this.substitution).hashCode();
        }
    }
}

