/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.recebimentosdeterceiros;

import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.controle.recebimentosdeterceiros.ControleImpressaoRecebimentos;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasEvent;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasListener;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfaceGerenciadorListas;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginCadastro;
import br.com.bb.plugins.negocio.comum.Identificacao;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ConvenenteDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ConvenioDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.IdentificadorDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.RecebimentoDBT;
import br.com.bb.plugins.persistencia.comum.ConexaoBancoDados;
import br.com.bb.plugins.persistencia.comum.IdentificacaoBD;
import br.com.bb.plugins.persistencia.comum.UfBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ConvenenteDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ConvenioDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.IdentificadorDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.RecebimentoDBTBD;
import br.com.bb.plugins.utilitarios.Util;
import com.ibm.webrunner.widget.MultiColumnListbox;
import java.sql.SQLException;
import java.util.Vector;

public class ControleConvenente
extends Roteador
implements GerenciadorListasListener {
    private static ControleConvenente controleConvenente = null;
    private IInterfaceGerenciadorListas interfaceLista = null;
    private ConvenenteDBT convenenteDBT;
    private ConvenioDBT convenioDBT;

    private ControleConvenente() {
    }

    public void abrirConvenenteCadastro() throws Throwable {
        this.convenenteDBT = new ConvenenteDBT();
        this.getConvenenteDBT().getConvenente().getPessoa().setCodigoPessoa(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
        this.obterConvenenteDBT(this.getConvenenteDBT());
        IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("ConvenenteCadastro", null);
        interfacePluginCadastro.alterar(this.getConvenenteDBT());
        interfacePluginCadastro.exibir();
    }

    public void abrirConvenenteCadastro(Object[] meuObjeto, char indicadorOperacao) throws Throwable {
        this.convenenteDBT = new ConvenenteDBT();
        this.getConvenenteDBT().getConvenente().getPessoa().setCodigoPessoa((String)meuObjeto[0]);
        this.getConvenenteDBT().getIdentificacao().setCodigoIdentificador(null);
        this.obterConvenenteDBT(this.getConvenenteDBT());
        IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("ConvenenteCadastro", null);
        if (indicadorOperacao == 'A') {
            interfacePluginCadastro.alterar(this.getConvenenteDBT());
        } else if (indicadorOperacao == 'E') {
            this.getConvenioDBT().setCodigoPessoaConvenenteDBT((String)meuObjeto[0]);
            if (this.getConvenenteDBT().getConvenente().getPessoa().getCodigoPessoa().equals(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa())) {
                throw new Throwable("O Convenente est\u00e1 em Uso! Troque o Convenente para poder exclu\u00ed-lo.");
            }
            interfacePluginCadastro.excluir(this.getConvenenteDBT());
        } else if (indicadorOperacao == 'D') {
            interfacePluginCadastro.detalhar(this.getConvenenteDBT());
        }
        interfacePluginCadastro.exibir();
    }

    public void abrirConvenioCadastro(Object[] meuObjeto, char indicadorOperacao) throws Throwable {
        this.getConvenioDBT().setCodigoPessoaConvenenteDBT((String)meuObjeto[0]);
        this.getConvenioDBT().setNumeroConvenioDBT((String)meuObjeto[1]);
        this.obterConvenio(this.getConvenioDBT());
        IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("DialogConvenioCadastro", null);
        if (indicadorOperacao == 'A') {
            interfacePluginCadastro.alterar(this.getConvenioDBT());
        } else if (indicadorOperacao == 'E') {
            interfacePluginCadastro.excluir(this.getConvenioDBT());
        } else if (indicadorOperacao == 'D') {
            interfacePluginCadastro.detalhar(this.getConvenioDBT());
        }
        interfacePluginCadastro.exibir();
    }

    public void abrirManutencaoConvenente() {
        try {
            this.getInterfaceLista().limpar();
            this.getInterfaceLista().addLinhas(ConvenenteDBTBD.getConvenenteDBTBD().obterLista());
        }
        catch (Exception e) {
            Util.exibirMensagemErro(e);
        }
        this.getInterfaceLista().exibir();
    }

    public void botaoAlterar(GerenciadorListasEvent event) {
        try {
            this.abrirConvenenteCadastro(event.getLinhas()[0], 'A');
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void botaoCancelar(GerenciadorListasEvent event) {
    }

    public void botaoDesmarcar(GerenciadorListasEvent event) {
    }

    public void botaoDetalhar(GerenciadorListasEvent event) {
        try {
            this.abrirConvenenteCadastro(event.getLinhas()[0], 'D');
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void botaoExcluir(GerenciadorListasEvent event) {
        try {
            this.abrirConvenenteCadastro(event.getLinhas()[0], 'E');
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void botaoFiltro(GerenciadorListasEvent event) {
        this.exibirMensagem("Fun\u00e7\u00e3o n\u00e3o dispon\u00edvel para esta Tela");
    }

    public void botaoImprimir(GerenciadorListasEvent event, MultiColumnListbox multicolumn) {
        if (multicolumn.getSelectedIndexes().length != 0) {
            ControleImpressaoRecebimentos.getControleImpressaoRecebimento().imprimir(multicolumn);
        } else {
            Roteador r = new Roteador();
            r.exibirMensagem("Nenhum convenente selecionado.");
        }
    }

    public void botaoIncluir(GerenciadorListasEvent event) {
        this.exibirMensagem("A inclus\u00e3o de convenentes deve ser efetuada atrav\u00e9s do recebimento/processamento do arquivo de configura\u00e7\u00e3o autom\u00e1tica, no menu <Convenente> -> <Inclus\u00e3o autom\u00e1tica (Arquivo do BB)>");
    }

    public void botaoMarcar(GerenciadorListasEvent event) {
    }

    public void botaoOK(GerenciadorListasEvent event) {
    }

    public void botaoSair(GerenciadorListasEvent event) {
    }

    public void excluirIdentificacao(Identificacao identificacao) throws Throwable {
        IdentificacaoBD.getIdentificacaoBD().remover(identificacao);
    }

    public void excluirRecebimento(RecebimentoDBT recebimentoDBT) throws Throwable {
        RecebimentoDBTBD.getRecebimentoDBTBD().remover(recebimentoDBT);
    }

    public static ControleConvenente getControleConvenente() {
        if (controleConvenente == null) {
            controleConvenente = new ControleConvenente();
        }
        return controleConvenente;
    }

    public ConvenenteDBT getConvenenteDBT() {
        if (this.convenenteDBT == null) {
            this.convenenteDBT = new ConvenenteDBT();
        }
        return this.convenenteDBT;
    }

    public ConvenioDBT getConvenioDBT() {
        if (this.convenioDBT == null) {
            this.convenioDBT = new ConvenioDBT();
        }
        return this.convenioDBT;
    }

    public IInterfaceGerenciadorListas getInterfaceLista() {
        if (this.interfaceLista == null) {
            this.interfaceLista = (IInterfaceGerenciadorListas)this.abrirInterface("ConvenenteManutencao", null);
            this.interfaceLista.addGerenciadorListasListener(this);
            this.interfaceLista.setModal(true);
            this.interfaceLista.setTitulo("Selecione o convenente e escolha a a\u00e7\u00e3o desejada.");
            this.interfaceLista.addColuna("C\u00f3digo", 0, false, false);
            this.interfaceLista.addColuna("Inscri\u00e7\u00e3o n\u00e3o formatada", 0, false, false);
            this.interfaceLista.addColuna("Inscri\u00e7\u00e3o", 20, true, true);
            this.interfaceLista.addColuna("Nome", 80, true, true);
            this.interfaceLista.setTituloRelatorio("Rela\u00e7\u00e3o de Convenentes");
            this.interfaceLista.setLinhasHorizontais(true);
            this.interfaceLista.setLinhasVerticais(true);
            this.interfaceLista.setLayout(4);
        }
        return this.interfaceLista;
    }

    public void obterConvenenteDBT(ConvenenteDBT convenente) throws Throwable {
        ConvenenteDBTBD.getConvenenteDBTBD().obter(convenente);
    }

    public void obterConvenio(ConvenioDBT convenio) throws Throwable {
        ConvenioDBTBD.getConvenioDBTBD().obter(convenio);
    }

    public void obterIDProprio(Object objetoNegocio) throws Throwable {
        ConvenenteDBTBD.getConvenenteDBTBD().obterIDProprio(objetoNegocio);
    }

    public Vector obterListaConvenioDBT(ConvenioDBT convenio) throws Throwable {
        return ConvenioDBTBD.getConvenioDBTBD().obterLista(convenio);
    }

    public Vector obterListaIdentificacao(Identificacao identificacao) throws Throwable {
        return IdentificacaoBD.getIdentificacaoBD().obterLista(identificacao);
    }

    public Vector obterListaIdentificador(IdentificadorDBT identificador) throws Throwable {
        return IdentificadorDBTBD.getIdentificadorDBTBD().obterLista(identificador);
    }

    public Vector obterListaRecebimentoDBT(RecebimentoDBT recebimentoDBT) throws Throwable {
        return RecebimentoDBTBD.getRecebimentoDBTBD().obterLista(recebimentoDBT);
    }

    public Vector obterListaUF() throws Throwable {
        return UfBD.getUfBD().obterLista();
    }

    public void salvarConvenenteDBT(Object objetoNegocio, char indicadorOperacao, boolean apagarIDProprio) throws Throwable {
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        try {
            ConvenenteDBT convenenteDebito = (ConvenenteDBT)objetoNegocio;
            if (indicadorOperacao == 'A' || indicadorOperacao == 'I') {
                if (indicadorOperacao == 'A' && apagarIDProprio) {
                    if (this.exibirMensagemConfirmacao("Aten\u00e7\u00e3o!", "Todas as identifica\u00e7\u00f5es Pr\u00f3pias dos clientes relacionados a este convenente ser\u00e3o exclu\u00eddas. Esta opera\u00e7\u00e3o poder\u00e1 levar alguns minutos para ser efetuada. Confirma?")) {
                        Identificacao identificacaoPropria = new Identificacao();
                        identificacaoPropria.setCodigoIdentificadorRel(convenenteDebito.getIdentificadorProprio().getCodigoIdentificador());
                        identificacaoPropria.setCodigoPessoaIdentificadorRel(convenenteDebito.getIdentificadorProprio().getCodigoPessoaRel());
                        Vector vetorIdentificacao = ControleConvenente.getControleConvenente().obterListaIdentificacao(identificacaoPropria);
                        int i = 0;
                        while (i < vetorIdentificacao.size()) {
                            Identificacao identificacao = (Identificacao)vetorIdentificacao.elementAt(i);
                            ControleConvenente.getControleConvenente().excluirIdentificacao(identificacao);
                            ++i;
                        }
                        convenenteDebito.setIndicadorIdentificadorProprio("0");
                    } else {
                        return;
                    }
                }
                ConvenenteDBTBD.getConvenenteDBTBD().salvar(convenenteDebito);
                this.getInterfaceLista().alterado(convenenteDebito);
            } else if (indicadorOperacao == 'E') {
                if (this.exibirMensagemConfirmacao("Aten\u00e7\u00e3o!", "Todas os Conv\u00eanios, Clientes, Identifica\u00e7\u00f5es de d\u00e9bito e Recebimentos vinculados a este convenente ser\u00e3o exclu\u00eddos. Esta opera\u00e7\u00e3o poder\u00e1 levar alguns minutos para ser efetuada. Confirma?")) {
                    ConvenenteDBTBD.getConvenenteDBTBD().remover(convenenteDebito);
                    this.getInterfaceLista().excluido(convenenteDebito);
                } else {
                    this.getInterfaceLista().alterado(convenenteDebito);
                }
            }
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
        }
        catch (SQLException t) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
    }

    public void salvarConvenioDBT(Object objetoNegocio, char indicadorOperacao) throws Throwable {
        this.setConvenioDBT((ConvenioDBT)objetoNegocio);
        this.getConvenenteDBT().getConvenente().getPessoa().setCodigoPessoa(this.getConvenioDBT().getCodigoPessoaConvenenteDBT());
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        try {
            if (indicadorOperacao == 'A' || indicadorOperacao == 'I') {
                ConvenioDBTBD.getConvenioDBTBD().salvar(this.getConvenioDBT());
            } else if (indicadorOperacao == 'E' && this.exibirMensagemConfirmacao("Aten\u00e7\u00e3o!", "Todas as Identifica\u00e7\u00f5es de d\u00e9bito e Recebimentos vinculados a este conv\u00eanio ser\u00e3o exclu\u00eddos. Esta opera\u00e7\u00e3o poder\u00e1 levar alguns minutos para ser efetuada. Confirma?")) {
                ConvenioDBTBD.getConvenioDBTBD().remover(this.getConvenioDBT());
            }
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
        }
        catch (SQLException t) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
    }

    public void setConvenenteDBT(ConvenenteDBT newConvenenteDBT) {
        this.convenenteDBT = newConvenenteDBT;
    }

    public void setConvenioDBT(ConvenioDBT newConvenioDBT) {
        this.convenioDBT = newConvenioDBT;
    }
}

