/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.recebimentosdeterceiros;

import br.com.bb.plugins.controle.impressao.ControleImpressao;
import br.com.bb.plugins.controle.impressao.Linha;
import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.IBarraProgresso;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.controle.recebimentosdeterceiros.ControleCliente;
import br.com.bb.plugins.controle.recebimentosdeterceiros.ControleMovimento;
import br.com.bb.plugins.negocio.comum.Identificacao;
import br.com.bb.plugins.negocio.comum.Pessoa;
import br.com.bb.plugins.negocio.infraestrutura.Filtro;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ClienteDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ConvenenteDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ConvenioDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.GrupoClienteRecebimento;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.IdentificadorDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.RecebimentoDBT;
import br.com.bb.plugins.persistencia.comum.PessoaBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ClienteDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ClienteDBTListaBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ConvenenteDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ConvenioDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.IdentificadorDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.RecebimentoDBTBD;
import br.com.bb.plugins.utilitarios.Util;
import com.ibm.webrunner.widget.MultiColumnListbox;
import java.awt.Cursor;
import java.awt.Font;
import java.util.Vector;

public class ControleImpressaoRecebimentos
extends Roteador {
    private int tipoImpressao = 0;
    private String descricao = null;
    private Vector linhas = new Vector();
    private int linhaAtual = 1;
    private static ControleImpressaoRecebimentos controleImpressaoRecebimento = null;
    private MultiColumnListbox multicolumn = null;
    private ClienteDBT cliente = new ClienteDBT();
    private IdentificadorDBT identificadorDBT = new IdentificadorDBT();
    private GrupoClienteRecebimento grupo = null;
    private Pessoa pessoaDBT = new Pessoa();
    private ConvenioDBT convenioDBT = new ConvenioDBT();
    private double valorTotal = 0.0;
    private int QtdTotal = 0;
    private int QtdRecebimentosRemessa = 0;
    private int QtdIDAlteradoRemessa = 0;
    private int QtdIDManutencaoRemessa = 0;
    private Vector vetorParametrosRemessa = new Vector();
    private Vector vetorRecebimentosRemessa = new Vector();
    private Vector vetorIDAlteradoRemessa = new Vector();
    private Vector vetorIDManutencaoRemessa = new Vector();
    private Vector vetorRecebimentosManutRem = new Vector();

    private ControleImpressaoRecebimentos() {
    }

    private void addCabecalhoRetorno() {
        Linha linha = this.getNovaLinha();
        linha.setNovaPagina(true);
        linha.setFonte(new Font("monospaced", 1, 8));
        linha.setTexto(" Cliente                                  Ident.D\u00e9bito        Ag\u00ean.        Conta Corrente    Valor   ");
        linha.setFonte(new Font("monospaced", 1, 8));
        this.linhas.addElement(linha);
        this.linhas.addElement(this.getTraco());
        ++this.linhaAtual;
        ++this.linhaAtual;
    }

    public static ControleImpressaoRecebimentos getControleImpressaoRecebimento() {
        if (controleImpressaoRecebimento == null) {
            controleImpressaoRecebimento = new ControleImpressaoRecebimentos();
        }
        return controleImpressaoRecebimento;
    }

    private ConvenioDBT getConvenioDBT() {
        return this.convenioDBT;
    }

    private Linha getMesmaLinha() {
        Linha linha = this.getNovaLinha();
        linha.setSalto(false);
        return linha;
    }

    private Linha getNovaLinha() {
        Linha linha = new Linha();
        linha.setTab(5);
        linha.setTexto(" ");
        linha.setFonte(new Font("monospaced", 0, 10));
        linha.setSalto(true);
        return linha;
    }

    private int getQtdIDAlteradoRemessa() {
        return this.QtdIDAlteradoRemessa;
    }

    private int getQtdIDManutencaoRemessa() {
        return this.QtdIDManutencaoRemessa;
    }

    private int getQtdRecebimentosRemessa() {
        return this.QtdRecebimentosRemessa;
    }

    private int getQtdTotal() {
        return this.QtdTotal;
    }

    private Linha getTraco() {
        Linha linha = this.getNovaLinha();
        linha.setFonte(new Font("monospaced", 0, 12));
        linha.setSalto(true);
        linha.setTexto("___________________________________________________________________________");
        linha.setTab(5);
        return linha;
    }

    private Linha getTracoInterno() {
        Linha linha = this.getNovaLinha();
        linha.setFonte(new Font("monospaced", 0, 9));
        linha.setSalto(false);
        linha.setTexto("____________________________________________________________________________________");
        linha.setTab(13);
        return linha;
    }

    private double getValorTotal() {
        return this.valorTotal;
    }

    private Vector getVetorIDAlteradoRemessa() {
        return this.vetorIDAlteradoRemessa;
    }

    private Vector getVetorIDManutencaoRemessa() {
        return this.vetorIDManutencaoRemessa;
    }

    private Vector getVetorParametrosRemessa() {
        return this.vetorParametrosRemessa;
    }

    public Vector getVetorRecebimentosManutRem() {
        return this.vetorRecebimentosManutRem;
    }

    private Vector getVetorRecebimentosRemessa() {
        return this.vetorRecebimentosRemessa;
    }

    public void imprimir(MultiColumnListbox multicolumn) {
        ControleImpressao.getControle().setLinhasPorPagina(63);
        ControleImpressao.getControle().setCodigoRelatorio("DBT001");
        int tab1 = 8;
        int tab2 = 48;
        int tab3 = 13;
        this.linhas.removeAllElements();
        ConvenenteDBT convenenteDBT = new ConvenenteDBT();
        ConvenioDBT convenio = new ConvenioDBT();
        Vector convenios = new Vector();
        boolean verificaVarios = false;
        int[] j = multicolumn.getSelectedIndexes();
        int conta = j.length;
        int i = 0;
        while (i < conta) {
            if (conta > 1) {
                convenenteDBT.getConvenente().getPessoa().setCodigoPessoa((String)multicolumn.getRow(j[i])[0]);
                verificaVarios = true;
            } else {
                convenenteDBT.getConvenente().getPessoa().setCodigoPessoa((String)multicolumn.getSelectedRow()[0]);
                verificaVarios = false;
            }
            convenenteDBT.getIdentificacao().setNumeroIdentificador(null);
            convenenteDBT.getIdentificacao().setCodigoIdentificador(null);
            convenio.setCodigoPessoaConvenenteDBT(convenenteDBT.getConvenente().getPessoa().getCodigoPessoa());
            try {
                ConvenenteDBTBD.getConvenenteDBTBD().obter(convenenteDBT);
                convenios = ConvenioDBTBD.getConvenioDBTBD().obterLista(convenio);
            }
            catch (Throwable t) {
                this.exibirMensagemErro(t);
            }
            Linha linha = this.getNovaLinha();
            linha.setTab(tab1);
            linha.setTexto("CONVENENTE.: " + convenenteDBT.getConvenente().getPessoa().getNomePessoa());
            linha.setFonte(new Font("monospaced", 1, 10));
            this.linhas.addElement(linha);
            linha = this.getNovaLinha();
            linha.setTab(tab1);
            try {
                if (convenenteDBT.getIdentificacao().getIdentificador().getCodigoIdentificador().equals("CPF")) {
                    linha.setTexto("Inscri\u00e7\u00e3o..: " + Util.formatarCPF(convenenteDBT.getIdentificacao().getNumeroIdentificador()));
                } else {
                    linha.setTexto("Inscri\u00e7\u00e3o..: " + Util.formatarCGC(convenenteDBT.getIdentificacao().getNumeroIdentificador()));
                }
            }
            catch (Throwable t) {
                this.exibirMensagemErro(t);
            }
            this.linhas.addElement(linha);
            linha = this.getNovaLinha();
            linha.setTab(tab1);
            linha.setTexto("Endere\u00e7o...: " + convenenteDBT.getConvenente().getPessoa().getTextoEndereco());
            this.linhas.addElement(linha);
            linha = this.getNovaLinha();
            linha.setTab(tab1);
            linha.setSalto(false);
            linha.setTexto("Bairro.....: " + convenenteDBT.getConvenente().getPessoa().getTextoBairro());
            this.linhas.addElement(linha);
            linha = this.getNovaLinha();
            linha.setTab(tab2);
            linha.setTexto("Cidade.: " + convenenteDBT.getConvenente().getPessoa().getTextoCidade());
            this.linhas.addElement(linha);
            linha = this.getNovaLinha();
            linha.setTab(tab1);
            linha.setSalto(false);
            linha.setTexto("CEP........: " + Util.formatarString(convenenteDBT.getConvenente().getPessoa().getCodigoCep(), "99.999-999"));
            this.linhas.addElement(linha);
            linha = this.getNovaLinha();
            linha.setTab(tab2);
            linha.setTexto("UF.....: " + convenenteDBT.getConvenente().getPessoa().getCodigoUFRel());
            this.linhas.addElement(linha);
            if (convenenteDBT.getIndicadorIdentificadorProprio().equals("1")) {
                linha = this.getNovaLinha();
                linha.setTab(tab1);
                linha.setTexto("Identificador Pr\u00f3prio para Clientes");
                linha.setFonte(new Font("monospaced", 3, 10));
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setTab(tab1);
                linha.setSalto(false);
                if (convenenteDBT.getIdentificadorProprio().getIndicadorDominio().equals("A")) {
                    linha.setTexto("Tipo.......: Alfanum\u00e9rico");
                } else {
                    linha.setTexto("Tipo.......: Num\u00e9rico");
                }
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setTab(tab2);
                if (convenenteDBT.getIdentificadorProprio().getTamanhoIdentificador() == 0) {
                    linha.setTexto("Tamanho: n\u00e3o informado");
                } else {
                    linha.setTexto("Tamanho: " + convenenteDBT.getIdentificadorProprio().getTamanhoIdentificador());
                }
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setTab(tab1);
                linha.setSalto(false);
                if (convenenteDBT.getIdentificadorProprio().getMascara() == null) {
                    linha.setTexto("Formato....: n\u00e3o informado");
                } else {
                    linha.setTexto("Formato....: " + convenenteDBT.getIdentificadorProprio().getMascara());
                }
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setTab(tab2);
                linha.setTexto("Sigla..: " + convenenteDBT.getIdentificadorProprio().getCodigoIdentificador());
                this.linhas.addElement(linha);
            }
            int y = 0;
            while (y < convenios.size()) {
                this.linhas.addElement(this.getTracoInterno());
                linha = this.getNovaLinha();
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setTab(tab3);
                linha.setTexto("Conv\u00eanio/N\u00famero:" + ((ConvenioDBT)convenios.elementAt(y)).getNumeroConvenioDBT());
                linha.setFonte(new Font("monospaced", 1, 9));
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setTab(tab3);
                linha.setTexto("Descri\u00e7\u00e3o/Natureza: " + ((ConvenioDBT)convenios.elementAt(y)).getTextoDescricaoConvenio());
                linha.setFonte(new Font("monospaced", 0, 9));
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setTab(tab3);
                linha.setSalto(false);
                linha.setTexto("Ag\u00eancia..: " + Util.formatarString(((ConvenioDBT)convenios.elementAt(y)).getContaCorrente().getcodigoPrefixoAgenciaRel(), "9999-A"));
                linha.setFonte(new Font("monospaced", 0, 9));
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setTab(tab2);
                linha.setTexto("Conta Corrente: " + Util.formatarString(((ConvenioDBT)convenios.elementAt(y)).getContaCorrente().getnumeroContaCorrente(), "999.999.999-A"));
                linha.setFonte(new Font("monospaced", 0, 9));
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setTab(tab3);
                linha.setTexto("Identificador para D\u00e9bito em Conta");
                linha.setFonte(new Font("monospaced", 3, 9));
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setTab(tab3);
                linha.setSalto(false);
                if (((ConvenioDBT)convenios.elementAt(y)).getIdentificadorDBT().getIndicadorDominio().equals("A")) {
                    linha.setTexto("Tipo.....: Alfanum\u00e9rico");
                } else {
                    linha.setTexto("Tipo.....: Num\u00e9rico");
                }
                linha.setFonte(new Font("monospaced", 0, 9));
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setTab(tab2);
                if (((ConvenioDBT)convenios.elementAt(y)).getIdentificadorDBT().getTamanhoIdentificador() == 0) {
                    linha.setTexto("Tamanho.......: n\u00e3o informado");
                } else {
                    linha.setTexto("Tamanho.......: " + ((ConvenioDBT)convenios.elementAt(y)).getIdentificadorDBT().getTamanhoIdentificador());
                }
                linha.setFonte(new Font("monospaced", 0, 9));
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setTab(tab3);
                if (((ConvenioDBT)convenios.elementAt(y)).getIdentificadorDBT().getMascara() == null) {
                    linha.setTexto("Formato..: n\u00e3o informado");
                } else {
                    linha.setTexto("Formato..: " + ((ConvenioDBT)convenios.elementAt(y)).getIdentificadorDBT().getMascara());
                }
                linha.setFonte(new Font("monospaced", 0, 9));
                this.linhas.addElement(linha);
                ++y;
            }
            this.linhas.addElement(this.getTraco());
            linha = this.getNovaLinha();
            linha.setNovaPagina(i < conta - 1);
            this.linhas.addElement(linha);
            if (!verificaVarios) break;
            ++i;
        }
        ControleImpressao.getControle().setCodigoRelatorio("DBT401");
        ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de Convenente");
        ControleImpressao.getControle().imprimirLinhas(this.linhas, "Relat\u00f3rio de Convenente");
    }

    public void imprimirAutorizacoesDebito(Vector vetorClientes, Filtro filtro) {
        try {
            IBarraProgresso barra = this.getFramePlugin().obterBarraProgresso();
            barra.setValorMaximo(vetorClientes.size());
            barra.inicializar("Preparando relat\u00f3rio para impress\u00e3o. AGUARDE...", vetorClientes.size(), false);
            Object codigoPessoaCliente = null;
            this.cliente = new ClienteDBT();
            int contador = 0;
            int Quebra = 8;
            boolean primeiraPagina = true;
            ConvenenteDBT convenenteDBT = new ConvenenteDBT();
            convenenteDBT.getConvenente().getPessoa().setCodigoPessoa(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            ConvenenteDBTBD.getConvenenteDBTBD().obter(convenenteDBT);
            this.linhas.removeAllElements();
            Linha linha = this.getNovaLinha();
            if (filtro.getDescricaoFiltro() != null) {
                String descricaoFiltro = "Clientes: " + filtro.getDescricaoFiltro();
                int i = 0;
                while (i < descricaoFiltro.length()) {
                    linha.setTexto(descricaoFiltro.substring(i, descricaoFiltro.length() < i + 100 ? descricaoFiltro.length() : i + 100));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    i += 100;
                }
                this.linhas.addElement(this.getTraco());
                linha = this.getNovaLinha();
            }
            int i = 0;
            while (i < vetorClientes.size()) {
                this.cliente = (ClienteDBT)vetorClientes.elementAt(i);
                if (this.cliente.getStrIDDBTParaListaClientes() != null && !this.cliente.getStrIDDBTParaListaClientes().equals("") && this.cliente.getStrMascaraIDDBTParaListaClientes() != null) {
                    if (Quebra > 7) {
                        linha = this.getNovaLinha();
                        linha.setTexto("");
                        this.linhas.addElement(linha);
                        if (!primeiraPagina) {
                            linha.setNovaPagina(true);
                        } else {
                            primeiraPagina = false;
                        }
                        Quebra = 0;
                        linha = this.getNovaLinha();
                        linha.setTexto("1. Autorizo  o  Banco do Brasil S.A.  a  debitar em minha conta corrente o valor");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTexto("   correspondente  \u00e0  quita\u00e7\u00e3o  dos compromissos  abaixo  relacionados, oriundos");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTexto("   de lan\u00e7amentos gerados pelo aplicativo D\u00e9bito Autom\u00e1tico.                    ");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTexto("2. Comprometo-me, desde j\u00e1, a  manter  saldo  suficiente para o referido d\u00e9bito,");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTexto("   ficando o Banco do Brasil S.A. isento de qualquer responsabilidade decorrente");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTexto("   da n\u00e3o liquida\u00e7\u00e3o  do  compromisso  por  insufici\u00eancia  de  saldo  na data do");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTexto("   vencimento.                                                                  ");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTexto("3. Estou ciente de que, caso n\u00e3o conste na conta de consumo a express\u00e3o  'D\u00e9bito");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTexto("   em conta-n\u00e3o receber no caixa', esta poder\u00e1  ser quitada em qualquer terminal");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTexto("   de auto-atendimento BB. Nesse caso, procure sua ag\u00eancia para esclarecimentos.");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTexto("4. Em caso de d\u00favida ou reclama\u00e7\u00e3o sobre datas de vencimento e/ou  valores, devo");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTexto("   solicitar esclarecimentos diretamente \u00e0 empresa credora.                     ");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTexto("5. O Banco do Brasil S.A. se reserva o direito de, a qualquer tempo,  cancelar a");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTexto("   presente presta\u00e7\u00e3o de servi\u00e7o, mediante comunica\u00e7\u00e3o por escrito.             ");
                        this.linhas.addElement(linha);
                        this.linhas.addElement(this.getTraco());
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        linha.setTexto("NOME");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setSalto(false);
                        linha.setTexto("CONV\u00caNIO");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        linha.setTab(15);
                        linha.setTexto("DESCRI\u00c7\u00c3O/FINALIDADE");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setSalto(false);
                        linha.setTexto("BANCO");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setSalto(false);
                        linha.setTab(10);
                        linha.setTexto("AG\u00caNCIA");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setSalto(false);
                        linha.setTab(20);
                        linha.setTexto("CONTA");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setSalto(false);
                        linha.setTab(38);
                        linha.setTexto("IDENTIFICA\u00c7\u00c3O PARA D\u00c9BITO");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setSalto(false);
                        linha.setTab(60);
                        linha.setTexto("   DATA       ASSINATURA");
                        this.linhas.addElement(linha);
                        linha.setSalto(true);
                        this.linhas.addElement(this.getTraco());
                    }
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTexto(this.cliente.getPessoa().getNomePessoa());
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    linha.setTexto(this.cliente.getStrNumeroConvenioDBT());
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTab(15);
                    linha.setTexto(this.cliente.getStrFinalidadeConvenio());
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    linha.setTexto("001");
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    linha.setTab(10);
                    linha.setTexto(Util.formatarConta(this.cliente.getStrAgenciaParaListaClientes()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    linha.setTab(20);
                    linha.setTexto(Util.formatarConta(this.cliente.getStrContaParaListaClientes()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    linha.setTab(38);
                    linha.setTexto(this.cliente.getStrIDDBTParaListaClientes());
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    linha.setTab(60);
                    linha.setTexto("___/___/___  ___________");
                    this.linhas.addElement(linha);
                    linha.setSalto(true);
                    this.linhas.addElement(this.getTraco());
                    ++contador;
                    ++Quebra;
                }
                barra.setValor(i);
                ++i;
            }
            if (contador > 0) {
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("Quantidade de Registros: " + contador);
                this.linhas.addElement(linha);
            } else {
                this.exibirMensagem("N\u00e3o h\u00e1 clientes com identifica\u00e7\u00e3o de d\u00e9bito para impress\u00e3o!");
            }
            barra.finalizar();
            ControleImpressao.getControle().setCodigoRelatorio("DBT109");
            ControleImpressao.getControle().setTituloVisualizacao("Autoriza\u00e7\u00e3o de D\u00e9bito Programado");
            ControleImpressao.getControle().imprimirLinhas(this.linhas, "Autoriza\u00e7\u00e3o de D\u00e9bito Programado");
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void imprimirCliente(Vector vetorClientes, Filtro filtro) {
        try {
            IBarraProgresso barra = this.getFramePlugin().obterBarraProgresso();
            barra.setValorMaximo(vetorClientes.size());
            barra.inicializar("Preparando relat\u00f3rio para impress\u00e3o. AGUARDE...", vetorClientes.size(), false);
            String codigoPessoaCliente = null;
            this.cliente = new ClienteDBT();
            int contador = 0;
            ConvenenteDBT convenenteDBT = new ConvenenteDBT();
            convenenteDBT.getConvenente().getPessoa().setCodigoPessoa(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            ConvenenteDBTBD.getConvenenteDBTBD().obter(convenenteDBT);
            this.linhas.removeAllElements();
            Linha linha = this.getNovaLinha();
            if (filtro.getDescricaoFiltro() != null) {
                String descricaoFiltro = "Clientes: " + filtro.getDescricaoFiltro();
                int i = 0;
                while (i < descricaoFiltro.length()) {
                    linha.setTexto(descricaoFiltro.substring(i, descricaoFiltro.length() < i + 100 ? descricaoFiltro.length() : i + 100));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    i += 100;
                }
                this.linhas.addElement(this.getTraco());
                linha = this.getNovaLinha();
            }
            int i = 0;
            while (i < vetorClientes.size()) {
                this.cliente = (ClienteDBT)vetorClientes.elementAt(i);
                if (!this.cliente.getPessoa().getCodigoPessoa().equals(codigoPessoaCliente)) {
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    if (this.cliente.getIdentificacao().getNumeroIdentificador() != null && !this.cliente.getIdentificacao().getNumeroIdentificador().equals("")) {
                        linha.setTexto("Inscri\u00e7\u00e3o..: " + Util.formatarString(this.cliente.getIdentificacao().getNumeroIdentificador(), this.cliente.getIdentificacao().getIdentificador().getMascara()));
                    } else {
                        linha.setTexto("Inscri\u00e7\u00e3o..: N\u00e3o Possui");
                    }
                    this.linhas.addElement(linha);
                    if (convenenteDBT.getIndicadorIdentificadorProprio().equals("1")) {
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        linha.setTab(55);
                        if (this.cliente.getIdentificacaoPropria().getNumeroIdentificador() != null && !this.cliente.getIdentificacaoPropria().getNumeroIdentificador().equals("")) {
                            linha.setTexto(String.valueOf(convenenteDBT.getCodigoIdentificadorProprio()) + "          ".substring(0, 10 - convenenteDBT.getCodigoIdentificadorProprio().trim().length()) + ": " + Util.formatarString(this.cliente.getIdentificacaoPropria().getNumeroIdentificador(), this.cliente.getIdentificacaoPropria().getIdentificador().getMascara()));
                        } else {
                            linha.setTexto(String.valueOf(convenenteDBT.getCodigoIdentificadorProprio()) + "          ".substring(0, 10 - convenenteDBT.getCodigoIdentificadorProprio().trim().length()) + ": N\u00e3o Possui");
                        }
                        this.linhas.addElement(linha);
                    } else {
                        linha.setSalto(true);
                    }
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTexto("Nome.......: " + this.cliente.getPessoa().getNomePessoa());
                    this.linhas.addElement(linha);
                    this.linhas.addElement(this.getTraco());
                    ++contador;
                }
                codigoPessoaCliente = this.cliente.getPessoa().getCodigoPessoa();
                barra.setValor(i);
                ++i;
            }
            if (contador > 0) {
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("Quantidade de Registros: " + contador);
                this.linhas.addElement(linha);
            } else {
                this.exibirMensagem("N\u00e3o h\u00e1 clientes para impress\u00e3o!");
            }
            barra.finalizar();
            ControleImpressao.getControle().setCodigoRelatorio("DBT101");
            ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de Clientes - Dados B\u00e1sicos");
            ControleImpressao.getControle().imprimirLinhas(this.linhas, "Relat\u00f3rio de Clientes - Dados B\u00e1sicos");
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void imprimirClienteCompleto(Vector vetorClientes, Filtro filtro) {
        try {
            IBarraProgresso barra = this.getFramePlugin().obterBarraProgresso();
            barra.setValorMaximo(vetorClientes.size());
            barra.inicializar("Preparando relat\u00f3rio para impress\u00e3o. AGUARDE...", vetorClientes.size(), false);
            String codigoPessoaCliente = null;
            this.cliente = new ClienteDBT();
            int contador = 0;
            ConvenenteDBT convenenteDBT = new ConvenenteDBT();
            convenenteDBT.getConvenente().getPessoa().setCodigoPessoa(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            ConvenenteDBTBD.getConvenenteDBTBD().obter(convenenteDBT);
            this.linhas.removeAllElements();
            Linha linha = this.getNovaLinha();
            if (filtro.getDescricaoFiltro() != null) {
                String descricaoFiltro = "Clientes: " + filtro.getDescricaoFiltro();
                int i = 0;
                while (i < descricaoFiltro.length()) {
                    linha.setTexto(descricaoFiltro.substring(i, descricaoFiltro.length() < i + 100 ? descricaoFiltro.length() : i + 100));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    i += 100;
                }
                this.linhas.addElement(this.getTraco());
                linha = this.getNovaLinha();
            }
            int i = 0;
            while (i < vetorClientes.size()) {
                this.cliente = (ClienteDBT)vetorClientes.elementAt(i);
                if (!this.cliente.getPessoa().getCodigoPessoa().equals(codigoPessoaCliente)) {
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    if (this.cliente.getIdentificacao().getNumeroIdentificador() != null && !this.cliente.getIdentificacao().getNumeroIdentificador().equals("")) {
                        linha.setTexto("Inscri\u00e7\u00e3o..: " + Util.formatarString(this.cliente.getIdentificacao().getNumeroIdentificador(), this.cliente.getIdentificacao().getIdentificador().getMascara()));
                    } else {
                        linha.setTexto("Inscri\u00e7\u00e3o..: N\u00e3o Possui");
                    }
                    this.linhas.addElement(linha);
                    if (convenenteDBT.getIndicadorIdentificadorProprio().equals("1")) {
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        linha.setTab(55);
                        if (this.cliente.getIdentificacaoPropria().getNumeroIdentificador() != null && !this.cliente.getIdentificacaoPropria().getNumeroIdentificador().equals("")) {
                            linha.setTexto(String.valueOf(convenenteDBT.getCodigoIdentificadorProprio()) + "          ".substring(0, 10 - convenenteDBT.getCodigoIdentificadorProprio().trim().length()) + ": " + Util.formatarString(this.cliente.getIdentificacaoPropria().getNumeroIdentificador(), this.cliente.getIdentificacaoPropria().getIdentificador().getMascara()));
                        } else {
                            linha.setTexto(String.valueOf(convenenteDBT.getCodigoIdentificadorProprio()) + "          ".substring(0, 10 - convenenteDBT.getCodigoIdentificadorProprio().trim().length()) + ": N\u00e3o Possui");
                        }
                        this.linhas.addElement(linha);
                    } else {
                        linha.setSalto(true);
                    }
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTexto("Nome.......: " + this.cliente.getPessoa().getNomePessoa());
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    if (this.cliente.getPessoa().getTextoEndereco() == null || this.cliente.getPessoa().getTextoEndereco().length() == 0) {
                        linha.setTexto("Endere\u00e7o...: ");
                    } else {
                        linha.setTexto("Endere\u00e7o...: " + this.cliente.getPessoa().getTextoEndereco().trim());
                    }
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    if (this.cliente.getPessoa().getTextoBairro() == null || this.cliente.getPessoa().getTextoBairro().length() == 0) {
                        linha.setTexto("Bairro.....: ");
                    } else {
                        linha.setTexto("Bairro.....: " + this.cliente.getPessoa().getTextoBairro().trim());
                    }
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    if (this.cliente.getPessoa().getTextoCidade() == null || this.cliente.getPessoa().getTextoCidade().length() == 0) {
                        linha.setTexto("Cidade.....: ");
                    } else {
                        linha.setTexto("Cidade.....: " + this.cliente.getPessoa().getTextoCidade().trim());
                    }
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    if (this.cliente.getPessoa().getCodigoCep() == null || this.cliente.getPessoa().getCodigoCep().length() == 0) {
                        linha.setTexto("CEP........: ");
                    } else {
                        linha.setTexto("CEP........: " + Util.formatarString(this.cliente.getPessoa().getCodigoCep().trim(), "99.999-999"));
                    }
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    if (this.cliente.getPessoa().getCodigoUFRel() == null || this.cliente.getPessoa().getCodigoUFRel().length() == 0) {
                        linha.setTexto("UF.........: ");
                    } else {
                        linha.setTexto("UF.........: " + this.cliente.getPessoa().getCodigoUFRel().trim());
                    }
                    this.linhas.addElement(linha);
                    this.linhas.addElement(this.getTraco());
                    ++contador;
                }
                codigoPessoaCliente = this.cliente.getPessoa().getCodigoPessoa();
                barra.setValor(i);
                ++i;
            }
            if (contador > 0) {
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("Quantidade de Registros: " + contador);
                this.linhas.addElement(linha);
            } else {
                this.exibirMensagem("N\u00e3o h\u00e1 clientes para impress\u00e3o!");
            }
            barra.finalizar();
            ControleImpressao.getControle().setCodigoRelatorio("DBT102");
            ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de Clientes - Dados Completos");
            ControleImpressao.getControle().imprimirLinhas(this.linhas, "Relat\u00f3rio de Clientes - Dados Completos");
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void imprimirClienteIdentificadorDebito(Vector vetorClientes, Filtro filtro) {
        try {
            IBarraProgresso barra = this.getFramePlugin().obterBarraProgresso();
            barra.setValorMaximo(vetorClientes.size());
            barra.inicializar("Preparando relat\u00f3rio para impress\u00e3o. AGUARDE...", vetorClientes.size(), false);
            String codigoPessoaCliente = null;
            boolean blnExisteIDDBT = false;
            this.cliente = new ClienteDBT();
            int contador = 0;
            ConvenenteDBT convenenteDBT = new ConvenenteDBT();
            convenenteDBT.getConvenente().getPessoa().setCodigoPessoa(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            ConvenenteDBTBD.getConvenenteDBTBD().obter(convenenteDBT);
            this.linhas.removeAllElements();
            Linha linha = this.getNovaLinha();
            if (filtro.getDescricaoFiltro() != null) {
                String descricaoFiltro = "Clientes: " + filtro.getDescricaoFiltro();
                int i = 0;
                while (i < descricaoFiltro.length()) {
                    linha.setTexto(descricaoFiltro.substring(i, descricaoFiltro.length() < i + 100 ? descricaoFiltro.length() : i + 100));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    i += 100;
                }
                this.linhas.addElement(this.getTraco());
                linha = this.getNovaLinha();
            }
            int i = 0;
            while (i < vetorClientes.size()) {
                this.cliente = (ClienteDBT)vetorClientes.elementAt(i);
                linha = this.getNovaLinha();
                linha.setSalto(false);
                if (this.cliente.getIdentificacao().getNumeroIdentificador() != null && !this.cliente.getIdentificacao().getNumeroIdentificador().equals("")) {
                    linha.setTexto("Inscri\u00e7\u00e3o..: " + Util.formatarString(this.cliente.getIdentificacao().getNumeroIdentificador(), this.cliente.getIdentificacao().getIdentificador().getMascara()));
                } else {
                    linha.setTexto("Inscri\u00e7\u00e3o..: N\u00e3o Possui");
                }
                this.linhas.addElement(linha);
                if (convenenteDBT.getIndicadorIdentificadorProprio().equals("1")) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTab(55);
                    if (this.cliente.getIdentificacaoPropria().getNumeroIdentificador() != null && !this.cliente.getIdentificacaoPropria().getNumeroIdentificador().equals("")) {
                        linha.setTexto(String.valueOf(convenenteDBT.getCodigoIdentificadorProprio()) + "          ".substring(0, 10 - convenenteDBT.getCodigoIdentificadorProprio().trim().length()) + ": " + Util.formatarString(this.cliente.getIdentificacaoPropria().getNumeroIdentificador(), this.cliente.getIdentificacaoPropria().getIdentificador().getMascara()));
                    } else {
                        linha.setTexto(String.valueOf(convenenteDBT.getCodigoIdentificadorProprio()) + "          ".substring(0, 10 - convenenteDBT.getCodigoIdentificadorProprio().trim().length()) + ": N\u00e3o Possui");
                    }
                    this.linhas.addElement(linha);
                } else {
                    linha.setSalto(true);
                }
                linha = this.getNovaLinha();
                linha.setSalto(true);
                linha.setTexto("Nome.......: " + this.cliente.getPessoa().getNomePessoa());
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                if (this.cliente.getPessoa().getTextoEndereco() == null || this.cliente.getPessoa().getTextoEndereco().length() == 0) {
                    linha.setTexto("Endere\u00e7o...: ");
                } else {
                    linha.setTexto("Endere\u00e7o...: " + this.cliente.getPessoa().getTextoEndereco().trim());
                }
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                if (this.cliente.getPessoa().getTextoBairro() == null || this.cliente.getPessoa().getTextoBairro().length() == 0) {
                    linha.setTexto("Bairro.....: ");
                } else {
                    linha.setTexto("Bairro.....: " + this.cliente.getPessoa().getTextoBairro().trim());
                }
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                if (this.cliente.getPessoa().getTextoCidade() == null || this.cliente.getPessoa().getTextoCidade().length() == 0) {
                    linha.setTexto("Cidade.....: ");
                } else {
                    linha.setTexto("Cidade.....: " + this.cliente.getPessoa().getTextoCidade().trim());
                }
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                if (this.cliente.getPessoa().getCodigoCep() == null || this.cliente.getPessoa().getCodigoCep().length() == 0) {
                    linha.setTexto("CEP........: ");
                } else {
                    linha.setTexto("CEP........: " + Util.formatarString(this.cliente.getPessoa().getCodigoCep().trim(), "99.999-999"));
                }
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                if (this.cliente.getPessoa().getCodigoUFRel() == null || this.cliente.getPessoa().getCodigoUFRel().length() == 0) {
                    linha.setTexto("UF.........: ");
                } else {
                    linha.setTexto("UF.........: " + this.cliente.getPessoa().getCodigoUFRel().trim());
                }
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setFonte(new Font("monospaced", 1, 9));
                linha.setTab(13);
                linha.setTexto("Identifica\u00e7\u00f5es para D\u00e9bito");
                linha.setSalto(false);
                this.linhas.addElement(linha);
                blnExisteIDDBT = false;
                codigoPessoaCliente = this.cliente.getPessoa().getCodigoPessoa();
                while (this.cliente.getPessoa().getCodigoPessoa().equals(codigoPessoaCliente)) {
                    linha = this.getNovaLinha();
                    this.linhas.addElement(this.getTracoInterno());
                    if (this.cliente.getStrIDDBTParaListaClientes() != null && !this.cliente.getStrIDDBTParaListaClientes().equals("") && this.cliente.getStrMascaraIDDBTParaListaClientes() != null) {
                        linha = this.getNovaLinha();
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTab(5);
                        linha.setTexto("       Conv\u00eanio..............: " + this.cliente.getStrNumeroConvenioDBT());
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTab(5);
                        linha.setTexto("       Banco.................: 001 Banco do Brasil");
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTab(5);
                        linha.setTexto("       Ag\u00eancia...............: " + Util.formatarConta(this.cliente.getStrAgenciaParaListaClientes()));
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTab(5);
                        linha.setTexto("       Conta.................: " + Util.formatarConta(this.cliente.getStrContaParaListaClientes()));
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTab(5);
                        linha.setTexto("       Identifica\u00e7\u00e3o P/D\u00e9bito: " + Util.formatarString(this.cliente.getStrIDDBTParaListaClientes(), this.cliente.getStrMascaraIDDBTParaListaClientes()));
                        this.linhas.addElement(linha);
                        linha = this.getNovaLinha();
                        linha.setTab(5);
                        linha.setTexto("       Situa\u00e7\u00e3o..............: " + this.cliente.getStrSituacaoIDDBTParaListaClientes());
                        this.linhas.addElement(linha);
                        linha.setTab(5);
                        linha = this.getNovaLinha();
                        linha.setTexto("       Grupo.................: " + (this.cliente.getStrNomeGrupoParaListaClientes() == null ? "" : this.cliente.getStrNomeGrupoParaListaClientes()));
                        this.linhas.addElement(linha);
                        blnExisteIDDBT = true;
                    } else {
                        blnExisteIDDBT = false;
                    }
                    if (++i < vetorClientes.size()) {
                        this.cliente = (ClienteDBT)vetorClientes.elementAt(i);
                        if (this.cliente.getPessoa().getCodigoPessoa().equals(codigoPessoaCliente)) continue;
                        --i;
                        continue;
                    }
                    codigoPessoaCliente = null;
                }
                if (!blnExisteIDDBT) {
                    linha = this.getNovaLinha();
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTab(13);
                    linha.setTexto("Cliente n\u00e3o possui Identifica\u00e7\u00f5es para D\u00e9bito");
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    this.linhas.addElement(this.getTraco());
                } else {
                    linha = this.getNovaLinha();
                    this.linhas.addElement(this.getTraco());
                }
                ++contador;
                barra.setValor(i);
                ++i;
            }
            if (contador > 0) {
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("Quantidade de Registros: " + contador);
                this.linhas.addElement(linha);
            } else {
                this.exibirMensagem("N\u00e3o h\u00e1 clientes com identifica\u00e7\u00f5es de D\u00e9bito para impress\u00e3o!");
            }
            barra.finalizar();
            ControleImpressao.getControle().setCodigoRelatorio("DBT104");
            ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de Clientes/Identifica\u00e7\u00f5es para D\u00e9bito");
            ControleImpressao.getControle().imprimirLinhas(this.linhas, "Relat\u00f3rio de Clientes/Identifica\u00e7\u00f5es para D\u00e9bito");
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void imprimirIdentificadorDebito(Vector vetorClientes, Filtro filtro) {
        try {
            IBarraProgresso barra = this.getFramePlugin().obterBarraProgresso();
            barra.setValorMaximo(vetorClientes.size());
            barra.inicializar("Preparando relat\u00f3rio para impress\u00e3o. AGUARDE...", vetorClientes.size(), false);
            Object codigoPessoaCliente = null;
            this.cliente = new ClienteDBT();
            int contador = 0;
            ConvenenteDBT convenenteDBT = new ConvenenteDBT();
            convenenteDBT.getConvenente().getPessoa().setCodigoPessoa(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            ConvenenteDBTBD.getConvenenteDBTBD().obter(convenenteDBT);
            this.linhas.removeAllElements();
            Linha linha = this.getNovaLinha();
            if (filtro.getDescricaoFiltro() != null) {
                String descricaoFiltro = "Clientes: " + filtro.getDescricaoFiltro();
                int i = 0;
                while (i < descricaoFiltro.length()) {
                    linha.setTexto(descricaoFiltro.substring(i, descricaoFiltro.length() < i + 100 ? descricaoFiltro.length() : i + 100));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    i += 100;
                }
                this.linhas.addElement(this.getTraco());
                linha = this.getNovaLinha();
            }
            int i = 0;
            while (i < vetorClientes.size()) {
                this.cliente = (ClienteDBT)vetorClientes.elementAt(i);
                if (this.cliente.getStrIDDBTParaListaClientes() != null && !this.cliente.getStrIDDBTParaListaClientes().equals("") && this.cliente.getStrMascaraIDDBTParaListaClientes() != null) {
                    linha = this.getNovaLinha();
                    linha.setTexto("Nome do Cliente.......: " + this.cliente.getPessoa().getNomePessoa());
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTexto("Conv\u00eanio..............: " + this.cliente.getStrNumeroConvenioDBT());
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTexto("Banco.................: 001 Banco do Brasil");
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTexto("Ag\u00eancia...............: " + Util.formatarConta(this.cliente.getStrAgenciaParaListaClientes()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTexto("Conta.................: " + Util.formatarConta(this.cliente.getStrContaParaListaClientes()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTexto("Identifica\u00e7\u00e3o P/D\u00e9bito: " + Util.formatarString(this.cliente.getStrIDDBTParaListaClientes(), this.cliente.getStrMascaraIDDBTParaListaClientes()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTexto("Situa\u00e7\u00e3o..............: " + this.cliente.getStrSituacaoIDDBTParaListaClientes());
                    this.linhas.addElement(linha);
                    this.linhas.addElement(this.getTraco());
                    ++contador;
                }
                barra.setValor(i);
                ++i;
            }
            if (contador > 0) {
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("Quantidade de Registros: " + contador);
                this.linhas.addElement(linha);
            } else {
                this.exibirMensagem("N\u00e3o h\u00e1 clientes com identifica\u00e7\u00e3o de d\u00e9bito para impress\u00e3o!");
            }
            barra.finalizar();
            ControleImpressao.getControle().setCodigoRelatorio("DBT103");
            ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de Identifica\u00e7\u00f5es para D\u00e9bito");
            ControleImpressao.getControle().imprimirLinhas(this.linhas, "Relat\u00f3rio de Identifica\u00e7\u00f5es para D\u00e9bito");
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void imprimirIdentificadorDebitoGrupo(Vector vetorClientes, Filtro filtro) {
        try {
            IBarraProgresso barra = this.getFramePlugin().obterBarraProgresso();
            barra.setValorMaximo(vetorClientes.size());
            barra.inicializar("Preparando relat\u00f3rio para impress\u00e3o. AGUARDE...", vetorClientes.size(), false);
            Object codigoPessoaCliente = null;
            this.cliente = new ClienteDBT();
            int contador = 0;
            ConvenenteDBT convenenteDBT = new ConvenenteDBT();
            convenenteDBT.getConvenente().getPessoa().setCodigoPessoa(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            ConvenenteDBTBD.getConvenenteDBTBD().obter(convenenteDBT);
            this.linhas.removeAllElements();
            Linha linha = this.getNovaLinha();
            if (filtro.getDescricaoFiltro() != null) {
                String descricaoFiltro = "Clientes: " + filtro.getDescricaoFiltro();
                int i = 0;
                while (i < descricaoFiltro.length()) {
                    linha.setTexto(descricaoFiltro.substring(i, descricaoFiltro.length() < i + 100 ? descricaoFiltro.length() : i + 100));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    i += 100;
                }
                this.linhas.addElement(this.getTraco());
                linha = this.getNovaLinha();
            }
            int i = 0;
            while (i < vetorClientes.size()) {
                this.cliente = (ClienteDBT)vetorClientes.elementAt(i);
                if (this.cliente.getStrIDDBTParaListaClientes() != null && !this.cliente.getStrIDDBTParaListaClientes().equals("") && this.cliente.getStrMascaraIDDBTParaListaClientes() != null) {
                    linha = this.getNovaLinha();
                    linha.setTexto("Nome do Cliente.......: " + this.cliente.getPessoa().getNomePessoa());
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTexto("Conv\u00eanio..............: " + this.cliente.getStrNumeroConvenioDBT());
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTexto("Banco.................: 001 Banco do Brasil");
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTexto("Ag\u00eancia...............: " + Util.formatarConta(this.cliente.getStrAgenciaParaListaClientes()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTexto("Conta.................: " + Util.formatarConta(this.cliente.getStrContaParaListaClientes()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTexto("Identifica\u00e7\u00e3o P/D\u00e9bito: " + Util.formatarString(this.cliente.getStrIDDBTParaListaClientes(), this.cliente.getStrMascaraIDDBTParaListaClientes()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTexto("Situa\u00e7\u00e3o..............: " + this.cliente.getStrSituacaoIDDBTParaListaClientes());
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTexto("Grupo.................: " + (this.cliente.getStrNomeGrupoParaListaClientes() == null ? "" : this.cliente.getStrNomeGrupoParaListaClientes()));
                    this.linhas.addElement(linha);
                    this.linhas.addElement(this.getTraco());
                    ++contador;
                }
                barra.setValor(i);
                ++i;
            }
            if (contador > 0) {
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("Quantidade de Registros: " + contador);
                this.linhas.addElement(linha);
            } else {
                this.exibirMensagem("N\u00e3o h\u00e1 clientes com identifica\u00e7\u00e3o de d\u00e9bito para impress\u00e3o!");
            }
            barra.finalizar();
            ControleImpressao.getControle().setCodigoRelatorio("DBT105");
            ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de Identifica\u00e7\u00f5es para D\u00e9bito e Grupos");
            ControleImpressao.getControle().imprimirLinhas(this.linhas, "Relat\u00f3rio de Identifica\u00e7\u00f5es para D\u00e9bito e Grupos");
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void imprimirImportacaoRelatorio(Vector vetorImportado, Vector vetorRecusado, Vector vetorRecusadoMensagem) {
        try {
            int i;
            int qtdImportado = vetorImportado.size();
            int qtdRecusado = vetorRecusado.size();
            int qtdTotal = qtdImportado + qtdRecusado;
            String registro = "";
            IBarraProgresso barra = this.getFramePlugin().obterBarraProgresso();
            barra.inicializar("Preparando relat\u00f3rio para impress\u00e3o. AGUARDE...", qtdTotal, false);
            int contRegistros = 0;
            this.linhas.removeAllElements();
            Linha linha = null;
            if (qtdImportado > 0) {
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("RELAT\u00d3RIO DE CLIENTES IMPORTADOS:");
                this.linhas.addElement(linha);
                if (!linha.isNovaPagina()) {
                    linha.setNovaPagina(true);
                }
                i = 0;
                while (i < vetorImportado.size()) {
                    barra.setValor(contRegistros);
                    ++contRegistros;
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string2 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string2, 0, 9));
                    linha.setTexto("Nome..................: " + ((String[])vetorImportado.elementAt(i))[4]);
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string3 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string3, 0, 9));
                    linha.setTexto("Identifica\u00e7\u00e3o P/D\u00e9bito: " + ((String[])vetorImportado.elementAt(i))[0]);
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    String string4 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string4, 0, 9));
                    linha.setTexto("Banco.................: 001");
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    linha.setTab(40);
                    String string5 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string5, 0, 9));
                    linha.setTexto("Ag\u00eancia: " + ((String[])vetorImportado.elementAt(i))[2]);
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTab(60);
                    String string6 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string6, 0, 9));
                    linha.setTexto("Conta: " + ((String[])vetorImportado.elementAt(i))[3]);
                    this.linhas.addElement(linha);
                    this.linhas.addElement(this.getTraco());
                    ++i;
                }
                if (qtdImportado > 0) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string7 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string7, 1, 9));
                    linha.setTexto("Quantidade de Clientes Importados: " + qtdImportado);
                    this.linhas.addElement(linha);
                }
            }
            if (qtdRecusado > 0) {
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("RELAT\u00d3RIO DE CLIENTES RECUSADOS:");
                this.linhas.addElement(linha);
                if (!linha.isNovaPagina()) {
                    linha.setNovaPagina(true);
                }
                i = 0;
                while (i < vetorRecusado.size()) {
                    barra.setValor(contRegistros);
                    ++contRegistros;
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string8 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string8, 0, 9));
                    linha.setTexto("Nome..................: " + ((String[])vetorRecusado.elementAt(i))[4]);
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string9 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string9, 0, 9));
                    linha.setTexto("Identifica\u00e7\u00e3o P/D\u00e9bito: " + ((String[])vetorRecusado.elementAt(i))[0]);
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    String string10 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string10, 0, 9));
                    linha.setTexto("Banco.................: 001");
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    linha.setTab(40);
                    String string11 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string11, 0, 9));
                    linha.setTexto("Ag\u00eancia: " + ((String[])vetorRecusado.elementAt(i))[2]);
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTab(60);
                    String string12 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string12, 0, 9));
                    linha.setTexto("Conta: " + ((String[])vetorRecusado.elementAt(i))[3]);
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string13 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string13, 0, 9));
                    linha.setTexto("Mensagem de Erro......: " + (String)vetorRecusadoMensagem.elementAt(i));
                    this.linhas.addElement(linha);
                    this.linhas.addElement(this.getTraco());
                    ++i;
                }
                if (qtdRecusado > 0) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string14 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string14, 1, 9));
                    linha.setTexto("Quantidade de Clientes Recusados: " + qtdRecusado);
                    this.linhas.addElement(linha);
                }
            }
            barra.finalizar();
            ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de Importa\u00e7\u00e3o");
            ControleImpressao.getControle().setCodigoRelatorio("DBT602");
            ControleImpressao.getControle().imprimirLinhas(this.linhas, "Relat\u00f3rio de Importa\u00e7\u00e3o");
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void imprimirMovimento(MultiColumnListbox multi, int intNumeroRelatorio) {
        try {
            IBarraProgresso barra = this.getFramePlugin().obterBarraProgresso();
            barra.setValorMaximo(multi.getRowCount());
            barra.inicializar("Preparando relat\u00f3rio para impress\u00e3o. AGUARDE...", multi.getRowCount(), false);
            int tab1 = 65;
            this.multicolumn = multi;
            double valorTotal = 0.0;
            this.linhas.removeAllElements();
            Linha linha = this.getNovaLinha();
            ControleCliente.getControleCliente();
            if (ControleCliente.getFiltro().getDescricaoFiltro() != null) {
                StringBuffer stringBuffer = new StringBuffer("Movimentos: ");
                ControleMovimento.getControleMovimento();
                String descricaoFiltro = stringBuffer.append(ControleMovimento.getFiltro().getDescricaoFiltro()).toString();
                int i = 0;
                while (i < descricaoFiltro.length()) {
                    linha.setTexto(descricaoFiltro.substring(i, descricaoFiltro.length() < i + 100 ? descricaoFiltro.length() : i + 100));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    i += 100;
                }
                this.linhas.addElement(this.getTraco());
                linha = this.getNovaLinha();
            }
            int i = 0;
            while (i < this.multicolumn.getRowCount()) {
                barra.setValor(i);
                if (intNumeroRelatorio == 1) {
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    if ((String)this.multicolumn.getRow(i)[1] != null && !((String)this.multicolumn.getRow(i)[1]).equals("")) {
                        linha.setTexto("Inscri\u00e7\u00e3o..............: " + (String)this.multicolumn.getRow(i)[1]);
                    } else {
                        linha.setTexto("Inscri\u00e7\u00e3o..............: N\u00e3o Possui");
                    }
                    this.linhas.addElement(linha);
                    if (!(this.multicolumn.getColumnInfo(3).getLabel().equals("") || this.multicolumn.getColumnInfo(3).getLabel().equals(null) || this.multicolumn.getColumnInfo(3).getLabel().equals("(Identificador Pr\u00f3prio)"))) {
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        linha.setTab(55);
                        linha.setTexto(this.multicolumn.getColumnInfo(3).getLabel() + "                       ".substring(0, 10 - this.multicolumn.getColumnInfo(3).getLabel().toString().trim().length()) + ": " + (String)this.multicolumn.getRow(i)[3]);
                        this.linhas.addElement(linha);
                    } else {
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        this.linhas.addElement(linha);
                    }
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTexto("Nome...................: " + (String)this.multicolumn.getRow(i)[2]);
                    this.linhas.addElement(linha);
                } else if (intNumeroRelatorio == 3) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTexto("Nome...................: " + (String)this.multicolumn.getRow(i)[2]);
                    this.linhas.addElement(linha);
                }
                if (intNumeroRelatorio == 1 || intNumeroRelatorio == 2) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTexto("Conv\u00eanio...............: " + (String)this.multicolumn.getRow(i)[4]);
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTexto("Identificador P/D\u00e9bito.: " + (String)this.multicolumn.getRow(i)[5]);
                    this.linhas.addElement(linha);
                } else if (intNumeroRelatorio == 3) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTexto("Conv\u00eanio...............: " + (String)this.multicolumn.getRow(i)[4] + "    Identificador P/D\u00e9bito: " + (String)this.multicolumn.getRow(i)[5]);
                    this.linhas.addElement(linha);
                }
                if (!((String)this.multicolumn.getRow(i)[11]).equals("D\u00e9bito Efetuado")) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTexto("Banco..................: 001     Ag\u00eancia: " + (String)this.multicolumn.getRow(i)[7] + "     Conta  : " + (String)this.multicolumn.getRow(i)[8]);
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTexto("Data...................: " + (String)this.multicolumn.getRow(i)[9] + "                   Valor  : " + (String)this.multicolumn.getRow(i)[10]);
                    this.linhas.addElement(linha);
                } else {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTexto("Banco..................: 001     Ag\u00eancia: " + (String)this.multicolumn.getRow(i)[7] + "     Conta  : " + (String)this.multicolumn.getRow(i)[8]);
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTexto("Data D\u00e9bito Efetuado...: " + (String)this.multicolumn.getRow(i)[9] + "                   Valor  : " + (String)this.multicolumn.getRow(i)[10]);
                    this.linhas.addElement(linha);
                }
                if (this.multicolumn.getRow(i)[12].toString().trim().length() > 0) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTexto("Data da Remessa........: " + (String)this.multicolumn.getRow(i)[12]);
                    this.linhas.addElement(linha);
                }
                linha = this.getNovaLinha();
                linha.setSalto(true);
                linha.setTexto("Situa\u00e7\u00e3o...............: " + (String)this.multicolumn.getRow(i)[11]);
                this.linhas.addElement(linha);
                this.linhas.addElement(this.getTraco());
                valorTotal += Double.valueOf((String)this.multicolumn.getRow(i)[14]).doubleValue();
                ++i;
            }
            linha = this.getNovaLinha();
            linha.setSalto(true);
            String string = linha.getFonte().getName();
            linha.getFonte();
            linha.setFonte(new Font(string, 1, 9));
            linha.setTexto("Quantidade de Registros: " + this.multicolumn.getRowCount() + "   Valor Total: " + Util.formatarValor(valorTotal, 2));
            this.linhas.addElement(linha);
            if (this.multicolumn.getRowCount() < 1) {
                this.exibirMensagem("N\u00e3o h\u00e1 recebimentos para impress\u00e3o!");
            }
            barra.finalizar();
            if (intNumeroRelatorio == 1) {
                ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de Recebimentos - Clientes e Identifica\u00e7\u00f5es P/D\u00e9bito");
                ControleImpressao.getControle().setCodigoRelatorio("DBT301");
                ControleImpressao.getControle().imprimirLinhas(this.linhas, "Relat\u00f3rio de Recebimentos - Clientes e Identifica\u00e7\u00f5es P/D\u00e9bito");
            } else if (intNumeroRelatorio == 2) {
                ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de Recebimentos - Identifica\u00e7\u00e3o P/D\u00e9bito");
                ControleImpressao.getControle().setCodigoRelatorio("DBT302");
                ControleImpressao.getControle().imprimirLinhas(this.linhas, "Relat\u00f3rio de Recebimentos - Identifica\u00e7\u00e3o P/D\u00e9bito");
            } else if (intNumeroRelatorio == 3) {
                ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de Recebimentos - Nome e Identifica\u00e7\u00e3o P/D\u00e9bito");
                ControleImpressao.getControle().setCodigoRelatorio("DBT303");
                ControleImpressao.getControle().imprimirLinhas(this.linhas, "Relat\u00f3rio de Recebimentos - Nome e Identifica\u00e7\u00e3o P/D\u00e9bito");
            }
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void imprimirMovimentoUmaLinha(MultiColumnListbox multi) {
        try {
            IBarraProgresso barra = this.getFramePlugin().obterBarraProgresso();
            barra.setValorMaximo(multi.getRowCount());
            barra.inicializar("Preparando relat\u00f3rio para impress\u00e3o. AGUARDE...", multi.getRowCount(), false);
            int tab1 = 65;
            int contador = 53;
            double valorTotal = 0.0;
            this.multicolumn = multi;
            this.linhas.removeAllElements();
            Linha linha = this.getNovaLinha();
            ControleCliente.getControleCliente();
            if (ControleCliente.getFiltro().getDescricaoFiltro() != null) {
                StringBuffer stringBuffer = new StringBuffer("Movimentos: ");
                ControleMovimento.getControleMovimento();
                String descricaoFiltro = stringBuffer.append(ControleMovimento.getFiltro().getDescricaoFiltro()).toString();
                int i = 0;
                while (i < descricaoFiltro.length()) {
                    linha.setTexto(descricaoFiltro.substring(i, descricaoFiltro.length() < i + 100 ? descricaoFiltro.length() : i + 100));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    i += 100;
                }
                this.linhas.addElement(this.getTraco());
                linha = this.getNovaLinha();
            }
            int i = 0;
            while (i < this.multicolumn.getRowCount()) {
                barra.setValor(i);
                if (contador > 52) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string, 1, 10));
                    linha.setTexto("Nome                               Conv\u00eanio Identificador P/D\u00e9bito    Data          Valor         Situa\u00e7\u00e3o");
                    this.linhas.addElement(linha);
                    contador = 0;
                }
                linha = this.getNovaLinha();
                linha.setSalto(false);
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 0, 9));
                linha.setTexto((String)this.multicolumn.getRow(i)[2]);
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setSalto(false);
                String string2 = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string2, 0, 9));
                linha.setTab(30);
                linha.setTexto((String)this.multicolumn.getRow(i)[4]);
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setSalto(false);
                linha.setTab(33);
                String string3 = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string3, 0, 9));
                linha.setTexto(Util.padR((String)this.multicolumn.getRow(i)[5], 25));
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setSalto(false);
                linha.setTab(51);
                String string4 = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string4, 0, 9));
                linha.setTexto((String)this.multicolumn.getRow(i)[9]);
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setSalto(false);
                linha.setTab(59);
                String string5 = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string5, 0, 9));
                linha.setTexto(Util.padR((String)this.multicolumn.getRow(i)[10], 17));
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setSalto(true);
                linha.setTab(73);
                String string6 = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string6, 0, 9));
                linha.setTexto((String)this.multicolumn.getRow(i)[11]);
                this.linhas.addElement(linha);
                ++contador;
                valorTotal += Double.valueOf((String)this.multicolumn.getRow(i)[14]).doubleValue();
                ++i;
            }
            linha = this.getNovaLinha();
            linha.setSalto(true);
            String string = linha.getFonte().getName();
            linha.getFonte();
            linha.setFonte(new Font(string, 1, 9));
            linha.setTexto("Quantidade de Registros: " + this.multicolumn.getRowCount() + "   Valor Total: " + Util.formatarValor(valorTotal, 2));
            this.linhas.addElement(linha);
            if (this.multicolumn.getRowCount() < 1) {
                this.exibirMensagem("N\u00e3o h\u00e1 recebimentos para impress\u00e3o!");
            }
            barra.finalizar();
            ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de Recebimentos - Nome e Identifica\u00e7\u00e3o P/D\u00e9bito");
            ControleImpressao.getControle().setCodigoRelatorio("DBT304");
            ControleImpressao.getControle().imprimirLinhas(this.linhas, "Relat\u00f3rio de Recebimentos - Nome e Identifica\u00e7\u00e3o P/D\u00e9bito");
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void imprimirRemessa(Vector vetorParametrosRemessa) {
        try {
            int i;
            this.vetorParametrosRemessa = vetorParametrosRemessa;
            this.convenioDBT = (ConvenioDBT)vetorParametrosRemessa.elementAt(0);
            this.vetorRecebimentosRemessa = (Vector)vetorParametrosRemessa.elementAt(1);
            this.vetorIDManutencaoRemessa = (Vector)vetorParametrosRemessa.elementAt(2);
            this.vetorIDAlteradoRemessa = (Vector)vetorParametrosRemessa.elementAt(3);
            this.vetorRecebimentosManutRem = (Vector)vetorParametrosRemessa.elementAt(6);
            String valorTotalRemessa = (String)vetorParametrosRemessa.elementAt(4);
            this.valorTotal = Double.valueOf(valorTotalRemessa);
            String qtdTotalRemessa = (String)vetorParametrosRemessa.elementAt(5);
            this.QtdTotal = Integer.valueOf(qtdTotalRemessa);
            IBarraProgresso barra = this.getFramePlugin().obterBarraProgresso();
            barra.setValorMaximo(this.QtdTotal);
            barra.inicializar("Preparando relat\u00f3rio para impress\u00e3o. AGUARDE...", this.QtdTotal, false);
            this.linhas.removeAllElements();
            Linha linha = this.getNovaLinha();
            int registro = 0;
            RecebimentoDBT recebimentoDBT = new RecebimentoDBT();
            IdentificadorDBT identificadorDBT = new IdentificadorDBT();
            if (this.vetorIDManutencaoRemessa.size() > 0) {
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("Tipo de Registro: MANUTEN\u00c7\u00c3O DE IDENTIFICA\u00c7\u00c3O P/D\u00c9BITO");
                this.linhas.addElement(linha);
                if (!linha.isNovaPagina()) {
                    linha.setNovaPagina(true);
                }
                i = 0;
                while (i < this.vetorIDManutencaoRemessa.size()) {
                    identificadorDBT = (IdentificadorDBT)this.vetorIDManutencaoRemessa.elementAt(i);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string2 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string2, 0, 9));
                    this.pessoaDBT = new Pessoa();
                    this.pessoaDBT.setCodigoPessoa(identificadorDBT.getIdentificacaoDBT().getCodigoPessoaRel());
                    PessoaBD.getPessoaBD().obter(this.pessoaDBT);
                    linha.setTexto("Nome..................: " + this.pessoaDBT.getNomePessoa());
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string3 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string3, 0, 9));
                    linha.setTexto("Identificador P/D\u00e9bito: " + Util.formatarString(identificadorDBT.getIdentificacaoDBT().getNumeroIdentificador(), identificadorDBT.getIdentificacaoDBT().getIdentificador().getMascara()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    String string4 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string4, 0, 9));
                    linha.setTexto("Banco.................: 001");
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    linha.setTab(40);
                    String string5 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string5, 0, 9));
                    linha.setTexto("Ag\u00eancia: " + Util.formatarConta(identificadorDBT.getContaCorrente().getAgencia().getCodigoPrefixoAgencia()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTab(60);
                    String string6 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string6, 0, 9));
                    linha.setTexto("Conta: " + Util.formatarConta(identificadorDBT.getContaCorrente().getnumeroContaCorrente()));
                    this.linhas.addElement(linha);
                    this.linhas.addElement(this.getTraco());
                    barra.setValor(++registro);
                    ++i;
                }
                if (this.vetorRecebimentosManutRem.size() < 1) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string7 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string7, 1, 9));
                    linha.setTexto("Quantidade de Registros: " + (this.vetorIDManutencaoRemessa.size() + this.vetorRecebimentosManutRem.size()));
                    this.linhas.addElement(linha);
                }
            }
            if (this.vetorRecebimentosManutRem.size() > 0) {
                if (this.vetorIDManutencaoRemessa.size() < 1) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string, 1, 9));
                    linha.setTexto("Tipo de Registro: MANUTEN\u00c7\u00c3O DE IDENTIFICA\u00c7\u00c3O P/D\u00c9BITO");
                    this.linhas.addElement(linha);
                    if (!linha.isNovaPagina()) {
                        linha.setNovaPagina(true);
                    }
                }
                i = 0;
                while (i < this.vetorRecebimentosManutRem.size()) {
                    recebimentoDBT = (RecebimentoDBT)this.vetorRecebimentosManutRem.elementAt(i);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string, 0, 9));
                    linha.setTexto("Nome..................: " + recebimentoDBT.getCliente().getPessoa().getNomePessoa());
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string8 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string8, 0, 9));
                    linha.setTexto("Identifica\u00e7\u00e3o P/d\u00e9bito: " + Util.formatarString(recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador(), recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().getIdentificador().getMascara()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    String string9 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string9, 0, 9));
                    linha.setTexto("Banco.................: 001");
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    linha.setTab(40);
                    String string10 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string10, 0, 9));
                    linha.setTexto("Ag\u00eancia: " + Util.formatarConta(recebimentoDBT.getIdentificadorDBT().getContaCorrente().getAgencia().getCodigoPrefixoAgencia()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTab(60);
                    String string11 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string11, 0, 9));
                    linha.setTexto("Conta: " + Util.formatarConta(recebimentoDBT.getIdentificadorDBT().getContaCorrente().getnumeroContaCorrente()));
                    this.linhas.addElement(linha);
                    this.linhas.addElement(this.getTraco());
                    barra.setValor(++registro);
                    ++i;
                }
                if (this.vetorIDManutencaoRemessa.size() > 0) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string, 1, 9));
                    linha.setTexto("Quantidade de Registros: " + (this.vetorRecebimentosManutRem.size() + this.vetorIDManutencaoRemessa.size()));
                    this.linhas.addElement(linha);
                }
            }
            if (this.vetorIDAlteradoRemessa.size() > 0) {
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("Tipo de Registro: ALTERA\u00c7\u00c3O/EXCLUS\u00c3O DE IDENTIFICA\u00c7\u00c3O PARA D\u00c9BITO");
                this.linhas.addElement(linha);
                if (!linha.isNovaPagina()) {
                    linha.setNovaPagina(true);
                }
                i = 0;
                while (i < this.vetorIDAlteradoRemessa.size()) {
                    identificadorDBT = (IdentificadorDBT)this.vetorIDAlteradoRemessa.elementAt(i);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string12 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string12, 0, 9));
                    this.pessoaDBT = new Pessoa();
                    this.pessoaDBT.setCodigoPessoa(identificadorDBT.getIdentificacaoDBT().getCodigoPessoaRel());
                    PessoaBD.getPessoaBD().obter(this.pessoaDBT);
                    linha.setTexto("Nome..................: " + this.pessoaDBT.getNomePessoa());
                    this.linhas.addElement(linha);
                    if (!identificadorDBT.getNumeroIdentificadorAntigo().equals("AGUARDANDO EXCLUSAO NO BB")) {
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string13 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string13, 0, 9));
                        linha.setTexto("ID P/D\u00e9bito Anterior..: " + Util.formatarString(identificadorDBT.getNumeroIdentificadorAntigo(), identificadorDBT.getIdentificacaoDBT().getIdentificador().getMascara()));
                        this.linhas.addElement(linha);
                    }
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string14 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string14, 0, 9));
                    linha.setTexto("ID P/D\u00e9bito Atual.....: " + Util.formatarString(identificadorDBT.getIdentificacaoDBT().getNumeroIdentificador(), identificadorDBT.getIdentificacaoDBT().getIdentificador().getMascara()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    linha.setTab(40);
                    String string15 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string15, 0, 9));
                    linha.setTexto("Ag\u00eancia: " + Util.formatarConta(identificadorDBT.getContaCorrente().getAgencia().getCodigoPrefixoAgencia()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    String string16 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string16, 0, 9));
                    linha.setTexto("Banco.................: 001");
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTab(60);
                    String string17 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string17, 0, 9));
                    linha.setTexto("Conta: " + Util.formatarConta(identificadorDBT.getContaCorrente().getnumeroContaCorrente()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string18 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string18, 0, 9));
                    linha.setTexto("C\u00f3digo do Movimento...: " + (identificadorDBT.getNumeroIdentificadorAntigo().equals("AGUARDANDO EXCLUSAO NO BB") ? "Exclus\u00e3o de Identifica\u00e7\u00e3o de D\u00e9bito" : "Altera\u00e7\u00e3o de Identifica\u00e7\u00e3o de D\u00e9bito"));
                    this.linhas.addElement(linha);
                    this.linhas.addElement(this.getTraco());
                    barra.setValor(++registro);
                    ++i;
                }
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string19 = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string19, 1, 9));
                linha.setTexto("Quantidade de Registros: " + this.vetorIDAlteradoRemessa.size());
                this.linhas.addElement(linha);
            }
            if (this.vetorRecebimentosRemessa.size() > 0) {
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("Tipo de Registro: RECEBIMENTOS");
                this.linhas.addElement(linha);
                if (!linha.isNovaPagina()) {
                    linha.setNovaPagina(true);
                }
                i = 0;
                while (i < this.vetorRecebimentosRemessa.size()) {
                    recebimentoDBT = (RecebimentoDBT)this.vetorRecebimentosRemessa.elementAt(i);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string20 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string20, 0, 9));
                    linha.setTexto("Nome..................: " + recebimentoDBT.getCliente().getPessoa().getNomePessoa());
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string21 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string21, 0, 9));
                    linha.setTexto("Identifica\u00e7\u00e3o P/d\u00e9bito: " + Util.formatarString(recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador(), recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().getIdentificador().getMascara()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    String string22 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string22, 0, 9));
                    linha.setTexto("Banco.................: 001");
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    linha.setTab(40);
                    String string23 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string23, 0, 9));
                    linha.setTexto("Ag\u00eancia: " + Util.formatarConta(recebimentoDBT.getIdentificadorDBT().getContaCorrente().getAgencia().getCodigoPrefixoAgencia()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTab(60);
                    String string24 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string24, 0, 9));
                    linha.setTexto("Conta: " + Util.formatarConta(recebimentoDBT.getIdentificadorDBT().getContaCorrente().getnumeroContaCorrente()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    String string25 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string25, 0, 9));
                    linha.setTexto("Data..................: " + Util.formatarData(recebimentoDBT.getDataRecebimento()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    linha.setTab(60);
                    String string26 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string26, 0, 9));
                    linha.setTexto("Valor: " + Util.formatarValor(recebimentoDBT.getValorRecebimento(), 2));
                    this.linhas.addElement(linha);
                    this.linhas.addElement(this.getTraco());
                    barra.setValor(++registro);
                    ++i;
                }
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string27 = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string27, 1, 9));
                linha.setTexto("Quantidade de Registros: " + this.vetorRecebimentosRemessa.size());
                this.linhas.addElement(linha);
            }
            this.linhas.addElement(this.getTraco());
            linha = this.getNovaLinha();
            linha.setSalto(true);
            String string = linha.getFonte().getName();
            linha.getFonte();
            linha.setFonte(new Font(string, 1, 9));
            linha.setTexto("Quantidade Total de Registros: " + this.QtdTotal);
            this.linhas.addElement(linha);
            linha = this.getNovaLinha();
            linha.setSalto(true);
            String string28 = linha.getFonte().getName();
            linha.getFonte();
            linha.setFonte(new Font(string28, 1, 9));
            linha.setTexto("Valor Total dos Recebimentos: " + Util.formatarValor(this.valorTotal, 2));
            this.linhas.addElement(linha);
            barra.finalizar();
            ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de Recebimentos para Remessa");
            ControleImpressao.getControle().setCodigoRelatorio("DBT501");
            ControleImpressao.getControle().imprimirLinhas(this.linhas, "Relat\u00f3rio de Recebimentos para Remessa - Conv\u00eanio " + this.convenioDBT.getNumeroConvenioDBT());
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void imprimirRetornoRelatorio(Vector vetorRetorno, boolean imprimirRecProc, boolean imprimirRecOcor, boolean imprimirIDProc, boolean imprimirIDOcor, boolean imprimirReg) {
        try {
            RecebimentoDBT recebimento;
            int j;
            int intPosicao;
            int intQtd;
            IdentificadorDBT identificadorDBT;
            int i;
            Vector recebimentos = (Vector)vetorRetorno.elementAt(0);
            Vector recebimentosNaoProc = (Vector)vetorRetorno.elementAt(1);
            Vector OcorrenciaRecebimentos = (Vector)vetorRetorno.elementAt(2);
            Vector OcorrenciaRecebimentosNaoProc = (Vector)vetorRetorno.elementAt(3);
            Vector situacaoRecebimentos = (Vector)vetorRetorno.elementAt(4);
            Vector situacaoRecebimentosNaoProc = (Vector)vetorRetorno.elementAt(5);
            Vector identificadoresAlterados = (Vector)vetorRetorno.elementAt(6);
            Vector identificadoresAlteradosNaoProc = (Vector)vetorRetorno.elementAt(7);
            Vector situacaoIdAlterados = (Vector)vetorRetorno.elementAt(8);
            Vector situacaoIdAlteradosNaoProc = (Vector)vetorRetorno.elementAt(9);
            Vector identificadoresCadastrados = (Vector)vetorRetorno.elementAt(10);
            Vector situacaoIdCadastrados = (Vector)vetorRetorno.elementAt(11);
            Vector registrosNaoProcessados = (Vector)vetorRetorno.elementAt(12);
            Vector identificacaoArquivoRetorno = (Vector)vetorRetorno.elementAt(13);
            int qtdRecProc = ((Vector)vetorRetorno.elementAt(0)).size();
            int qtdRecOcor = ((Vector)vetorRetorno.elementAt(1)).size();
            int qtdIDProc = ((Vector)vetorRetorno.elementAt(6)).size() + ((Vector)vetorRetorno.elementAt(10)).size();
            int qtdIDOcor = ((Vector)vetorRetorno.elementAt(7)).size();
            int qtdReg = ((Vector)vetorRetorno.elementAt(12)).size();
            int qtdTotal = 0;
            double valorTotalRec = 0.0;
            double valorRecProc = 0.0;
            double valorRecOcorr = 0.0;
            if (imprimirRecProc) {
                qtdTotal += qtdRecProc;
            }
            if (imprimirRecOcor) {
                qtdTotal += qtdRecOcor;
            }
            if (imprimirIDProc) {
                qtdTotal += qtdIDProc;
            }
            if (imprimirIDOcor) {
                qtdTotal += qtdIDOcor;
            }
            if (imprimirReg) {
                qtdTotal += qtdReg;
            }
            String registro = "";
            IBarraProgresso barra = this.getFramePlugin().obterBarraProgresso();
            barra.inicializar("Preparando relat\u00f3rio para impress\u00e3o. AGUARDE...", qtdTotal, false);
            int contRegistros = 0;
            this.linhas.removeAllElements();
            Linha linha = null;
            String nomeArq = (String)identificacaoArquivoRetorno.elementAt(0);
            String convenio = (String)identificacaoArquivoRetorno.elementAt(1);
            String numeroRet = (String)identificacaoArquivoRetorno.elementAt(2);
            String dataRet = (String)identificacaoArquivoRetorno.elementAt(3);
            if (imprimirIDProc) {
                linha = this.getNovaLinha();
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("Nome do Arquivo: " + nomeArq + "  Conv\u00eanio: " + convenio + "  N\u00ba Retorno: " + numeroRet + "  Data Retorno: " + dataRet);
                this.linhas.addElement(linha);
                if (!linha.isNovaPagina()) {
                    linha.setNovaPagina(true);
                }
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string2 = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string2, 1, 9));
                linha.setTexto("Tipo de Registro: CADASTRAMENTO/EXCLUS\u00c3O DE IDENTIFICA\u00c7\u00c3O P/D\u00c9BITO");
                this.linhas.addElement(linha);
                i = 0;
                while (i < identificadoresCadastrados.size()) {
                    barra.setValor(contRegistros);
                    ++contRegistros;
                    identificadorDBT = (IdentificadorDBT)identificadoresCadastrados.elementAt(i);
                    this.pessoaDBT = new Pessoa();
                    this.pessoaDBT.setCodigoPessoa(identificadorDBT.getIdentificacaoDBT().getCodigoPessoaRel());
                    PessoaBD.getPessoaBD().obter(this.pessoaDBT);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string3 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string3, 0, 9));
                    linha.setTexto("Nome..................: " + (this.pessoaDBT.getNomePessoa() == null ? "" : this.pessoaDBT.getNomePessoa()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string4 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string4, 0, 9));
                    linha.setTexto("Identifica\u00e7\u00e3o P/D\u00e9bito: " + Util.formatarString(identificadorDBT.getIdentificacaoDBT().getNumeroIdentificador(), identificadorDBT.getIdentificacaoDBT().getIdentificador().getMascara()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    String string5 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string5, 0, 9));
                    linha.setTexto("Banco.................: 001");
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    linha.setTab(40);
                    String string6 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string6, 0, 9));
                    linha.setTexto("Ag\u00eancia: " + Util.formatarConta(identificadorDBT.getContaCorrente().getAgencia().getCodigoPrefixoAgencia()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    linha.setTab(60);
                    String string7 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string7, 0, 9));
                    linha.setTexto("Conta: " + Util.formatarConta(identificadorDBT.getContaCorrente().getnumeroContaCorrente()));
                    this.linhas.addElement(linha);
                    linha.setSalto(true);
                    linha = this.getNovaLinha();
                    String string8 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string8, 0, 9));
                    linha.setTexto("Situa\u00e7\u00e3o..............: " + (String)situacaoIdCadastrados.elementAt(i));
                    this.linhas.addElement(linha);
                    registro = identificadorDBT.getTextoDescricaoOcorrencia();
                    if (registro.length() <= 70) {
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string9 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string9, 0, 9));
                        linha.setTexto("Ocorr\u00eancia............: " + registro);
                        this.linhas.addElement(linha);
                        this.linhas.addElement(this.getTraco());
                    } else {
                        intQtd = registro.length() / 70;
                        intPosicao = 0;
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string10 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string10, 0, 9));
                        linha.setTexto("Ocorr\u00eancia............: " + registro.substring(intPosicao, intPosicao + 70));
                        this.linhas.addElement(linha);
                        intPosicao += 70;
                        j = 0;
                        while (j < intQtd - 1) {
                            linha = this.getNovaLinha();
                            linha.setSalto(true);
                            String string11 = linha.getFonte().getName();
                            linha.getFonte();
                            linha.setFonte(new Font(string11, 0, 9));
                            linha.setTexto("                        " + registro.substring(intPosicao, intPosicao + 70));
                            this.linhas.addElement(linha);
                            intPosicao += 70;
                            ++j;
                        }
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string12 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string12, 0, 9));
                        linha.setTexto("                        " + registro.substring(intPosicao, registro.length()));
                        this.linhas.addElement(linha);
                        this.linhas.addElement(this.getTraco());
                    }
                    ++i;
                }
                i = 0;
                while (i < identificadoresAlterados.size()) {
                    barra.setValor(contRegistros);
                    ++contRegistros;
                    identificadorDBT = (IdentificadorDBT)identificadoresAlterados.elementAt(i);
                    this.pessoaDBT = new Pessoa();
                    this.pessoaDBT.setCodigoPessoa(identificadorDBT.getIdentificacaoDBT().getCodigoPessoaRel());
                    PessoaBD.getPessoaBD().obter(this.pessoaDBT);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string13 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string13, 0, 9));
                    linha.setTexto("Nome...........................: " + (this.pessoaDBT.getNomePessoa() == null ? "" : this.pessoaDBT.getNomePessoa()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    String string14 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string14, 0, 9));
                    linha.setTexto("Identificador P/D\u00e9bito Anterior: " + (identificadorDBT.getNumeroIdentificadorAntigo() == null ? "N\u00e3o Possui" : Util.formatarString(identificadorDBT.getNumeroIdentificadorAntigo(), identificadorDBT.getIdentificacaoDBT().getIdentificador().getMascara())));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string15 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string15, 0, 9));
                    linha.setTexto("Identificador P/D\u00e9bito Atual...: " + Util.formatarString(identificadorDBT.getIdentificacaoDBT().getNumeroIdentificador(), identificadorDBT.getIdentificacaoDBT().getIdentificador().getMascara()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    String string16 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string16, 0, 9));
                    linha.setTexto("Banco..........................: 001");
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTab(45);
                    String string17 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string17, 0, 9));
                    linha.setTexto("Ag\u00eancia: " + Util.formatarConta(identificadorDBT.getContaCorrente().getAgencia().getCodigoPrefixoAgencia()));
                    this.linhas.addElement(linha);
                    linha.setSalto(false);
                    linha = this.getNovaLinha();
                    linha.setTab(65);
                    String string18 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string18, 0, 9));
                    linha.setTexto("Conta: " + Util.formatarConta(identificadorDBT.getContaCorrente().getnumeroContaCorrente()));
                    this.linhas.addElement(linha);
                    linha.setSalto(true);
                    linha = this.getNovaLinha();
                    String string19 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string19, 0, 9));
                    linha.setTexto("Situa\u00e7\u00e3o.......................: " + (String)situacaoIdAlterados.elementAt(i));
                    this.linhas.addElement(linha);
                    registro = identificadorDBT.getTextoDescricaoOcorrencia();
                    if (registro.length() <= 60) {
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string20 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string20, 0, 9));
                        linha.setTexto("Ocorr\u00eancia.....................: " + registro);
                        this.linhas.addElement(linha);
                        this.linhas.addElement(this.getTraco());
                    } else {
                        intQtd = registro.length() / 60;
                        intPosicao = 0;
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string21 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string21, 0, 9));
                        linha.setTexto("Ocorr\u00eancia.....................: " + registro.substring(intPosicao, intPosicao + 60));
                        this.linhas.addElement(linha);
                        intPosicao += 60;
                        j = 0;
                        while (j < intQtd - 1) {
                            linha = this.getNovaLinha();
                            linha.setSalto(true);
                            String string22 = linha.getFonte().getName();
                            linha.getFonte();
                            linha.setFonte(new Font(string22, 0, 9));
                            linha.setTexto("                                 " + registro.substring(intPosicao, intPosicao + 60));
                            this.linhas.addElement(linha);
                            intPosicao += 60;
                            ++j;
                        }
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string23 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string23, 0, 9));
                        linha.setTexto("                                 " + registro.substring(intPosicao, registro.length()));
                        this.linhas.addElement(linha);
                        this.linhas.addElement(this.getTraco());
                    }
                    ++i;
                }
                if (qtdIDProc > 0) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string24 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string24, 1, 9));
                    linha.setTexto("Quantidade de Registros: " + qtdIDProc);
                    this.linhas.addElement(linha);
                }
            }
            if (imprimirIDOcor) {
                linha = this.getNovaLinha();
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("Nome do Arquivo: " + nomeArq + "  Conv\u00eanio: " + convenio + "  N\u00ba Retorno: " + numeroRet + "  Data Retorno: " + dataRet);
                this.linhas.addElement(linha);
                if (!linha.isNovaPagina()) {
                    linha.setNovaPagina(true);
                }
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string25 = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string25, 1, 9));
                linha.setTexto("Tipo de Registro: ALTERA\u00c7\u00c3O DE IDENTIFICA\u00c7\u00c3O P/D\u00c9BITO COM OCORR\u00caNCIA");
                this.linhas.addElement(linha);
                i = 0;
                while (i < identificadoresAlteradosNaoProc.size()) {
                    barra.setValor(contRegistros);
                    ++contRegistros;
                    identificadorDBT = (IdentificadorDBT)identificadoresAlteradosNaoProc.elementAt(i);
                    this.pessoaDBT = new Pessoa();
                    this.pessoaDBT.setCodigoPessoa(identificadorDBT.getIdentificacaoDBT().getCodigoPessoaRel());
                    PessoaBD.getPessoaBD().obter(this.pessoaDBT);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string26 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string26, 0, 9));
                    linha.setTexto("Nome...........................: " + (this.pessoaDBT.getNomePessoa() == null ? "" : this.pessoaDBT.getNomePessoa()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    String string27 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string27, 0, 9));
                    linha.setTexto("Identificador P/D\u00e9bito Anterior: " + Util.formatarString(identificadorDBT.getNumeroIdentificadorAntigo(), identificadorDBT.getIdentificacaoDBT().getIdentificador().getMascara()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string28 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string28, 0, 9));
                    linha.setTexto("Identificador P/D\u00e9bito Atual...: " + Util.formatarString(identificadorDBT.getIdentificacaoDBT().getNumeroIdentificador(), identificadorDBT.getIdentificacaoDBT().getIdentificador().getMascara()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    String string29 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string29, 0, 9));
                    linha.setTexto("Banco..........................: 001");
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setTab(45);
                    String string30 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string30, 0, 9));
                    linha.setTexto("Ag\u00eancia: " + Util.formatarConta(identificadorDBT.getContaCorrente().getAgencia().getCodigoPrefixoAgencia()));
                    this.linhas.addElement(linha);
                    linha.setSalto(false);
                    linha = this.getNovaLinha();
                    linha.setTab(65);
                    String string31 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string31, 0, 9));
                    linha.setTexto("Conta: " + Util.formatarConta(identificadorDBT.getContaCorrente().getnumeroContaCorrente()));
                    this.linhas.addElement(linha);
                    registro = (String)situacaoIdAlteradosNaoProc.elementAt(i);
                    if (registro.length() <= 60) {
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string32 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string32, 0, 9));
                        linha.setTexto("Situa\u00e7\u00e3o.......................: " + registro);
                        this.linhas.addElement(linha);
                        this.linhas.addElement(this.getTraco());
                    } else {
                        intQtd = registro.length() / 60;
                        intPosicao = 0;
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string33 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string33, 0, 9));
                        linha.setTexto("Situa\u00e7\u00e3o.......................: " + registro.substring(intPosicao, intPosicao + 60));
                        this.linhas.addElement(linha);
                        intPosicao += 60;
                        j = 0;
                        while (j < intQtd - 1) {
                            linha = this.getNovaLinha();
                            linha.setSalto(true);
                            String string34 = linha.getFonte().getName();
                            linha.getFonte();
                            linha.setFonte(new Font(string34, 0, 9));
                            linha.setTexto("                                 " + registro.substring(intPosicao, intPosicao + 60));
                            this.linhas.addElement(linha);
                            intPosicao += 60;
                            ++j;
                        }
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string35 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string35, 0, 9));
                        linha.setTexto("                                 " + registro.substring(intPosicao, registro.length()));
                        this.linhas.addElement(linha);
                    }
                    registro = identificadorDBT.getTextoDescricaoOcorrencia();
                    if (registro.length() <= 60) {
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string36 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string36, 0, 9));
                        linha.setTexto("Ocorr\u00eancia.....................: " + registro);
                        this.linhas.addElement(linha);
                        this.linhas.addElement(this.getTraco());
                    } else {
                        intQtd = registro.length() / 60;
                        intPosicao = 0;
                        j = 0;
                        while (j < intQtd - 1) {
                            linha = this.getNovaLinha();
                            linha.setSalto(true);
                            String string37 = linha.getFonte().getName();
                            linha.getFonte();
                            linha.setFonte(new Font(string37, 0, 9));
                            linha.setTexto("Ocorr\u00eancia.....................: " + registro.substring(intPosicao, intPosicao + 60));
                            this.linhas.addElement(linha);
                            intPosicao += 60;
                            ++j;
                        }
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string38 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string38, 0, 9));
                        linha.setTexto("                                 " + registro.substring(intPosicao, registro.length()));
                        this.linhas.addElement(linha);
                        this.linhas.addElement(this.getTraco());
                    }
                    ++i;
                }
                if (qtdIDOcor > 0) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string39 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string39, 1, 9));
                    linha.setTexto("Quantidade de Registros: " + qtdIDOcor);
                    this.linhas.addElement(linha);
                }
            }
            if (imprimirRecProc) {
                linha = this.getNovaLinha();
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("Nome do Arquivo: " + nomeArq + "  Conv\u00eanio: " + convenio + "  N\u00ba Retorno: " + numeroRet + "  Data Retorno: " + dataRet);
                this.linhas.addElement(linha);
                if (!linha.isNovaPagina()) {
                    linha.setNovaPagina(true);
                }
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string40 = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string40, 1, 9));
                linha.setTexto("Tipo de Registro: RECEBIMENTO COM D\u00c9BITO EFETUADO");
                this.linhas.addElement(linha);
                i = 0;
                while (i < recebimentos.size()) {
                    barra.setValor(contRegistros);
                    ++contRegistros;
                    recebimento = (RecebimentoDBT)recebimentos.elementAt(i);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string41 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string41, 0, 9));
                    linha.setTexto("Nome..................: " + (recebimento.getCliente().getPessoa().getNomePessoa() == null ? "" : recebimento.getCliente().getPessoa().getNomePessoa()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string42 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string42, 0, 9));
                    linha.setTexto("Identificador P/D\u00e9bito: " + Util.formatarString(recebimento.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador(), recebimento.getIdentificadorDBT().getIdentificacaoDBT().getIdentificador().getMascara()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    String string43 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string43, 0, 9));
                    linha.setTexto("Banco.................: 001");
                    this.linhas.addElement(linha);
                    linha.setSalto(false);
                    linha = this.getNovaLinha();
                    linha.setTab(40);
                    String string44 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string44, 0, 9));
                    linha.setTexto("Ag\u00eancia: " + Util.formatarConta(recebimento.getCodigoPrefixoAgenciaLiquidacao()));
                    this.linhas.addElement(linha);
                    linha.setSalto(false);
                    linha = this.getNovaLinha();
                    linha.setTab(60);
                    String string45 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string45, 0, 9));
                    linha.setTexto("Conta: " + Util.formatarConta(recebimento.getNumeroContaCorrenteLiquidacao()));
                    this.linhas.addElement(linha);
                    linha.setSalto(true);
                    linha = this.getNovaLinha();
                    String string46 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string46, 0, 9));
                    linha.setTexto("Data..................: " + Util.formatarData(recebimento.getDataDebitoEfetuado()));
                    this.linhas.addElement(linha);
                    linha.setSalto(false);
                    linha = this.getNovaLinha();
                    linha.setTab(60);
                    String string47 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string47, 0, 9));
                    linha.setTexto("Valor: " + Util.formatarValor(recebimento.getValorDebitoEfetuado(), 2));
                    this.linhas.addElement(linha);
                    linha.setSalto(true);
                    linha = this.getNovaLinha();
                    String string48 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string48, 0, 9));
                    linha.setTexto("Situa\u00e7\u00e3o..............: " + (String)situacaoRecebimentos.elementAt(i));
                    this.linhas.addElement(linha);
                    registro = (String)OcorrenciaRecebimentos.elementAt(i);
                    if (registro.length() <= 70) {
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string49 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string49, 0, 9));
                        linha.setTexto("Ocorr\u00eancia............: " + registro);
                        this.linhas.addElement(linha);
                        this.linhas.addElement(this.getTraco());
                    } else {
                        intQtd = registro.length() / 70;
                        intPosicao = 0;
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string50 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string50, 0, 9));
                        linha.setTexto("Ocorr\u00eancia............: " + registro.substring(intPosicao, intPosicao + 70));
                        this.linhas.addElement(linha);
                        intPosicao += 70;
                        j = 0;
                        while (j < intQtd - 1) {
                            linha = this.getNovaLinha();
                            linha.setSalto(true);
                            String string51 = linha.getFonte().getName();
                            linha.getFonte();
                            linha.setFonte(new Font(string51, 0, 9));
                            linha.setTexto("                        " + registro.substring(intPosicao, intPosicao + 70));
                            this.linhas.addElement(linha);
                            intPosicao += 70;
                            ++j;
                        }
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string52 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string52, 0, 9));
                        linha.setTexto("                        " + registro.substring(intPosicao, registro.length()));
                        this.linhas.addElement(linha);
                        this.linhas.addElement(this.getTraco());
                    }
                    valorRecProc += recebimento.getValorRecebimento();
                    valorTotalRec += recebimento.getValorRecebimento();
                    ++i;
                }
                if (qtdRecProc > 0) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string53 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string53, 1, 9));
                    linha.setTexto("Quantidade de Registros: " + qtdRecProc);
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string54 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string54, 1, 9));
                    linha.setTexto("Valor dos Recebimentos com D\u00e9bito Efetuado: " + Util.formatarValor(valorRecProc, 2));
                    this.linhas.addElement(linha);
                }
            }
            if (imprimirRecOcor) {
                linha = this.getNovaLinha();
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("Nome do Arquivo: " + nomeArq + "  Conv\u00eanio: " + convenio + "  N\u00ba Retorno: " + numeroRet + "  Data Retorno: " + dataRet);
                this.linhas.addElement(linha);
                if (!linha.isNovaPagina()) {
                    linha.setNovaPagina(true);
                }
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string55 = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string55, 1, 9));
                linha.setTexto("Tipo de Registro: RECEBIMENTO COM OCORR\u00caNCIA");
                this.linhas.addElement(linha);
                i = 0;
                while (i < recebimentosNaoProc.size()) {
                    barra.setValor(contRegistros);
                    ++contRegistros;
                    recebimento = (RecebimentoDBT)recebimentosNaoProc.elementAt(i);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string56 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string56, 0, 9));
                    linha.setTexto("Nome..................: " + (recebimento.getCliente().getPessoa().getNomePessoa() == null ? "" : recebimento.getCliente().getPessoa().getNomePessoa()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string57 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string57, 0, 9));
                    linha.setTexto("Identificador P/D\u00e9bito: " + Util.formatarString(recebimento.getIdentificadorDBT().getIdentificacaoDBT().getNumeroIdentificador(), recebimento.getIdentificadorDBT().getIdentificacaoDBT().getIdentificador().getMascara()));
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(false);
                    String string58 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string58, 0, 9));
                    linha.setTexto("Banco.................: 001");
                    this.linhas.addElement(linha);
                    linha.setSalto(false);
                    linha = this.getNovaLinha();
                    linha.setTab(40);
                    String string59 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string59, 0, 9));
                    linha.setTexto("Ag\u00eancia: " + Util.formatarConta(recebimento.getIdentificadorDBT().getContaCorrente().getAgencia().getCodigoPrefixoAgencia()));
                    this.linhas.addElement(linha);
                    linha.setSalto(false);
                    linha = this.getNovaLinha();
                    linha.setTab(60);
                    String string60 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string60, 0, 9));
                    linha.setTexto("Conta: " + Util.formatarConta(recebimento.getIdentificadorDBT().getContaCorrente().getnumeroContaCorrente()));
                    this.linhas.addElement(linha);
                    linha.setSalto(true);
                    linha = this.getNovaLinha();
                    String string61 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string61, 0, 9));
                    linha.setTexto("Data..................: " + Util.formatarData(recebimento.getDataRecebimento()));
                    this.linhas.addElement(linha);
                    linha.setSalto(false);
                    linha = this.getNovaLinha();
                    linha.setTab(60);
                    String string62 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string62, 0, 9));
                    linha.setTexto("Valor: " + Util.formatarValor(recebimento.getValorRecebimento(), 2));
                    this.linhas.addElement(linha);
                    linha.setSalto(true);
                    linha = this.getNovaLinha();
                    String string63 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string63, 0, 9));
                    linha.setTexto("Situa\u00e7\u00e3o..............: " + (String)situacaoRecebimentosNaoProc.elementAt(i));
                    this.linhas.addElement(linha);
                    registro = (String)OcorrenciaRecebimentosNaoProc.elementAt(i);
                    if (registro.length() <= 70) {
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string64 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string64, 0, 9));
                        linha.setTexto("Ocorr\u00eancia............: " + registro);
                        this.linhas.addElement(linha);
                        this.linhas.addElement(this.getTraco());
                    } else {
                        intQtd = registro.length() / 70;
                        intPosicao = 0;
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string65 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string65, 0, 9));
                        linha.setTexto("Ocorr\u00eancia............: " + registro.substring(intPosicao, intPosicao + 70));
                        this.linhas.addElement(linha);
                        intPosicao += 70;
                        j = 0;
                        while (j < intQtd - 1) {
                            linha = this.getNovaLinha();
                            linha.setSalto(true);
                            String string66 = linha.getFonte().getName();
                            linha.getFonte();
                            linha.setFonte(new Font(string66, 0, 9));
                            linha.setTexto("                        " + registro.substring(intPosicao, intPosicao + 70));
                            this.linhas.addElement(linha);
                            intPosicao += 70;
                            ++j;
                        }
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string67 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string67, 0, 9));
                        linha.setTexto("                        " + registro.substring(intPosicao, registro.length()));
                        this.linhas.addElement(linha);
                        this.linhas.addElement(this.getTraco());
                    }
                    valorRecOcorr += recebimento.getValorRecebimento();
                    valorTotalRec += recebimento.getValorRecebimento();
                    ++i;
                }
                if (qtdRecOcor > 0) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string68 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string68, 1, 9));
                    linha.setTexto("Quantidade de Registros: " + qtdRecOcor);
                    this.linhas.addElement(linha);
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string69 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string69, 1, 9));
                    linha.setTexto("Valor dos Recebimentos com Ocorr\u00eancia: " + Util.formatarValor(valorRecOcorr, 2));
                    this.linhas.addElement(linha);
                }
            }
            if (imprimirReg) {
                linha = this.getNovaLinha();
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("Nome do Arquivo: " + nomeArq + "  Conv\u00eanio: " + convenio + "  N\u00ba Retorno: " + numeroRet + "  Data Retorno: " + dataRet);
                this.linhas.addElement(linha);
                if (!linha.isNovaPagina()) {
                    linha.setNovaPagina(true);
                }
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string70 = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string70, 1, 9));
                linha.setTexto("Tipo de Registro: REGISTROS DE RETORNO N\u00c3O PROCESSADOS PELO APLICATIVO");
                this.linhas.addElement(linha);
                i = 0;
                while (i < registrosNaoProcessados.size()) {
                    barra.setValor(contRegistros);
                    ++contRegistros;
                    registro = (String)registrosNaoProcessados.elementAt(i);
                    if (registro.length() <= 90) {
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string71 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string71, 0, 9));
                        linha.setTexto(registro);
                        this.linhas.addElement(linha);
                        this.linhas.addElement(this.getTraco());
                    } else {
                        int intQtd2 = registro.length() / 90;
                        int intPosicao2 = 0;
                        int j2 = 0;
                        while (j2 < intQtd2 - 1) {
                            linha = this.getNovaLinha();
                            linha.setSalto(true);
                            String string72 = linha.getFonte().getName();
                            linha.getFonte();
                            linha.setFonte(new Font(string72, 0, 9));
                            linha.setTexto(registro.substring(intPosicao2, intPosicao2 + 90));
                            this.linhas.addElement(linha);
                            intPosicao2 += 90;
                            ++j2;
                        }
                        linha = this.getNovaLinha();
                        linha.setSalto(true);
                        String string73 = linha.getFonte().getName();
                        linha.getFonte();
                        linha.setFonte(new Font(string73, 0, 9));
                        linha.setTexto(registro.substring(intPosicao2, registro.length()));
                        this.linhas.addElement(linha);
                        this.linhas.addElement(this.getTraco());
                    }
                    ++i;
                }
                if (qtdReg > 0) {
                    linha = this.getNovaLinha();
                    linha.setSalto(true);
                    String string74 = linha.getFonte().getName();
                    linha.getFonte();
                    linha.setFonte(new Font(string74, 1, 9));
                    linha.setTexto("Quantidade de Registros: " + qtdReg);
                    this.linhas.addElement(linha);
                }
            }
            if (qtdTotal > 0) {
                this.linhas.addElement(this.getTraco());
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string, 1, 9));
                linha.setTexto("Quantidade Total de Registros: " + qtdTotal);
                this.linhas.addElement(linha);
                linha = this.getNovaLinha();
                linha.setSalto(true);
                String string75 = linha.getFonte().getName();
                linha.getFonte();
                linha.setFonte(new Font(string75, 1, 9));
                linha.setTexto("Valor Total dos Recebimentos: " + Util.formatarValor(valorTotalRec, 2));
                this.linhas.addElement(linha);
            }
            barra.finalizar();
            ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de Retorno");
            ControleImpressao.getControle().setCodigoRelatorio("DBT602");
            ControleImpressao.getControle().imprimirLinhas(this.linhas, "Relat\u00f3rio de Retorno");
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    private void obterCliente(Object[] obj) {
        try {
            if (this.cliente == null) {
                this.cliente = new ClienteDBT();
            }
            this.cliente.getPessoa().setCodigoPessoa((String)obj[0]);
            this.cliente.getIdentificacao().setCodigoIdentificador(null);
            this.cliente.getIdentificacao().setNumeroIdentificador(null);
            this.cliente.setIdentificacaoPropria(new Identificacao());
            this.cliente.getIdentificacaoPropria().setCodigoIdentificador(null);
            this.cliente.getIdentificacaoPropria().setNumeroIdentificador(null);
            ClienteDBTBD.getClienteDBTBD().obter(this.cliente);
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public Vector obterListaClientes(Filtro filtro) throws Throwable {
        return ClienteDBTListaBD.getClienteDBTListaDB().obterListaClientes(filtro);
    }

    private void obterMovimento(Object[] movimento) {
        try {
            RecebimentoDBT recebimento = new RecebimentoDBT();
            recebimento.setNumeroRecebimentoDBT(Integer.parseInt((String)movimento[0]));
            RecebimentoDBTBD.getRecebimentoDBTBD().obter(recebimento);
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void salvarAutorizacoesDebito(Vector vetorClientes) {
        try {
            this.getFramePlugin().setCursor(new Cursor(3));
            IBarraProgresso barra = this.getFramePlugin().obterBarraProgresso();
            barra.setValorMaximo(vetorClientes.size());
            barra.inicializar("Alterando a situa\u00e7\u00e3o das autoriza\u00e7\u00f5es para Impressa. AGUARDE...", vetorClientes.size(), false);
            IdentificadorDBT identificadorDBT = new IdentificadorDBT();
            ClienteDBT clienteDBT = new ClienteDBT();
            int i = 0;
            while (i < vetorClientes.size()) {
                clienteDBT = (ClienteDBT)vetorClientes.elementAt(i);
                identificadorDBT.getIdentificacaoDBT().setNumeroIdentificador(clienteDBT.getStrIDDBTParaListaClientes());
                identificadorDBT.getIdentificacaoDBT().setCodigoIdentificador("DBT" + clienteDBT.getStrNumeroConvenioDBT());
                identificadorDBT.getIdentificacaoDBT().setCodigoPessoaIdentificadorRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
                identificadorDBT.getIdentificacaoDBT().setCodigoPessoaRel(clienteDBT.getPessoa().getCodigoPessoa());
                identificadorDBT.setIndicadorImpressao("1");
                IdentificadorDBTBD.getIdentificadorDBTBD().alterarIndicadorImpressao(identificadorDBT);
                barra.setValor(i);
                ++i;
            }
            barra.finalizar();
            this.getFramePlugin().setCursor(new Cursor(0));
        }
        catch (Throwable t) {
            this.getFramePlugin().setCursor(new Cursor(0));
            this.exibirMensagemErro(t);
        }
    }

    private void setConvenioDBT(ConvenioDBT newConvenioDBT) {
        this.convenioDBT = newConvenioDBT;
    }

    private void setQtdIDAlteradoRemessa(int newQtdIDAlteradoRemessa) {
        this.QtdIDAlteradoRemessa = newQtdIDAlteradoRemessa;
    }

    private void setQtdIDManutencaoRemessa(int newQtdIDManutencaoRemessa) {
        this.QtdIDManutencaoRemessa = newQtdIDManutencaoRemessa;
    }

    private void setQtdRecebimentosRemessa(int newQtdRecebimentosRemessa) {
        this.QtdRecebimentosRemessa = newQtdRecebimentosRemessa;
    }

    private void setQtdTotal(int newQtdTotal) {
        this.QtdTotal = newQtdTotal;
    }

    private void setValorTotal(double newValorTotal) {
        this.valorTotal = newValorTotal;
    }

    private void setVetorIDAlteradoRemessa(Vector newVetorIDAlteradoRemessa) {
        this.vetorIDAlteradoRemessa = newVetorIDAlteradoRemessa;
    }

    private void setVetorIDManutencaoRemessa(Vector newVetorIDManutencaoRemessa) {
        this.vetorIDManutencaoRemessa = newVetorIDManutencaoRemessa;
    }

    private void setVetorParametrosRemessa(Vector newVetorParametrosRemessa) {
        this.vetorParametrosRemessa = newVetorParametrosRemessa;
    }

    public void setVetorRecebimentosManutRem(Vector newVetorRecebimentosManutRem) {
        this.vetorRecebimentosManutRem = newVetorRecebimentosManutRem;
    }

    private void setVetorRecebimentosRemessa(Vector newVetorRecebimentosRemessa) {
        this.vetorRecebimentosRemessa = newVetorRecebimentosRemessa;
    }
}

