/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.recebimentosdeterceiros;

import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.ControleListaSelecao;
import br.com.bb.plugins.controle.infraestrutura.IBarraProgresso;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasEvent;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasListener;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasListenerSimples;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfaceGerenciadorListas;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePlugin;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginCadastro;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginListener;
import br.com.bb.plugins.negocio.comum.Pessoa;
import br.com.bb.plugins.negocio.infraestrutura.Filtro;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ClienteDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ConvenenteDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ConvenioDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.GrupoClienteRecebimento;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.IdentificadorDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.MembroGrupoRecebimentoDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.RecebimentoDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.SituacaoRecebimento;
import br.com.bb.plugins.persistencia.comum.ConexaoBancoDados;
import br.com.bb.plugins.persistencia.comum.PessoaBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ClienteDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ClienteDBTListaBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ContaCorrenteDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ConvenenteDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ConvenioDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.IdentificadorDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.IdentificadorDBTListaBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.MembroGrupoRecebimentoDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.RecebimentoDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.RecebimentoDBTListaBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.SituacaoRecebimentoBD;
import br.com.bb.plugins.utilitarios.Util;
import com.ibm.webrunner.widget.MultiColumnListbox;
import java.awt.Cursor;
import java.sql.SQLException;
import java.util.Vector;

public class ControleMovimento
extends Roteador
implements GerenciadorListasListenerSimples {
    private static ControleMovimento controleMovimento = null;
    private IInterfaceGerenciadorListas interfaceLista = null;
    private static Filtro filtro = null;
    private char indicadorOperacao;
    private RecebimentoDBT recebimento;
    private ConvenenteDBT convenenteDBT;

    private ControleMovimento() {
    }

    public void abrirAlteracaoData(Object[][] linhasMultiColumn) throws Throwable {
        if (linhasMultiColumn.length > 0) {
            IInterfacePluginCadastro ipc = (IInterfacePluginCadastro)this.abrirInterface("MovimentoAlterarData", null);
            ipc.incluir(linhasMultiColumn);
            ipc.exibir();
        } else {
            this.exibirMensagem("Selecione um ou mais recebimentos para altera\u00e7\u00e3o da data");
        }
    }

    public void abrirExclusaoVariosRecebimentos(Object[][] meuObjeto) throws Throwable {
        try {
            this.setIndicadorOperacao('E');
            int qtdLinhasSelecionadas = meuObjeto.length;
            if (qtdLinhasSelecionadas > 1) {
                if (this.exibirMensagemConfirmacao("Exclus\u00e3o dos recebimentos selecionados", "Confirma a exclus\u00e3o dos " + qtdLinhasSelecionadas + " recebimentos selecionados?")) {
                    ConexaoBancoDados.getConexao().setAutoCommit(false);
                    this.getFramePlugin().setCursor(new Cursor(3));
                    IBarraProgresso barraProgresso = this.getFramePlugin().obterBarraProgresso();
                    barraProgresso.inicializar("Excluindo recebimentos. Aguarde...", meuObjeto.length, false);
                    barraProgresso.setValorMaximo(meuObjeto.length);
                    int i = 0;
                    while (i < qtdLinhasSelecionadas) {
                        if (!meuObjeto[i][11].toString().equals("Gerado") && !meuObjeto[i][11].toString().equals("D\u00e9bito Efetuado")) {
                            this.getRecebimento().setNumeroRecebimentoDBT(Integer.parseInt((String)meuObjeto[i][0]));
                            RecebimentoDBTBD.getRecebimentoDBTBD().remover(this.getRecebimento());
                        }
                        barraProgresso.setValor(i + 1);
                        ++i;
                    }
                    this.getFramePlugin().setCursor(new Cursor(0));
                    barraProgresso.finalizar();
                    ConexaoBancoDados.getConexao().commit();
                    ConexaoBancoDados.getConexao().setAutoCommit(true);
                    this.abrirListaMovimento(ControleMovimento.getFiltro());
                }
            } else {
                this.getRecebimento().setNumeroRecebimentoDBT(Integer.parseInt((String)meuObjeto[0][0]));
                this.abrirMovimentoCadastroCliente(meuObjeto[0], 'E');
            }
        }
        catch (SQLException t) {
            this.getFramePlugin().setCursor(new Cursor(0));
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
    }

    public void abrirFiltroMovimento() {
        IInterfacePlugin i = this.abrirInterface("DialogFiltroMovimento", null);
        i.exibir();
    }

    public void abrirListaMovimento(Filtro filtro) {
        try {
            ControleMovimento.filtro = filtro;
            this.convenenteDBT = new ConvenenteDBT();
            this.convenenteDBT.getConvenente().getPessoa().setCodigoPessoa(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            this.obterConvenente(this.convenenteDBT);
            if (filtro.getCampo("Situacao") != null && filtro.getCampo("Situacao").equals("G")) {
                this.getInterfaceLista().setarVisibilidadeColuna(12, false);
            } else {
                this.getInterfaceLista().setarVisibilidadeColuna(12, true);
            }
            if (filtro.getCampo("TipoLista").equals("IDDBT")) {
                this.getInterfaceLista().setarVisibilidadeColuna(1, false);
                this.getInterfaceLista().setarVisibilidadeColuna(3, false);
            } else {
                this.getInterfaceLista().setarVisibilidadeColuna(1, true);
                this.getInterfaceLista().setarVisibilidadeColuna(3, true);
            }
            if (this.convenenteDBT.getCodigoIdentificadorProprio() != null && this.convenenteDBT.getCodigoIdentificadorProprio() != "" && this.convenenteDBT.getCodigoIdentificadorProprio().compareTo("") != 0) {
                this.getInterfaceLista().setCabecalhoColuna(this.convenenteDBT.getCodigoIdentificadorProprio(), 3);
            } else {
                this.getInterfaceLista().setarVisibilidadeColuna(3, false);
            }
            this.getInterfaceLista().listar(RecebimentoDBTListaBD.getRecebimentoDBTListaBD(), RecebimentoDBTListaBD.getRecebimentoDBTListaBD().abrirLista(filtro));
        }
        catch (Throwable e) {
            Util.exibirMensagemErro(e);
        }
        this.getInterfaceLista().exibir();
    }

    public String abrirListaSelecao(Vector clientes, String strTitulo) {
        ControleListaSelecao.getControleListaSelecao().setTituloDialog(strTitulo);
        ControleListaSelecao.getControleListaSelecao().abrirListaSelecao(clientes);
        return ControleListaSelecao.getControleListaSelecao().getCodigoSelecionado();
    }

    public void abrirMovimentoCadastroCliente() {
        try {
            ConvenioDBT convenioDBT = new ConvenioDBT();
            convenioDBT.setCodigoPessoaConvenenteDBT(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            Vector listaConvenio = ConvenioDBTBD.getConvenioDBTBD().obterLista(convenioDBT);
            if (listaConvenio.size() < 1) {
                this.exibirMensagem("N\u00e3o existe conv\u00eanio cadastrado! Favor efetuar o processamento do arquivo de configura\u00e7\u00e3o autom\u00e1tica!");
                return;
            }
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
        IInterfacePluginCadastro ipc = (IInterfacePluginCadastro)this.abrirInterface("MovimentoCadastroCliente", null);
        ipc.incluir(null);
        ipc.exibir();
    }

    public void abrirMovimentoCadastroCliente(Object[] linha, char indicadorOperacao) throws SQLException {
        RecebimentoDBT recebimento = new RecebimentoDBT();
        recebimento.setNumeroRecebimentoDBT(Integer.parseInt((String)linha[0]));
        recebimento.getCliente().getRelacaoPessoaPlugin().getConvenente().getPessoa().setCodigoPessoa(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
        RecebimentoDBTBD.getRecebimentoDBTBD().obter(recebimento);
        if (indicadorOperacao == 'A') {
            if (((String)linha[11]).equals("Gerado") || ((String)linha[11]).equals("D\u00e9bito Efetuado")) {
                this.exibirMensagem("Um recebimento com a Situa\u00e7\u00e3o de GERADO ou D\u00c9BITO EFETUADO n\u00e3o pode ser alterado.");
                return;
            }
            IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("MovimentoCadastroCliente", null);
            interfacePluginCadastro.alterar(recebimento);
            interfacePluginCadastro.exibir();
        } else if (indicadorOperacao == 'E') {
            if (((String)linha[11]).equals("Gerado") || ((String)linha[11]).equals("D\u00e9bito Efetuado")) {
                this.exibirMensagem("Um recebimento com a Situa\u00e7\u00e3o de GERADO ou D\u00c9BITO EFETUADO n\u00e3o pode ser exclu\u00eddo.");
                return;
            }
            IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("MovimentoCadastroCliente", null);
            interfacePluginCadastro.excluir(recebimento);
            interfacePluginCadastro.exibir();
        } else if (indicadorOperacao == 'D') {
            IInterfacePluginCadastro interfacePluginCadastro = (IInterfacePluginCadastro)this.abrirInterface("MovimentoCadastroCliente", null);
            interfacePluginCadastro.detalhar(recebimento);
            interfacePluginCadastro.exibir();
        }
    }

    public void abrirMovimentoCadastroGrupo() {
        try {
            ConvenioDBT convenioDBT = new ConvenioDBT();
            convenioDBT.setCodigoPessoaConvenenteDBT(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            Vector listaConvenio = ConvenioDBTBD.getConvenioDBTBD().obterLista(convenioDBT);
            if (listaConvenio.size() < 1) {
                this.exibirMensagem("N\u00e3o existe conv\u00eanio cadastrado! Favor efetuar o processamento do arquivo de configura\u00e7\u00e3o autom\u00e1tica!");
                return;
            }
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
        this.abrirInterface("MovimentoCadastroGrupo", null).exibir();
    }

    public void abrirMovimentoCadastroRemessa() {
        try {
            ConvenioDBT convenioDBT = new ConvenioDBT();
            convenioDBT.setCodigoPessoaConvenenteDBT(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            Vector listaConvenio = ConvenioDBTBD.getConvenioDBTBD().obterLista(convenioDBT);
            if (listaConvenio.size() < 1) {
                this.exibirMensagem("N\u00e3o existe conv\u00eanio cadastrado! Favor efetuar o processamento do arquivo de configura\u00e7\u00e3o autom\u00e1tica!");
                return;
            }
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
        this.abrirInterface("MovimentoCadastroRemessa", null).exibir();
    }

    public void actionPerformedGerenciadorListas(GerenciadorListasEvent evento, MultiColumnListbox multicolumn) {
        try {
            if (evento.getBotaoComando().equalsIgnoreCase("Incluir")) {
                this.setIndicadorOperacao('I');
                this.abrirMovimentoCadastroCliente();
            } else if (evento.getBotaoComando().equalsIgnoreCase("Filtro...")) {
                this.abrirInterface("DialogFiltroMovimento", null).exibir();
            } else if (evento.getBotaoComando().equalsIgnoreCase("Alterar")) {
                this.setIndicadorOperacao('A');
                this.abrirMovimentoCadastroCliente(evento.getLinhas()[0], 'A');
            } else if (evento.getBotaoComando().equalsIgnoreCase("Excluir")) {
                if (evento.getLinhas().length > 1) {
                    this.abrirExclusaoVariosRecebimentos(evento.getLinhas());
                } else {
                    this.getRecebimento().setNumeroRecebimentoDBT(Integer.parseInt((String)evento.getLinhas()[0][0]));
                    this.abrirMovimentoCadastroCliente(evento.getLinhas()[0], 'E');
                }
            } else if (evento.getBotaoComando().equalsIgnoreCase("Detalhar")) {
                this.setIndicadorOperacao('D');
                this.abrirMovimentoCadastroCliente(evento.getLinhas()[0], 'D');
            } else if (evento.getBotaoComando().equalsIgnoreCase("Imprimir")) {
                if (evento.getSource() == this.getInterfaceLista()) {
                    if (multicolumn.getRowCount() == 0) {
                        this.exibirMensagem("N\u00e3o h\u00e1 Recebimentos para impress\u00e3o do relat\u00f3rio");
                    } else {
                        IInterfacePlugin i = this.abrirInterface("DialogRelatorioMovimento", null);
                        i.popular(multicolumn);
                        i.exibir();
                    }
                }
            } else {
                evento.getBotaoComando().equalsIgnoreCase("Alterar Data");
            }
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void addColuna(String nome, int tamanhoPercentual, int alinhamento, boolean visivel, boolean index) {
    }

    public void addColuna(String nome, int tamanhoPercentual, boolean visivel, boolean index) {
    }

    public void addGerenciadorListasListener(GerenciadorListasListener listener) {
    }

    public void addInterfacePluginListener(IInterfacePluginListener ipl) {
    }

    public void excluirRecebimento(RecebimentoDBT recebimentoDBT) throws Throwable {
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        try {
            RecebimentoDBTBD.getRecebimentoDBTBD().remover(recebimentoDBT);
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            this.getInterfaceLista().excluido(recebimentoDBT);
        }
        catch (SQLException t) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
    }

    public static ControleMovimento getControleMovimento() {
        if (controleMovimento == null) {
            controleMovimento = new ControleMovimento();
        }
        return controleMovimento;
    }

    public static Filtro getFiltro() {
        if (filtro == null) {
            filtro = new Filtro();
        }
        return filtro;
    }

    public char getIndicadorOperacao() {
        return this.indicadorOperacao;
    }

    public IInterfaceGerenciadorListas getInterfaceLista() {
        if (this.interfaceLista == null) {
            this.interfaceLista = (IInterfaceGerenciadorListas)this.abrirInterface("MovimentoManutencao", null);
            this.interfaceLista.addGerenciadorListasListener(this);
            this.interfaceLista.setModal(true);
            this.interfaceLista.setTitulo("Selecione o Recebimento e escolha a a\u00e7\u00e3o desejada.");
            this.interfaceLista.addColuna("N\u00famero do Recebimento", 0, false, false);
            this.interfaceLista.addColuna("Inscri\u00e7\u00e3o", 17, true, true);
            this.interfaceLista.addColuna("Nome", 25, true, true);
            this.interfaceLista.addColuna("(Identificador Pr\u00f3prio)", 25, true, true);
            this.interfaceLista.addColuna("Conv\u00eanio", 12, true, true);
            this.interfaceLista.addColuna("Identifica\u00e7\u00e3o P/D\u00e9bito", 25, true, true);
            this.interfaceLista.addColuna("Banco", 6, false, true);
            this.interfaceLista.addColuna("Ag\u00eancia", 8, 1, false, true);
            this.interfaceLista.addColuna("Conta", 12, 2, false, true);
            this.interfaceLista.addColuna("Data", 10, 1, true, true, 1);
            this.interfaceLista.addColuna("Valor", 12, 2, true, true, 3);
            this.interfaceLista.addColuna("Situa\u00e7\u00e3o", 20, true, true);
            this.interfaceLista.addColuna("Data Remessa", 14, 1, true, true, 1);
            this.interfaceLista.addColuna("N\u00famero Remessa", 16, false, true);
            this.interfaceLista.addColuna("VALOR DESFORMATADO", 0, false, true);
            this.interfaceLista.addColuna("Grupo", 25, true, true);
            this.interfaceLista.setTituloRelatorio("Movimento");
            this.interfaceLista.setTotalizador(14, "Valor Total", 2);
            this.interfaceLista.setLinhasHorizontais(true);
            this.interfaceLista.setLinhasVerticais(true);
            this.interfaceLista.setLayout(4);
        }
        return this.interfaceLista;
    }

    public RecebimentoDBT getRecebimento() {
        if (this.recebimento == null) {
            this.recebimento = new RecebimentoDBT();
        }
        return this.recebimento;
    }

    public void incluirRecebimento(RecebimentoDBT recebimentoDBT) throws Throwable {
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        try {
            RecebimentoDBTBD.getRecebimentoDBTBD().salvar(recebimentoDBT);
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
        }
        catch (SQLException t) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
    }

    public void obterClienteDBT(ClienteDBT clienteDBT) throws SQLException {
        ClienteDBTBD.getClienteDBTBD().obter(clienteDBT);
    }

    public void obterConvenente(ConvenenteDBT convenente) throws SQLException {
        ConvenenteDBTBD.getConvenenteDBTBD().obter(convenente);
    }

    public void obterConvenioDBT(ConvenioDBT convenioDBT) throws SQLException {
        ConvenioDBTBD.getConvenioDBTBD().obter(convenioDBT);
    }

    public void obterGrupoCliente(MembroGrupoRecebimentoDBT membroGrupoRecebimentoDBT) throws SQLException {
        MembroGrupoRecebimentoDBTBD.getMembroGrupoRecebimentoDBTBD().obter(membroGrupoRecebimentoDBT);
    }

    public void obterIDDBT(IdentificadorDBT identificadorDBT) throws SQLException {
        IdentificadorDBTBD.getIdentificadorDBTBD().obter(identificadorDBT);
    }

    public Vector obterListaClientesGrupo(GrupoClienteRecebimento grupoClienteDBT) throws Throwable {
        return IdentificadorDBTListaBD.getIdentificadorDBTListaBD().obterListaPorGrupo(grupoClienteDBT);
    }

    public Vector obterListaConta(RecebimentoDBT recebimentoDBT) throws Throwable {
        return ContaCorrenteDBTBD.getContaCorrenteDBTBD().obterLista(recebimentoDBT);
    }

    public Vector obterListaIDDBT(RecebimentoDBT recebimentoDBT) throws Throwable {
        return IdentificadorDBTListaBD.getIdentificadorDBTListaBD().obterLista(recebimentoDBT);
    }

    public Vector obterListaIDDBTPorAgConta(IdentificadorDBT identificadorDBT) throws Throwable {
        return IdentificadorDBTBD.getIdentificadorDBTBD().obterListaPorAgConta(identificadorDBT);
    }

    public Vector obterListaIDDBTSituacao(IdentificadorDBT identificador, String situacoes) throws Throwable {
        return RecebimentoDBTBD.getRecebimentoDBTBD().obterLista(identificador, situacoes);
    }

    public Vector obterListaIDDBTSituacaoOK(RecebimentoDBT recebimentoDBT) throws Throwable {
        return IdentificadorDBTListaBD.getIdentificadorDBTListaBD().obterListaSituacaoOK(recebimentoDBT);
    }

    public Vector obterListaIdentificadores(Filtro filtro) throws Throwable {
        return IdentificadorDBTBD.getIdentificadorDBTBD().obterListaIdentificadores(filtro);
    }

    public Vector obterListaNomePessoa(RecebimentoDBT recebimentoDBT) throws Throwable {
        return ClienteDBTListaBD.getClienteDBTListaDB().obterListaNomePessoa(recebimentoDBT);
    }

    public Vector obterListaRecebimentosRemessaAnterior(RecebimentoDBT recebimentoDBT) throws Throwable {
        return RecebimentoDBTListaBD.getRecebimentoDBTListaBD().obterListaRecebimentosRemessaAnterior(recebimentoDBT);
    }

    public Vector obterListaSituacaoRecebimento() throws Throwable {
        return SituacaoRecebimentoBD.getSituacaoRecebimentoBD().obterLista();
    }

    public void obterNomeCliente(Pessoa pessoaDBT) throws SQLException {
        PessoaBD.getPessoaBD().obter(pessoaDBT);
    }

    public void obterNomeCliente(ClienteDBT clienteDBT) throws SQLException {
        PessoaBD.getPessoaBD().obter(clienteDBT.getPessoa());
    }

    public void obterRecebimento(RecebimentoDBT recebimentoDBT) throws SQLException {
        RecebimentoDBTBD.getRecebimentoDBTBD().obter(recebimentoDBT);
    }

    public boolean obterRecebimentoDuplicidade(RecebimentoDBT recebimentoDBT) throws SQLException {
        return RecebimentoDBTBD.getRecebimentoDBTBD().localizadoDuplicidade(recebimentoDBT);
    }

    public void obterSituacaoRecebimento(SituacaoRecebimento situacaoRecebimento) throws SQLException {
        SituacaoRecebimentoBD.getSituacaoRecebimentoBD().obter(situacaoRecebimento);
    }

    public void salvarRecebimento(RecebimentoDBT recebimentoDBT, char operacao) throws Throwable {
        ConexaoBancoDados.getConexao().setAutoCommit(false);
        try {
            RecebimentoDBTBD.getRecebimentoDBTBD().salvar(recebimentoDBT);
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            if (operacao == 'I') {
                this.getInterfaceLista().incluido(recebimentoDBT);
                this.getInterfaceLista().selecionar(recebimentoDBT);
            } else {
                this.getInterfaceLista().selecionar(recebimentoDBT);
                this.getInterfaceLista().alterado(recebimentoDBT);
            }
        }
        catch (SQLException t) {
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            throw new SQLException(t.getMessage());
        }
    }

    public void setFiltro(Filtro newFiltro) {
        filtro = newFiltro;
    }

    public void setIndicadorOperacao(char newIndicadorOperacao) {
        this.indicadorOperacao = newIndicadorOperacao;
    }

    public void setLayout(int tipoLayout) {
    }

    public void setTitulo(String titulo) {
    }

    public void setTituloRelatorio(String titulo) {
    }
}

