/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.controle.recebimentosdeterceiros;

import br.com.bb.plugins.controle.impressao.ControleImpressao;
import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.IBarraProgresso;
import br.com.bb.plugins.controle.infraestrutura.Roteador;
import br.com.bb.plugins.controle.recebimentosdeterceiros.ControleConvenente;
import br.com.bb.plugins.controle.recebimentosdeterceiros.ControleMovimento;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasEvent;
import br.com.bb.plugins.interfaces.infraestrutura.GerenciadorListasListenerSimples;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfaceGerenciadorListas;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginCadastro;
import br.com.bb.plugins.interfaces.infraestrutura.IInterfacePluginListener;
import br.com.bb.plugins.interfaces.infraestrutura.InterfacePluginEvent;
import br.com.bb.plugins.negocio.comum.ContaCorrente;
import br.com.bb.plugins.negocio.infraestrutura.ArquivoRemessa;
import br.com.bb.plugins.negocio.infraestrutura.RegistroRemessa;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ClienteDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ConvenioDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.IdentificadorDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.RecebimentoDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.TipoOcorrenciaRecebimentoDBT;
import br.com.bb.plugins.persistencia.comum.ConexaoBancoDados;
import br.com.bb.plugins.persistencia.comum.ContaCorrenteBD;
import br.com.bb.plugins.persistencia.comum.IdentificadorBD;
import br.com.bb.plugins.persistencia.infraestrutura.ArquivoRemessaBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ClienteDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.ConvenioDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.IdentificadorDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.RecebimentoDBTBD;
import br.com.bb.plugins.persistencia.recebimentosdeterceiros.TipoOcorrenciaRecebimentoBD;
import br.com.bb.plugins.utilitarios.MontaLista;
import br.com.bb.plugins.utilitarios.Util;
import com.ibm.webrunner.widget.MultiColumnListbox;
import java.io.File;
import java.util.Date;
import java.util.Vector;

public class ControleRetornoRecebimentosDeTerceiros
extends Roteador
implements GerenciadorListasListenerSimples,
IInterfacePluginListener {
    private static ControleRetornoRecebimentosDeTerceiros controleRetornoRecebimentos;
    private IInterfaceGerenciadorListas interfaceGerenciadorListaRetornoRecebimentos;
    private int contadorOcorrencia = 0;
    private String nomeArquivo = null;
    private MultiColumnListbox multiColumnListbox;
    private Vector listaOcorrenciasRetornoRecebimento;
    private static ArquivoRemessa book;
    private String convenio;
    private RecebimentoDBT recebimentoDBT = null;
    private ContaCorrente contaCorrente = null;
    private String tipoRetorno = null;
    private String ocorrenciasRecebimento;
    private Date dataArquivo;
    private String numeroRetorno;
    private RegistroRemessa reg;
    private IdentificadorDBT identificador = null;
    private ConvenioDBT convenioDBT = null;
    private Vector vetorRelatorioRetorno = null;
    private Vector recebimentos = null;
    private Vector recebimentosNaoProc = null;
    private Vector OcorrenciaRecebimentos = null;
    private Vector OcorrenciaRecebimentosNaoProc = null;
    private Vector situacaoRecebimentos = null;
    private Vector situacaoRecebimentosNaoProc = null;
    private Vector identificadoresCadastrados = null;
    private Vector identificadoresAlterados = null;
    private Vector identificadoresAlteradosNaoProc = null;
    private Vector situacaoIdAlterados = null;
    private Vector situacaoIdAlteradosNaoProc = null;
    private Vector situacaoIdCadastrados = null;
    private Vector registrosNaoProcessados = null;
    private Vector identificacaoArquivoRetorno = null;
    private TipoOcorrenciaRecebimentoDBT tipoOcorrenciaRecebimentoDBT = null;

    static {
        book = null;
    }

    private ControleRetornoRecebimentosDeTerceiros() {
        try {
            book = ArquivoRemessaBD.obterArquivoRemessa("DBT");
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void abrirResumoRetorno(Vector vetorRecebimentosRetorno) {
        try {
            IInterfacePluginCadastro ipc = (IInterfacePluginCadastro)this.abrirInterface("DialogRetornoResumo", null);
            ipc.incluir(vetorRecebimentosRetorno);
            ipc.exibir();
        }
        catch (Throwable t) {
            this.exibirMensagemErro(t);
        }
    }

    public void abrirRetornoRecebimento() {
        this.getInterfaceGerenciadorListaRetornoRecebimentos().limpar();
        this.obterListaArquivos();
        this.getInterfaceGerenciadorListaRetornoRecebimentos().ordenar(2);
        this.getInterfaceGerenciadorListaRetornoRecebimentos().setLinhasHorizontais(true);
        this.getInterfaceGerenciadorListaRetornoRecebimentos().setLinhasVerticais(true);
        this.getInterfaceGerenciadorListaRetornoRecebimentos().exibir();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void actionPerformedGerenciadorListas(GerenciadorListasEvent evento, MultiColumnListbox multicolumn) {
        if (!evento.getBotaoComando().equalsIgnoreCase("OK")) {
            if (!evento.getBotaoComando().equalsIgnoreCase("Imprimir")) return;
            ControleImpressao.getControle().setCodigoRelatorio("DBT601");
            ControleImpressao.getControle().setTituloVisualizacao("Relat\u00f3rio de Retornos para Processamento");
            ControleImpressao.getControle().imprimir(multicolumn, "Relat\u00f3rio de Retornos para Processamento");
            return;
        }
        if (evento.getSource() != this.interfaceGerenciadorListaRetornoRecebimentos) return;
        if (evento.getLinhas().length == 0) {
            this.exibirMensagem("Selecione o(s) retorno(s) a processar.");
            evento.setConsumido(true);
            return;
        }
        this.multiColumnListbox = multicolumn;
        int n = multicolumn.getColumnInfo(2).getSorter().getSortOrder();
        multicolumn.getColumnInfo(2).getSorter();
        if (n == 1) {
            this.exibirMensagem("Para processamento mantenha a coluna N\u00famero em ordem crescente.");
            evento.setConsumido(true);
            return;
        }
        if (evento.getLinhas()[evento.getLinhas().length - 1][2].equals(multicolumn.getRow(evento.getLinhas().length - 1)[2])) {
            int n2 = multicolumn.getColumnInfo(2).getSorter().getSortOrder();
            multicolumn.getColumnInfo(2).getSorter();
            if (n2 != 1) {
                this.contadorOcorrencia = 0;
                this.processarRetornos();
                evento.setConsumido(true);
                return;
            }
        }
        this.exibirMensagem("O processamento deve obedecer a ordem do N\u00famero do Retorno.");
        evento.setConsumido(true);
    }

    public void exibirInterfacePlugin(InterfacePluginEvent ipe) {
    }

    public void fecharInterfacePlugin(InterfacePluginEvent ipe) {
    }

    public static ControleRetornoRecebimentosDeTerceiros getControleRetornoRecebimento() {
        if (controleRetornoRecebimentos == null) {
            controleRetornoRecebimentos = new ControleRetornoRecebimentosDeTerceiros();
        }
        return controleRetornoRecebimentos;
    }

    public IInterfaceGerenciadorListas getInterfaceGerenciadorListaRetornoRecebimentos() {
        if (this.interfaceGerenciadorListaRetornoRecebimentos == null) {
            this.interfaceGerenciadorListaRetornoRecebimentos = (IInterfaceGerenciadorListas)this.abrirInterface("RetornoRecebimentos", null);
            this.interfaceGerenciadorListaRetornoRecebimentos.addGerenciadorListasListener(this);
            this.interfaceGerenciadorListaRetornoRecebimentos.setModal(true);
            this.interfaceGerenciadorListaRetornoRecebimentos.setTitulo("Processamento do retorno de D\u00e9bito Autom\u00e1tico");
            this.interfaceGerenciadorListaRetornoRecebimentos.addColuna("Nome do arquivo", 30, 0, true, false);
            this.interfaceGerenciadorListaRetornoRecebimentos.addColuna("Nr conv\u00eanio", 21, 1, true, true);
            this.interfaceGerenciadorListaRetornoRecebimentos.addColuna("Nr retorno", 21, 2, true, true);
            this.interfaceGerenciadorListaRetornoRecebimentos.addColuna("Data retorno", 21, 1, true, true, 1);
            this.interfaceGerenciadorListaRetornoRecebimentos.setLayout(3);
        }
        return this.interfaceGerenciadorListaRetornoRecebimentos;
    }

    public Vector getRegistrosNaoProcessados() {
        return this.registrosNaoProcessados;
    }

    private String getTipoRetorno() {
        if (this.tipoRetorno == null) {
            this.tipoRetorno = new String();
        }
        return this.tipoRetorno;
    }

    public void obterListaArquivos() {
        block11: {
            File diretorioRetorno = new File(ControleAplicacao.getDiretorioRetorno());
            if (!diretorioRetorno.exists()) {
                this.exibirMensagem("Diret\u00f3rio de retorno: '" + ControleAplicacao.getDiretorioRetorno() + "' n\u00e3o localizado.");
            } else {
                try {
                    Object[] linha = new String[4];
                    String numeroConvenio = " ";
                    String dataGeracao = " ";
                    String nrRetorno = " ";
                    Vector convenios = null;
                    ConvenioDBT convenioRecebimento = new ConvenioDBT();
                    convenioRecebimento.setCodigoPessoaConvenenteDBT(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
                    convenios = ConvenioDBTBD.getConvenioDBTBD().obterLista(convenioRecebimento);
                    if (convenios.size() <= 0) break block11;
                    MontaLista montaLista = new MontaLista();
                    Vector vlistaArquivos = montaLista.listaFormatadaArquivo(diretorioRetorno.toString());
                    int i = 0;
                    while (i < vlistaArquivos.size()) {
                        try {
                            File f = new File(String.valueOf(diretorioRetorno.toString().endsWith(System.getProperty("file.separator")) ? diretorioRetorno.toString() : String.valueOf(diretorioRetorno.toString()) + System.getProperty("file.separator")) + vlistaArquivos.elementAt(i).toString().trim());
                            if (!f.isDirectory()) {
                                book.abrirArquivoEntrada(f);
                                RegistroRemessa reg = book.lerRegistro();
                                if (reg != null && reg.getValorInt("CodRemessa") == 2) {
                                    int j = 0;
                                    while (j < convenios.size()) {
                                        if (reg.getValorString("Convenio").substring(0, 5).equalsIgnoreCase(((ConvenioDBT)convenios.elementAt(j)).getNumeroConvenioDBT())) {
                                            numeroConvenio = reg.getValorString("Convenio").substring(0, 5);
                                            dataGeracao = Util.formatarData(reg.getValorData("DataArq"));
                                            nrRetorno = String.valueOf(reg.getValorInt("SequencialArq"));
                                            linha[0] = vlistaArquivos.elementAt(i).toString().trim();
                                            linha[1] = numeroConvenio;
                                            linha[2] = nrRetorno;
                                            linha[3] = dataGeracao;
                                            this.getInterfaceGerenciadorListaRetornoRecebimentos().addLinha(linha);
                                            break;
                                        }
                                        ++j;
                                    }
                                }
                                book.fecharArquivoEntrada();
                            }
                        }
                        catch (Throwable t) {
                            book.fecharArquivoEntrada();
                        }
                        ++i;
                    }
                }
                catch (Throwable t) {
                    this.exibirMensagemErro(t);
                }
            }
        }
    }

    public void ocultarInterfacePlugin(InterfacePluginEvent ipe) {
    }

    private void processarRetornoB(long registro) throws Throwable {
        try {
            int codMovimento = this.reg.getValorInt("CodMovimento");
            String numeroIdentificador = this.reg.getValorString("IdDbt");
            String agencia = String.valueOf(this.reg.getValorString("NumAgencia")) + Util.calculaDigitoMod11(this.reg.getValorString("NumAgencia"));
            String conta = Util.padR(String.valueOf(this.reg.getValorString("NumConta").trim()) + Util.calculaDigitoMod11(this.reg.getValorString("NumConta").trim()), 14, "0").substring(4);
            if (this.convenioDBT.getIdentificadorDBT().getIndicadorDominio().equals("N")) {
                if (numeroIdentificador.trim().equals("") || Double.valueOf(numeroIdentificador.trim()) <= 0.0) {
                    if (codMovimento == 1) {
                        this.registrosNaoProcessados.addElement("Reg. N\u00ba" + registro + " - Tipo B (Exclus\u00e3o de identifica\u00e7\u00e3o P/d\u00e9bito no BB) - Registro com identifica\u00e7\u00e3o para d\u00e9bito Inv\u00e1lida(Zeros ou Brancos) para exclus\u00e3o no aplicativo.");
                        return;
                    }
                    this.registrosNaoProcessados.addElement("Reg. N\u00ba" + registro + " - Tipo B (Inclus\u00e3o de identifica\u00e7\u00e3o P/d\u00e9bito no BB) - Registro com identifica\u00e7\u00e3o para d\u00e9bito Inv\u00e1lida(Zeros ou Brancos) para inclus\u00e3o no aplicativo.");
                    return;
                }
            } else if (numeroIdentificador.trim().equals("")) {
                if (codMovimento == 1) {
                    this.registrosNaoProcessados.addElement("Reg. N\u00ba" + registro + " - Tipo B (Exclus\u00e3o de identifica\u00e7\u00e3o P/d\u00e9bito no BB) - Registro com identifica\u00e7\u00e3o para d\u00e9bito Inv\u00e1lida(Zeros ou Brancos) para exclus\u00e3o no aplicativo.");
                    return;
                }
                this.registrosNaoProcessados.addElement("Reg. N\u00ba" + registro + " - Tipo B (Inclus\u00e3o de identifica\u00e7\u00e3o P/d\u00e9bito no BB) - Registro com identifica\u00e7\u00e3o para d\u00e9bito Inv\u00e1lida(Zeros ou Brancos) para inclus\u00e3o no aplicativo.");
                return;
            }
            this.identificador = new IdentificadorDBT();
            this.identificador.getIdentificacaoDBT().setNumeroIdentificador(numeroIdentificador);
            this.identificador.getIdentificacaoDBT().setCodigoPessoaIdentificadorRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            this.identificador.getIdentificacaoDBT().setCodigoIdentificador("DBT" + this.convenio);
            this.identificador.getIdentificacaoDBT().getIdentificador().setCodigoIdentificador("DBT" + this.convenio);
            this.identificador.getIdentificacaoDBT().getIdentificador().setCodigoPessoaRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            IdentificadorBD.getIdentificadorBD().obter(this.identificador.getIdentificacaoDBT().getIdentificador());
            this.identificador.getConvenioDBT().setNumeroConvenioDBT(this.convenio);
            this.identificador.getContaCorrente().setcodigoPrefixoAgenciaRel(agencia);
            this.identificador.getContaCorrente().setnumeroContaCorrente(conta);
            if (codMovimento == 1) {
                if (IdentificadorDBTBD.getIdentificadorDBTBD().localizado(this.identificador)) {
                    if (ControleMovimento.getControleMovimento().obterListaIDDBTSituacao(this.identificador, "GR").size() > 0) {
                        IdentificadorDBTBD.getIdentificadorDBTBD().obter(this.identificador);
                        this.identificador.setCodigoSituacaoIdentificador("I");
                        IdentificadorDBTBD.getIdentificadorDBTBD().alterar(this.identificador);
                        this.identificador.setTextoDescricaoOcorrencia("A Identifica\u00e7\u00e3o para D\u00e9bito ser\u00e1 Desativada no Aplicativo, pois existem recebimentos gravados ou gerados vinculados.");
                    } else {
                        IdentificadorDBTBD.getIdentificadorDBTBD().obter(this.identificador);
                        this.identificador.setTextoDescricaoOcorrencia("Identifica\u00e7\u00e3o para d\u00e9bito Exclu\u00edda no Aplicativo.");
                        IdentificadorDBTBD.getIdentificadorDBTBD().remover(this.identificador);
                    }
                } else {
                    this.identificador.setTextoDescricaoOcorrencia("Identifica\u00e7\u00e3o para D\u00e9bito n\u00e3o localizada no Aplicativo");
                }
                this.situacaoIdCadastrados.addElement("Exclu\u00eddo no BB");
                this.identificadoresCadastrados.addElement(this.identificador);
            }
            if (codMovimento == 2) {
                if (IdentificadorDBTBD.getIdentificadorDBTBD().localizado(this.identificador)) {
                    IdentificadorDBTBD.getIdentificadorDBTBD().obter(this.identificador);
                    this.identificador.setCodigoSituacaoIdentificador("A");
                    this.identificador.getContaCorrente().setcodigoPrefixoAgenciaRel(agencia);
                    this.identificador.getContaCorrente().setnumeroContaCorrente(conta);
                    IdentificadorDBTBD.getIdentificadorDBTBD().alterar(this.identificador);
                    this.identificador.setTextoDescricaoOcorrencia("Identifica\u00e7\u00e3o para d\u00e9bito Alterada com sucesso no Aplicativo.");
                    this.situacaoIdAlterados.addElement("Alterado no BB");
                    this.identificadoresAlterados.addElement(this.identificador);
                    IdentificadorDBT identificadorAntigo = new IdentificadorDBT();
                    identificadorAntigo.getIdentificacaoDBT().setNumeroIdentificador(this.identificador.getNumeroIdentificadorAntigo());
                    identificadorAntigo.getIdentificacaoDBT().setCodigoPessoaIdentificadorRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
                    identificadorAntigo.getIdentificacaoDBT().setCodigoIdentificador("DBT" + this.convenio);
                    identificadorAntigo.getIdentificacaoDBT().getIdentificador().setCodigoIdentificador("DBT" + this.convenio);
                    identificadorAntigo.getIdentificacaoDBT().getIdentificador().setCodigoPessoaRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
                    if (IdentificadorDBTBD.getIdentificadorDBTBD().localizado(identificadorAntigo)) {
                        IdentificadorDBTBD.getIdentificadorDBTBD().obter(identificadorAntigo);
                        identificadorAntigo.setCodigoSituacaoIdentificador("I");
                        IdentificadorDBTBD.getIdentificadorDBTBD().alterar(identificadorAntigo);
                    }
                } else {
                    ClienteDBT cliente = new ClienteDBT();
                    cliente.getPessoa().setNomePessoa("CADASTRADO PELO BB");
                    cliente.getPessoa().setCodigoUFRel("DF");
                    cliente.getPessoa().getTipoPessoa().setCodigoTipoPessoa(0);
                    cliente.getRelacaoPessoaPlugin().setConvenente(ControleAplicacao.getConvenente());
                    ClienteDBTBD.getClienteDBTBD().salvar(cliente);
                    this.contaCorrente = new ContaCorrente();
                    this.contaCorrente.getPessoa().setCodigoPessoa(cliente.getPessoa().getCodigoPessoa());
                    this.contaCorrente.getAgencia().setCodigoPessoaBanco("0000001");
                    this.contaCorrente.setcodigoPrefixoAgenciaRel(agencia);
                    this.contaCorrente.setnumeroContaCorrente(conta);
                    ContaCorrenteBD.getContaCorrenteBD().adicionar(this.contaCorrente);
                    this.identificador.setContaCorrente(this.contaCorrente);
                    this.identificador.getIdentificacaoDBT().setCodigoPessoaRel(cliente.getPessoa().getCodigoPessoa());
                    this.identificador.setCodigoSituacaoIdentificador("A");
                    this.identificador.getIdentificacaoDBT().setDataEmissao(new Date());
                    IdentificadorDBTBD.getIdentificadorDBTBD().adicionar(this.identificador);
                    this.situacaoIdCadastrados.addElement("Inclu\u00eddo no BB");
                    this.identificador.setTextoDescricaoOcorrencia("Identifica\u00e7\u00e3o para d\u00e9bito inclu\u00edda com sucesso no Aplicativo.");
                    this.identificadoresCadastrados.addElement(this.identificador);
                }
            }
        }
        catch (Throwable t) {
            this.registrosNaoProcessados.addElement("Reg. N\u00ba" + registro + " - Dados P/Suporte (" + t.toString() + ")");
        }
    }

    private void processarRetornoF(long registro) throws Throwable {
        try {
            this.recebimentoDBT = new RecebimentoDBT();
            this.tipoOcorrenciaRecebimentoDBT = new TipoOcorrenciaRecebimentoDBT();
            this.tipoOcorrenciaRecebimentoDBT.setCodigoRetorno(this.reg.getValorString("CodRet"));
            TipoOcorrenciaRecebimentoBD.getTipoOcorrenciaRecebimentoBD().obter(this.tipoOcorrenciaRecebimentoDBT);
            int tamanhoIDRecebimento = this.reg.getValorString("IdRecebimento").trim().length();
            if (tamanhoIDRecebimento > 0) {
                int posicaoIniNumRec = tamanhoIDRecebimento - 7;
                String numeroRecebimento = this.reg.getValorString("IdRecebimento").substring(posicaoIniNumRec, tamanhoIDRecebimento);
                String idRecebimento = this.reg.getValorString("IdRecebimento").substring(0, tamanhoIDRecebimento);
                this.recebimentoDBT.setNumeroRecebimentoDBT(Integer.parseInt(numeroRecebimento));
                this.recebimentoDBT.setIdRegistro(idRecebimento);
            } else {
                this.recebimentoDBT.setIdRegistro(" ");
                this.recebimentoDBT.setNumeroRecebimentoDBT(0);
            }
            double valorRecebimento = this.reg.getValorDouble("ValorDBT");
            Date dataRecebimento = this.reg.getValorData("DataOpcao");
            int codigoRetorno = Integer.parseInt(this.reg.getValorString("CodRet"));
            String numeroIdentificador = this.reg.getValorString("IdDbt");
            String agencia = String.valueOf(this.reg.getValorString("NumAgencia")) + Util.calculaDigitoMod11(this.reg.getValorString("NumAgencia"));
            String conta = Util.padR(String.valueOf(this.reg.getValorString("NumConta").trim()) + Util.calculaDigitoMod11(this.reg.getValorString("NumConta").trim()), 14, "0").substring(4);
            this.identificador = new IdentificadorDBT();
            this.identificador.getIdentificacaoDBT().setNumeroIdentificador(numeroIdentificador);
            this.identificador.getIdentificacaoDBT().setCodigoPessoaIdentificadorRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            this.identificador.getIdentificacaoDBT().setCodigoIdentificador("DBT" + this.convenio);
            this.identificador.getIdentificacaoDBT().getIdentificador().setCodigoIdentificador("DBT" + this.convenio);
            this.identificador.getIdentificacaoDBT().getIdentificador().setCodigoPessoaRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            IdentificadorBD.getIdentificadorBD().obter(this.identificador.getIdentificacaoDBT().getIdentificador());
            this.identificador.getConvenioDBT().setNumeroConvenioDBT(this.convenio);
            this.identificador.getContaCorrente().setcodigoPrefixoAgenciaRel(agencia);
            this.identificador.getContaCorrente().setnumeroContaCorrente(conta);
            this.recebimentoDBT.setIdentificadorDBT(this.identificador);
            if (RecebimentoDBTBD.getRecebimentoDBTBD().localizado(this.recebimentoDBT)) {
                RecebimentoDBTBD.getRecebimentoDBTBD().obter(this.recebimentoDBT);
                this.recebimentoDBT.setTipoOcorrenciaRecebimentoDBT(this.tipoOcorrenciaRecebimentoDBT);
                if (codigoRetorno >= 0 && codigoRetorno <= 31) {
                    if (codigoRetorno == 0 || codigoRetorno == 31) {
                        this.recebimentoDBT.getSituacaoRecebimento().setCodigoSituacaoRecebimento("D");
                        this.recebimentoDBT.setCodigoSituacaoRecebimentoRel("D");
                        this.recebimentoDBT.setCodigoPrefixoAgenciaLiquidacao(agencia);
                        this.recebimentoDBT.setNumeroContaCorrenteLiquidacao(conta);
                        this.recebimentoDBT.setCodigoBancoLiquidacao("001");
                        this.recebimentoDBT.setDataDebitoEfetuado(dataRecebimento);
                        this.recebimentoDBT.setValorDebitoEfetuado(valorRecebimento);
                        this.situacaoRecebimentos.addElement(this.tipoOcorrenciaRecebimentoDBT.getTextoDescricao());
                        this.OcorrenciaRecebimentos.addElement("Registro importado com sucesso");
                        this.recebimentos.addElement(this.recebimentoDBT);
                    } else {
                        this.recebimentoDBT.getSituacaoRecebimento().setCodigoSituacaoRecebimento("O");
                        this.recebimentoDBT.setCodigoSituacaoRecebimentoRel("O");
                        this.situacaoRecebimentosNaoProc.addElement("D\u00e9bito n\u00e3o efetuado - " + this.tipoOcorrenciaRecebimentoDBT.getTextoDescricao());
                        this.OcorrenciaRecebimentosNaoProc.addElement("Registro importado com sucesso");
                        this.recebimentosNaoProc.addElement(this.recebimentoDBT);
                    }
                    RecebimentoDBTBD.getRecebimentoDBTBD().alterar(this.recebimentoDBT);
                }
                if (codigoRetorno == 96) {
                    this.recebimentoDBT.getSituacaoRecebimento().setCodigoSituacaoRecebimento("D");
                    this.recebimentoDBT.setCodigoSituacaoRecebimentoRel("D");
                    this.recebimentoDBT.setCodigoPrefixoAgenciaLiquidacao(agencia);
                    this.recebimentoDBT.setNumeroContaCorrenteLiquidacao(conta);
                    this.recebimentoDBT.setCodigoBancoLiquidacao("001");
                    this.recebimentoDBT.setDataDebitoEfetuado(dataRecebimento);
                    this.recebimentoDBT.setValorDebitoEfetuado(valorRecebimento);
                    this.situacaoRecebimentos.addElement("Manuten\u00e7\u00e3o do cadastro - Recebimento foi exclu\u00eddo do Aplicativo.");
                    this.OcorrenciaRecebimentos.addElement("Registro processado com sucesso");
                    this.recebimentos.addElement(this.recebimentoDBT);
                    RecebimentoDBTBD.getRecebimentoDBTBD().remover(this.recebimentoDBT);
                }
                if (codigoRetorno >= 97 && codigoRetorno <= 99) {
                    this.recebimentoDBT.getSituacaoRecebimento().setCodigoSituacaoRecebimento("O");
                    this.recebimentoDBT.setCodigoSituacaoRecebimentoRel("O");
                    this.recebimentoDBT.setCodigoPrefixoAgenciaLiquidacao(agencia);
                    this.recebimentoDBT.setNumeroContaCorrenteLiquidacao(conta);
                    this.recebimentoDBT.setCodigoBancoLiquidacao("001");
                    this.recebimentoDBT.setDataDebitoEfetuado(dataRecebimento);
                    this.recebimentoDBT.setValorDebitoEfetuado(valorRecebimento);
                    this.situacaoRecebimentosNaoProc.addElement("Cancelamento de Recebimento - " + this.tipoOcorrenciaRecebimentoDBT.getTextoDescricao());
                    this.OcorrenciaRecebimentosNaoProc.addElement("Registro importado com sucesso");
                    this.recebimentosNaoProc.addElement(this.recebimentoDBT);
                }
            } else {
                this.recebimentoDBT.setTipoOcorrenciaRecebimentoDBT(this.tipoOcorrenciaRecebimentoDBT);
                this.recebimentoDBT.setDataRecebimento(dataRecebimento);
                this.recebimentoDBT.setValorRecebimento(valorRecebimento);
                if (codigoRetorno >= 0 && codigoRetorno <= 31) {
                    if (codigoRetorno == 0 || codigoRetorno == 31) {
                        this.recebimentoDBT.getSituacaoRecebimento().setCodigoSituacaoRecebimento("D");
                        this.recebimentoDBT.setCodigoSituacaoRecebimentoRel("D");
                        this.recebimentoDBT.setCodigoPrefixoAgenciaLiquidacao(agencia);
                        this.recebimentoDBT.setNumeroContaCorrenteLiquidacao(conta);
                        this.recebimentoDBT.setCodigoBancoLiquidacao("001");
                        this.recebimentoDBT.setDataDebitoEfetuado(dataRecebimento);
                        this.recebimentoDBT.setValorDebitoEfetuado(valorRecebimento);
                        this.situacaoRecebimentos.addElement(this.tipoOcorrenciaRecebimentoDBT.getTextoDescricao());
                        this.OcorrenciaRecebimentos.addElement("Recebimento n\u00e3o localizado no Aplicativo, registro n\u00e3o importado");
                        this.recebimentos.addElement(this.recebimentoDBT);
                    } else {
                        this.recebimentoDBT.getSituacaoRecebimento().setCodigoSituacaoRecebimento("O");
                        this.recebimentoDBT.setCodigoSituacaoRecebimentoRel("O");
                        this.situacaoRecebimentosNaoProc.addElement("D\u00e9bito n\u00e3o efetuado - " + this.tipoOcorrenciaRecebimentoDBT.getTextoDescricao());
                        this.OcorrenciaRecebimentosNaoProc.addElement("Recebimento n\u00e3o localizado no Aplicativo, registro n\u00e3o importado");
                        this.recebimentosNaoProc.addElement(this.recebimentoDBT);
                    }
                }
                if (codigoRetorno == 96) {
                    this.recebimentoDBT.setCodigoPrefixoAgenciaLiquidacao(agencia);
                    this.recebimentoDBT.setNumeroContaCorrenteLiquidacao(conta);
                    this.recebimentoDBT.setCodigoBancoLiquidacao("001");
                    this.recebimentoDBT.setDataDebitoEfetuado(dataRecebimento);
                    this.recebimentoDBT.setValorDebitoEfetuado(valorRecebimento);
                    this.situacaoRecebimentos.addElement("Manuten\u00e7\u00e3o do cadastro");
                    this.OcorrenciaRecebimentos.addElement("Recebimento n\u00e3o localizado no Aplicativo");
                    this.recebimentos.addElement(this.recebimentoDBT);
                }
                if (codigoRetorno >= 97 && codigoRetorno <= 99) {
                    this.recebimentoDBT.setCodigoPrefixoAgenciaLiquidacao(agencia);
                    this.recebimentoDBT.setNumeroContaCorrenteLiquidacao(conta);
                    this.recebimentoDBT.setCodigoBancoLiquidacao("001");
                    this.recebimentoDBT.setDataDebitoEfetuado(dataRecebimento);
                    this.recebimentoDBT.setValorDebitoEfetuado(valorRecebimento);
                    this.situacaoRecebimentosNaoProc.addElement("Cancelamento de Recebimento - " + this.tipoOcorrenciaRecebimentoDBT.getTextoDescricao());
                    this.OcorrenciaRecebimentosNaoProc.addElement("Recebimento n\u00e3o localizado no Aplicativo");
                    this.recebimentosNaoProc.addElement(this.recebimentoDBT);
                }
            }
        }
        catch (Throwable t) {
            this.registrosNaoProcessados.addElement("Reg. N\u00ba" + registro + " - Dados P/Suporte (" + t.toString() + ")");
        }
    }

    private void processarRetornoH(long registro) throws Throwable {
        try {
            int codMovimento = this.reg.getValorInt("CodMovimento");
            String numeroIdentificadorAtual = this.reg.getValorString("IdDbtAtual");
            String numeroIdentificadorAntigo = this.reg.getValorString("IdDbtAnt");
            String agencia = String.valueOf(this.reg.getValorString("NumAgencia")) + Util.calculaDigitoMod11(this.reg.getValorString("NumAgencia"));
            String conta = Util.padR(String.valueOf(this.reg.getValorString("NumConta").trim()) + Util.calculaDigitoMod11(this.reg.getValorString("NumConta").trim()), 14, "0").substring(4);
            if (this.convenioDBT.getIdentificadorDBT().getIndicadorDominio().equals("N")) {
                if (numeroIdentificadorAtual.trim().equals("") || Double.valueOf(numeroIdentificadorAtual) <= 0.0) {
                    if (codMovimento == 1) {
                        this.registrosNaoProcessados.addElement("Reg. N\u00ba" + registro + " - Tipo H (Ocorr\u00eancia na Exclus\u00e3o de identifica\u00e7\u00e3o P/d\u00e9bito no BB) - Registro com identifica\u00e7\u00e3o para d\u00e9bito Inv\u00e1lida(Zeros ou Brancos) para importa\u00e7\u00e3o no aplicativo.");
                        return;
                    }
                    this.registrosNaoProcessados.addElement("Reg. N\u00ba" + registro + " - Tipo H (Ocorr\u00eancia na Altera\u00e7\u00e3o de identifica\u00e7\u00e3o P/d\u00e9bito no BB) - Registro com identifica\u00e7\u00e3o para d\u00e9bito Inv\u00e1lida(Zeros ou Brancos) para importa\u00e7\u00e3o no aplicativo.");
                    return;
                }
            } else if (numeroIdentificadorAtual.trim().equals("")) {
                if (codMovimento == 1) {
                    this.registrosNaoProcessados.addElement("Reg. N\u00ba" + registro + " - Tipo H (Ocorr\u00eancia na Exclus\u00e3o de identifica\u00e7\u00e3o P/d\u00e9bito no BB) - Registro com identifica\u00e7\u00e3o para d\u00e9bito Inv\u00e1lida(Zeros ou Brancos) para importa\u00e7\u00e3o no aplicativo.");
                    return;
                }
                this.registrosNaoProcessados.addElement("Reg. N\u00ba" + registro + " - Tipo H (Ocorr\u00eancia na Altera\u00e7\u00e3o de identifica\u00e7\u00e3o P/d\u00e9bito no BB) - Registro com identifica\u00e7\u00e3o para d\u00e9bito Inv\u00e1lida(Zeros ou Brancos) para importa\u00e7\u00e3o no aplicativo.");
                return;
            }
            if (this.convenioDBT.getIdentificadorDBT().getIndicadorDominio().equals("N")) {
                if (!numeroIdentificadorAntigo.trim().equals("AGUARDANDO EXCLUSAO NO BB") && (numeroIdentificadorAntigo.trim().equals("") || Double.valueOf(numeroIdentificadorAntigo) <= 0.0)) {
                    if (codMovimento == 1) {
                        this.registrosNaoProcessados.addElement("Reg. N\u00ba" + registro + " - Tipo H (Ocorr\u00eancia na Exclus\u00e3o de identifica\u00e7\u00e3o P/d\u00e9bito no BB) - Registro com identifica\u00e7\u00e3o para d\u00e9bito Inv\u00e1lida(Zeros ou Brancos) para importa\u00e7\u00e3o no aplicativo.");
                        return;
                    }
                    this.registrosNaoProcessados.addElement("Reg. N\u00ba" + registro + " - Tipo H (Ocorr\u00eancia na Altera\u00e7\u00e3o de identifica\u00e7\u00e3o P/d\u00e9bito no BB) - Registro com identifica\u00e7\u00e3o para d\u00e9bito Inv\u00e1lida(Zeros ou Brancos) para importa\u00e7\u00e3o no aplicativo.");
                    return;
                }
            } else if (numeroIdentificadorAntigo.trim().equals("")) {
                if (codMovimento == 1) {
                    this.registrosNaoProcessados.addElement("Reg. N\u00ba" + registro + " - Tipo H (Ocorr\u00eancia na Exclus\u00e3o de identifica\u00e7\u00e3o P/d\u00e9bito no BB) - Registro com identifica\u00e7\u00e3o para d\u00e9bito Inv\u00e1lida(Zeros ou Brancos) para importa\u00e7\u00e3o no aplicativo.");
                    return;
                }
                this.registrosNaoProcessados.addElement("Reg. N\u00ba" + registro + " - Tipo H (Ocorr\u00eancia na Altera\u00e7\u00e3o de identifica\u00e7\u00e3o P/d\u00e9bito no BB) - Registro com identifica\u00e7\u00e3o para d\u00e9bito Inv\u00e1lida(Zeros ou Brancos) para importa\u00e7\u00e3o no aplicativo.");
                return;
            }
            this.identificador = new IdentificadorDBT();
            this.identificador.getIdentificacaoDBT().setNumeroIdentificador(numeroIdentificadorAtual);
            this.identificador.setNumeroIdentificadorAntigo(numeroIdentificadorAntigo);
            this.identificador.getIdentificacaoDBT().setCodigoPessoaIdentificadorRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            this.identificador.getIdentificacaoDBT().setCodigoIdentificador("DBT" + this.convenio);
            this.identificador.getIdentificacaoDBT().getIdentificador().setCodigoIdentificador("DBT" + this.convenio);
            this.identificador.getIdentificacaoDBT().getIdentificador().setCodigoPessoaRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            IdentificadorBD.getIdentificadorBD().obter(this.identificador.getIdentificacaoDBT().getIdentificador());
            this.identificador.getContaCorrente().setcodigoPrefixoAgenciaRel(agencia);
            this.identificador.getContaCorrente().setCodigoBancoRel("001");
            this.identificador.getContaCorrente().setCodigoPessoaBancoRel("0000001");
            this.identificador.getContaCorrente().setnumeroContaCorrente(conta);
            IdentificadorDBT identificadorAntigo = new IdentificadorDBT();
            identificadorAntigo.getIdentificacaoDBT().setNumeroIdentificador(numeroIdentificadorAntigo);
            identificadorAntigo.getIdentificacaoDBT().setCodigoPessoaIdentificadorRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            identificadorAntigo.getIdentificacaoDBT().setCodigoIdentificador("DBT" + this.convenio);
            identificadorAntigo.getIdentificacaoDBT().getIdentificador().setCodigoIdentificador("DBT" + this.convenio);
            identificadorAntigo.getIdentificacaoDBT().getIdentificador().setCodigoPessoaRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            IdentificadorBD.getIdentificadorBD().obter(identificadorAntigo.getIdentificacaoDBT().getIdentificador());
            if (IdentificadorDBTBD.getIdentificadorDBTBD().localizado(this.identificador)) {
                IdentificadorDBTBD.getIdentificadorDBTBD().obter(this.identificador);
                this.identificador.getContaCorrente().setcodigoPrefixoAgenciaRel(agencia);
                this.identificador.getContaCorrente().setCodigoBancoRel("001");
                this.identificador.getContaCorrente().setCodigoPessoaBancoRel("0000001");
                this.identificador.getContaCorrente().setnumeroContaCorrente(conta);
                this.identificador.setCodigoSituacaoIdentificador("O");
                this.identificador.setNumeroIdentificadorAntigo("");
                this.identificador.setDataRemessaAlteracao(null);
                this.identificador.setNumeroRemessaAlteracao(0);
                this.identificador.setTextoDescricaoOcorrencia(this.reg.getValorString("Ocorrencia"));
                IdentificadorDBTBD.getIdentificadorDBTBD().alterar(this.identificador);
                this.situacaoIdAlteradosNaoProc.addElement("Altera\u00e7\u00e3o de Identifica\u00e7\u00e3o de d\u00e9bito n\u00e3o processada no BB. Registro importado com sucesso no aplicativo.");
                if (IdentificadorDBTBD.getIdentificadorDBTBD().localizado(identificadorAntigo)) {
                    IdentificadorDBTBD.getIdentificadorDBTBD().obter(identificadorAntigo);
                    identificadorAntigo.setCodigoSituacaoIdentificador("A");
                    IdentificadorDBTBD.getIdentificadorDBTBD().alterar(identificadorAntigo);
                }
            } else if (IdentificadorDBTBD.getIdentificadorDBTBD().localizado(identificadorAntigo)) {
                IdentificadorDBTBD.getIdentificadorDBTBD().obter(identificadorAntigo);
                identificadorAntigo.setCodigoSituacaoIdentificador("A");
                IdentificadorDBTBD.getIdentificadorDBTBD().alterar(identificadorAntigo);
                this.identificador.setTextoDescricaoOcorrencia(this.reg.getValorString("Ocorrencia"));
                this.situacaoIdAlteradosNaoProc.addElement("Altera\u00e7\u00e3o de Identifica\u00e7\u00e3o de d\u00e9bito n\u00e3o processada no BB. Identifica\u00e7\u00e3o para D\u00e9bito alterado n\u00e3o localizado no Aplicativo, a Identifica\u00e7\u00e3o para D\u00e9bito Antiga voltar\u00e1 para situa\u00e7\u00e3o Ativo");
            } else {
                this.identificador.setTextoDescricaoOcorrencia(String.valueOf(this.identificador.getTextoDescricaoOcorrencia()) + this.reg.getValorString("Ocorrencia"));
                this.situacaoIdAlteradosNaoProc.addElement("Altera\u00e7\u00e3o de Identifica\u00e7\u00e3o de d\u00e9bito n\u00e3o processada no BB. Identifica\u00e7\u00e3o para D\u00e9bito alterado n\u00e3o localizado no Aplicativo, registro n\u00e3o importado");
            }
            this.identificador.setNumeroIdentificadorAntigo(numeroIdentificadorAntigo);
            this.identificadoresAlteradosNaoProc.addElement(this.identificador);
        }
        catch (Throwable t) {
            this.registrosNaoProcessados.addElement("Reg. N\u00ba" + registro + " - Dados P/Suporte (" + t.toString() + ")");
        }
    }

    private void processarRetornoRecebimentos(String nomeArquivo) throws Throwable {
        IBarraProgresso barraProgresso = this.getFramePlugin().obterBarraProgresso();
        try {
            ConexaoBancoDados.getConexao().setAutoCommit(false);
            String dirOrigem = ControleAplicacao.getDiretorioRetorno();
            String dirDestino = ControleAplicacao.getDiretorioArquivos();
            String estiloRetorno = "";
            book.abrirArquivoEntrada(new File(String.valueOf(dirOrigem) + nomeArquivo));
            barraProgresso.inicializar("Processando retorno. Aguarde... ", (int)new File(String.valueOf(dirOrigem) + nomeArquivo).length() / 150, false);
            try {
                this.reg = book.lerRegistro();
            }
            catch (Throwable t) {
                this.registrosNaoProcessados.addElement("Reg. N\u00ba1 - Dados P/Suporte (" + t.toString() + ")");
            }
            this.convenio = this.reg.getValorString("Convenio").substring(0, 5);
            try {
                this.reg = book.lerRegistro();
            }
            catch (Throwable t) {
                this.registrosNaoProcessados.addElement("Reg. N\u00ba2 - Dados P/Suporte (" + t.toString() + ")");
            }
            long lngContador = 0L;
            barraProgresso.setValor(0);
            this.convenioDBT = new ConvenioDBT();
            this.convenioDBT.setNumeroConvenioDBT(this.convenio);
            this.convenioDBT.setCodigoPessoaConvenenteDBT(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            ControleConvenente.getControleConvenente().obterConvenio(this.convenioDBT);
            while (this.reg != null) {
                ++lngContador;
                if (!this.reg.getValorString("TipoReg").equalsIgnoreCase("A") && !this.reg.getValorString("TipoReg").equalsIgnoreCase("Z")) {
                    if (this.reg.getValorString("TipoReg").equalsIgnoreCase("B")) {
                        this.processarRetornoB(lngContador);
                    } else if (this.reg.getValorString("TipoReg").equalsIgnoreCase("H")) {
                        this.processarRetornoH(lngContador);
                    } else if (this.reg.getValorString("TipoReg").equalsIgnoreCase("F")) {
                        this.recebimentoDBT = new RecebimentoDBT();
                        this.processarRetornoF(lngContador);
                    } else {
                        this.registrosNaoProcessados.addElement("Reg. N\u00b0" + lngContador + " - Dados P/Suporte (Tipo de Registro Inv\u00e1lido)");
                    }
                }
                barraProgresso.add(1);
                try {
                    this.reg = book.lerRegistro();
                }
                catch (Throwable t) {
                    this.registrosNaoProcessados.addElement("Reg. N\u00ba" + ++lngContador + " - Dados P/Suporte (" + t.toString() + ")");
                    this.reg = book.lerRegistro();
                }
            }
            ConexaoBancoDados.getConexao().commit();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            book.fecharArquivoEntrada();
            Util.copiar(new File(String.valueOf(dirOrigem) + nomeArquivo), new File(String.valueOf(dirDestino) + nomeArquivo));
            new File(String.valueOf(dirOrigem) + nomeArquivo).delete();
        }
        catch (Throwable e) {
            barraProgresso.finalizar();
            ConexaoBancoDados.getConexao().rollback();
            ConexaoBancoDados.getConexao().setAutoCommit(true);
            book.fecharArquivoEntrada();
            throw e;
        }
        barraProgresso.finalizar();
    }

    public void processarRetornos() {
        try {
            Object[][] linhasSelecionadas = this.multiColumnListbox.getSelectedRows();
            int i = 0;
            while (i < linhasSelecionadas.length) {
                this.vetorRelatorioRetorno = new Vector();
                this.recebimentos = new Vector();
                this.recebimentosNaoProc = new Vector();
                this.OcorrenciaRecebimentos = new Vector();
                this.OcorrenciaRecebimentosNaoProc = new Vector();
                this.situacaoRecebimentos = new Vector();
                this.situacaoRecebimentosNaoProc = new Vector();
                this.identificadoresAlterados = new Vector();
                this.identificadoresAlteradosNaoProc = new Vector();
                this.situacaoIdAlterados = new Vector();
                this.situacaoIdAlteradosNaoProc = new Vector();
                this.identificadoresCadastrados = new Vector();
                this.situacaoIdCadastrados = new Vector();
                this.registrosNaoProcessados = new Vector();
                this.identificacaoArquivoRetorno = new Vector();
                this.nomeArquivo = (String)linhasSelecionadas[i][0];
                this.numeroRetorno = (String)linhasSelecionadas[i][2];
                this.identificacaoArquivoRetorno.addElement((String)linhasSelecionadas[i][0]);
                this.identificacaoArquivoRetorno.addElement((String)linhasSelecionadas[i][1]);
                this.identificacaoArquivoRetorno.addElement((String)linhasSelecionadas[i][2]);
                this.identificacaoArquivoRetorno.addElement((String)linhasSelecionadas[i][3]);
                this.processarRetornoRecebimentos(this.nomeArquivo);
                this.getInterfaceGerenciadorListaRetornoRecebimentos().fechar();
                this.vetorRelatorioRetorno.addElement(this.recebimentos);
                this.vetorRelatorioRetorno.addElement(this.recebimentosNaoProc);
                this.vetorRelatorioRetorno.addElement(this.OcorrenciaRecebimentos);
                this.vetorRelatorioRetorno.addElement(this.OcorrenciaRecebimentosNaoProc);
                this.vetorRelatorioRetorno.addElement(this.situacaoRecebimentos);
                this.vetorRelatorioRetorno.addElement(this.situacaoRecebimentosNaoProc);
                this.vetorRelatorioRetorno.addElement(this.identificadoresAlterados);
                this.vetorRelatorioRetorno.addElement(this.identificadoresAlteradosNaoProc);
                this.vetorRelatorioRetorno.addElement(this.situacaoIdAlterados);
                this.vetorRelatorioRetorno.addElement(this.situacaoIdAlteradosNaoProc);
                this.vetorRelatorioRetorno.addElement(this.identificadoresCadastrados);
                this.vetorRelatorioRetorno.addElement(this.situacaoIdCadastrados);
                this.vetorRelatorioRetorno.addElement(this.registrosNaoProcessados);
                this.vetorRelatorioRetorno.addElement(this.identificacaoArquivoRetorno);
                this.abrirResumoRetorno(this.vetorRelatorioRetorno);
                ++i;
            }
            this.abrirRetornoRecebimento();
        }
        catch (Throwable t) {
            Util.exibirMensagemErro(t);
        }
    }

    public void setRegistrosNaoProcessados(Vector newRegistrosNaoProcessados) {
        this.registrosNaoProcessados = newRegistrosNaoProcessados;
    }
}

