/*
 * Decompiled with CFR 0.152.
 */
package br.com.bb.plugins.interfaces.recebimentosdeterceiros;

import br.com.bb.data.Data;
import br.com.bb.plugins.beans.BBPluginButton;
import br.com.bb.plugins.beans.BBPluginButtonAjuda;
import br.com.bb.plugins.beans.BBPluginChoiceAuto;
import br.com.bb.plugins.beans.BBPluginLabel;
import br.com.bb.plugins.beans.BBPluginMaskedTextField;
import br.com.bb.plugins.controle.infraestrutura.ControleAplicacao;
import br.com.bb.plugins.controle.infraestrutura.IBarraProgresso;
import br.com.bb.plugins.controle.recebimentosdeterceiros.ControleConvenente;
import br.com.bb.plugins.controle.recebimentosdeterceiros.ControleGrupoClientes;
import br.com.bb.plugins.controle.recebimentosdeterceiros.ControleMovimento;
import br.com.bb.plugins.interfaces.infraestrutura.PanelBB;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.ConvenioDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.GrupoClienteRecebimento;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.IdentificadorDBT;
import br.com.bb.plugins.negocio.recebimentosdeterceiros.RecebimentoDBT;
import br.com.bb.plugins.utilitarios.Util;
import com.ibm.webrunner.util.SelectionSorter;
import com.ibm.webrunner.widget.BorderPanel;
import com.ibm.webrunner.widget.InputDirection;
import com.ibm.webrunner.widget.ListboxColumn;
import com.ibm.webrunner.widget.MultiColumnListbox;
import com.ibm.webrunner.widget.event.ListboxEvent;
import com.ibm.webrunner.widget.event.ListboxListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class MovimentoCadastroGrupo
extends PanelBB {
    private BBPluginChoiceAuto ivjBBPluginChoiceAutoGrupo = null;
    private BBPluginLabel ivjBBPluginLabelGrupo = null;
    private BBPluginButton ivjButtonSair = null;
    private BBPluginButton ivjButtonSalvar = null;
    private BBPluginLabel ivjLabelDataDebito = null;
    private BBPluginLabel ivjLabelValorDebito = null;
    private Panel ivjPanelBotoes = null;
    private GridLayout ivjPanelBotoesGridLayout = null;
    private BBPluginMaskedTextField ivjTextFieldValor = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private BBPluginButtonAjuda ivjButtonAjuda = null;
    private Vector vetorClientes = new Vector();
    private BBPluginMaskedTextField ivjBBPluginMaskedTextFieldData = null;
    private BBPluginChoiceAuto ivjBBPluginChoiceAutoConvenio = null;
    private BBPluginLabel ivjBBPluginLabelConvenio = null;
    private BorderPanel ivjBorderPanelMovimento = null;
    private BBPluginButton ivjButtonRetirarCliente = null;
    private BBPluginLabel ivjLabelInformacao = null;
    private BBPluginLabel ivjlabelQuantidade = null;
    private BBPluginLabel ivjlabelValorTotal = null;
    private MultiColumnListbox ivjMultiColumnListboxMovimento = null;
    private BBPluginLabel ivjtxtQuantidade = null;
    private BBPluginLabel ivjtxtValorTotal = null;

    public MovimentoCadastroGrupo() {
        this.initialize();
    }

    public MovimentoCadastroGrupo(LayoutManager layout) {
        super(layout);
    }

    public void alterarData() {
        try {
            if (this.getMultiColumnListboxMovimento().getRowCount() > 0) {
                IBarraProgresso barra = this.getRoteador().obterBarraProgresso();
                String data = String.valueOf(this.getBBPluginMaskedTextFieldData().getText().substring(0, 2)) + "/" + this.getBBPluginMaskedTextFieldData().getText().substring(2, 4) + "/" + this.getBBPluginMaskedTextFieldData().getText().substring(4);
                if (this.getBBPluginMaskedTextFieldData().getText().trim().length() > 0 && !data.equals((String)this.getMultiColumnListboxMovimento().getRow(0)[9])) {
                    barra.setMensagem("Atualizando a data dos recebimentos. Aguarde...");
                    barra.setValorMaximo(this.getMultiColumnListboxMovimento().getRowCount());
                    int i = 0;
                    while (i < this.getMultiColumnListboxMovimento().getRowCount()) {
                        barra.setValor(i);
                        Object[] o = this.getMultiColumnListboxMovimento().getRow(i);
                        o[9] = data;
                        this.getMultiColumnListboxMovimento().replaceRow(o, i);
                        ++i;
                    }
                }
                barra.finalizar();
            }
        }
        catch (Throwable e) {
            this.getRoteador().exibirMensagemErro(e);
        }
    }

    public void alterarValor() {
        try {
            if (this.getMultiColumnListboxMovimento().getRowCount() > 0) {
                IBarraProgresso barra = this.getRoteador().obterBarraProgresso();
                if (this.getTextFieldValor().getText().trim().length() > 0 && !this.getTextFieldValor().getText().trim().equals((String)this.getMultiColumnListboxMovimento().getRow(0)[10])) {
                    barra.setMensagem("Recalculando o valor dos recebimentos. Aguarde...");
                    barra.setValorMaximo(this.getMultiColumnListboxMovimento().getRowCount());
                    double total = 0.0;
                    int i = 0;
                    while (i < this.getMultiColumnListboxMovimento().getRowCount()) {
                        barra.setValor(i);
                        Object[] o = this.getMultiColumnListboxMovimento().getRow(i);
                        o[10] = Util.formatarValor(Double.valueOf(this.getTextFieldValor().getText().trim()) / 100.0, 2);
                        this.getMultiColumnListboxMovimento().replaceRow(o, i);
                        total += Double.valueOf(this.getTextFieldValor().getText()) / 100.0;
                        ++i;
                    }
                    this.gettxtValorTotal().setText(Util.formatarValor(total, 2));
                }
                barra.finalizar();
            }
        }
        catch (Throwable e) {
            this.getRoteador().exibirMensagemErro(e);
        }
    }

    public void bBPluginChoiceAutoConvenio_ItemStateChanged(ItemEvent itemEvent) {
        try {
            this.limparTodosCampos();
            this.popularChoiceGrupo();
        }
        catch (Throwable t) {
            Util.exibirMensagemErro(t);
        }
    }

    public void bBPluginChoiceAutoGrupo_ItemStateChanged(ItemEvent itemEvent) {
        try {
            this.getMultiColumnListboxMovimento().removeAllRows();
            if (!this.getBBPluginChoiceAutoGrupo().getSelectedItem().equals("") && this.existemClientes()) {
                this.popularGridMovimento();
            }
        }
        catch (Throwable t) {
            this.setCursor(new Cursor(0));
            Util.exibirMensagemErro(t);
        }
    }

    public void bBPluginMaskedTextFieldData_FocusLost(FocusEvent focusEvent) {
        this.alterarData();
    }

    public void buttonAjuda_ActionPerformed(ActionEvent actionEvent) {
    }

    public void buttonRetirarCliente_ActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.getRoteador().exibirMensagemConfirmacao("Retirar Recebimento", "Confirma retirada do recebimento selecionado?")) {
                this.getButtonRetirarCliente().setEnabled(false);
                this.gettxtQuantidade().setText(String.valueOf(Integer.parseInt(this.gettxtQuantidade().getText()) - 1));
                this.gettxtValorTotal().setText(Util.formatarValor(Double.valueOf(Util.desformatarValor(this.gettxtValorTotal().getText())) / 100.0 - Double.valueOf(Util.desformatarValor((String)this.getMultiColumnListboxMovimento().getSelectedRow()[10])) / 100.0, 2));
                this.getMultiColumnListboxMovimento().removeRow(this.getMultiColumnListboxMovimento().getSelectedIndex());
            } else {
                this.getButtonRetirarCliente().setEnabled(false);
            }
        }
        catch (Throwable t) {
            this.getRoteador().exibirMensagemErro(t);
        }
    }

    public void buttonSair_ActionPerformed(ActionEvent actionEvent) {
        this.fechar();
    }

    public void buttonSalvar_ActionPerformed(ActionEvent actionEvent) {
        try {
            this.getButtonSalvar().setEnabled(false);
            this.getButtonAjuda().setEnabled(false);
            this.getButtonSair().setEnabled(false);
            if (this.criticarCampos()) {
                this.gerarMovimento();
                this.getRoteador().exibirMensagem("Recebimentos inclu\u00eddos com sucesso!");
                this.getButtonSalvar().setEnabled(true);
                this.getButtonAjuda().setEnabled(true);
                this.getButtonSair().setEnabled(true);
                this.getBBPluginChoiceAutoConvenio().removeAll();
                this.limparTodosCampos();
                this.popular();
            }
            this.getButtonSalvar().setEnabled(true);
            this.getButtonAjuda().setEnabled(true);
            this.getButtonSair().setEnabled(true);
            return;
        }
        catch (Throwable t) {
            Util.exibirMensagemErro(t);
            this.getButtonSalvar().setEnabled(true);
            this.getButtonAjuda().setEnabled(true);
            this.getButtonSair().setEnabled(true);
            return;
        }
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.buttonSair_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.buttonSalvar_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ItemEvent arg1) {
        try {
            this.bBPluginChoiceAutoConvenio_ItemStateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ItemEvent arg1) {
        try {
            this.bBPluginChoiceAutoGrupo_ItemStateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(FocusEvent arg1) {
        try {
            this.bBPluginMaskedTextFieldData_FocusLost(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(FocusEvent arg1) {
        try {
            this.textFieldValor_FocusLost(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC7(ActionEvent arg1) {
        try {
            this.buttonRetirarCliente_ActionPerformed(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC8(ListboxEvent arg1) {
        try {
            this.multiColumnListboxMovimento_RowSelected(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public boolean criticarCampos() throws Throwable {
        if (this.getBBPluginChoiceAutoConvenio().getSelectedIndex() < 0) {
            this.getRoteador().exibirMensagem("O Conv\u00eanio deve ser Selecionado!");
            return false;
        }
        if (this.getBBPluginChoiceAutoGrupo().getSelectedIndex() < 1) {
            this.getRoteador().exibirMensagem("O Grupo deve ser Selecionado!");
            return false;
        }
        if (!this.criticarData()) {
            return false;
        }
        if (!this.criticarValor()) {
            return false;
        }
        if (this.getMultiColumnListboxMovimento().getRowCount() < 1) {
            this.getRoteador().exibirMensagem("N\u00e3o existem Recebimentos para inclus\u00e3o. Selecione um Grupo de Clientes para inclus\u00e3o dos Recebimentos");
            return false;
        }
        return true;
    }

    public boolean criticarData() throws Throwable {
        String data = this.getBBPluginMaskedTextFieldData().getText();
        String dia = data.substring(0, 2).trim();
        String mes = data.substring(2, 4).trim();
        String ano = data.substring(4).trim();
        if (dia.equals("") || mes.equals("") || ano.equals("")) {
            this.getRoteador().exibirMensagem("A Data Deve Ser Informada!");
            return false;
        }
        Data dataRec = new Data();
        dataRec.set(Integer.parseInt(dia), Integer.parseInt(mes), Integer.parseInt(ano));
        Data dataMov = new Data();
        dataMov.set(Integer.parseInt(dia), Integer.parseInt(mes), Integer.parseInt(ano));
        Data dt = new Data();
        if (dataMov.compararCom(dt) < 0) {
            this.getRoteador().exibirMensagem("A Data deve ser maior ou igual a data atual.");
            this.getBBPluginMaskedTextFieldData().requestFocus();
            return false;
        }
        if (!dataMov.isDiaUtil()) {
            this.getBBPluginMaskedTextFieldData().setText(String.valueOf(dataMov.getProximaDataUtil().getFormatada().substring(0, 2)) + dataMov.getProximaDataUtil().getFormatada().substring(3, 5) + dataMov.getProximaDataUtil().getFormatada().substring(6));
            this.alterarData();
            this.getRoteador().exibirMensagem("Recebimento para dia n\u00e3o \u00fatil. A data foi alterada para o pr\u00f3ximo dia \u00fatil: " + dataMov.getProximaDataUtil().getFormatada());
        }
        return true;
    }

    public boolean criticarValor() throws Throwable {
        if (this.getTextFieldValor().getText().trim().equals("") || Double.valueOf(this.getTextFieldValor().getText()) < 0.0) {
            this.getRoteador().exibirMensagem("O valor deve ser maior ou igual a zero!");
            this.getTextFieldValor().requestFocus();
            return false;
        }
        if (Double.valueOf(this.getTextFieldValor().getText()) == 0.0) {
            return this.getRoteador().exibirMensagemConfirmacao("Aten\u00e7\u00e3o!", "Os recebimentos ser\u00e3o gravados com valor zerado. Confirma?");
        }
        return true;
    }

    public boolean existemClientes() throws Throwable {
        if (this.getBBPluginChoiceAutoConvenio().getSelectedItem() != null && this.getBBPluginChoiceAutoConvenio().getSelectedItem().trim().compareTo("") != 0) {
            RecebimentoDBT recebimentoDBT = new RecebimentoDBT();
            recebimentoDBT.getIdentificadorDBT().getConvenioDBT().setNumeroConvenioDBT(this.getBBPluginChoiceAutoConvenio().getSelectedCodigo());
            recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().setCodigoPessoaIdentificadorRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().setCodigoIdentificadorRel("DBT" + this.getBBPluginChoiceAutoConvenio().getSelectedCodigo());
            if (this.getBBPluginChoiceAutoGrupo().getSelectedItem() != null && this.getBBPluginChoiceAutoGrupo().getSelectedItem().trim().compareTo("") != 0) {
                if (this.getBBPluginChoiceAutoGrupo().getSelectedCodigo().equals("TODOS")) {
                    recebimentoDBT.getIdentificadorDBT().getMembroGrupoRecebimentoDBT().getGrupo().setCodigoGrupoClienteRecebimento(0);
                } else if (this.getBBPluginChoiceAutoGrupo().getSelectedCodigo().equals("NULO")) {
                    recebimentoDBT.getIdentificadorDBT().getMembroGrupoRecebimentoDBT().getGrupo().setCodigoGrupoClienteRecebimento(-1);
                } else {
                    recebimentoDBT.getIdentificadorDBT().getMembroGrupoRecebimentoDBT().getGrupo().setCodigoGrupoClienteRecebimento(Integer.parseInt(this.getBBPluginChoiceAutoGrupo().getSelectedCodigo()));
                }
            } else {
                recebimentoDBT.getIdentificadorDBT().getMembroGrupoRecebimentoDBT().getGrupo().setCodigoGrupoClienteRecebimento(0);
            }
            this.setCursor(new Cursor(3));
            this.vetorClientes = ControleMovimento.getControleMovimento().obterListaIDDBTSituacaoOK(recebimentoDBT);
            this.setCursor(new Cursor(0));
            if (this.vetorClientes.size() <= 0) {
                if (this.getBBPluginChoiceAutoGrupo().getSelectedCodigo().equals("TODOS")) {
                    this.getRoteador().exibirMensagem("N\u00e3o existem clientes cadastrados para o conv\u00eanio selecionado");
                } else if (this.getBBPluginChoiceAutoGrupo().getSelectedCodigo().equals("NULO")) {
                    this.getRoteador().exibirMensagem("N\u00e3o existem clientes sem Grupo");
                } else {
                    this.getRoteador().exibirMensagem("N\u00e3o existem clientes cadastrados para o Grupo selecionado");
                }
                return false;
            }
        } else {
            this.getRoteador().exibirMensagem("O conv\u00eanio deve ser selecionado");
            return false;
        }
        return true;
    }

    public void gerarMovimento() throws Throwable {
        RecebimentoDBT recebimentoDBT = new RecebimentoDBT();
        IBarraProgresso barraProgresso = this.getRoteador().getFramePlugin().obterBarraProgresso();
        barraProgresso.inicializar("Incluindo Recebimentos para o grupo. Aguarde...", this.getMultiColumnListboxMovimento().getRowCount(), false);
        barraProgresso.setValorMaximo(this.getMultiColumnListboxMovimento().getRowCount());
        int i = 0;
        while (i < this.getMultiColumnListboxMovimento().getRowCount()) {
            Object[] o = this.getMultiColumnListboxMovimento().getRow(i);
            recebimentoDBT.setNumeroRecebimentoDBT(0);
            recebimentoDBT.setIdRegistro("");
            recebimentoDBT.getCliente().getPessoa().setCodigoPessoa((String)o[0]);
            recebimentoDBT.getConvenio().setNumeroConvenioDBT(this.getBBPluginChoiceAutoConvenio().getSelectedCodigo());
            recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().setCodigoPessoaIdentificadorRel(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().setCodigoPessoaRel((String)o[0]);
            recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().setCodigoIdentificador("DBT" + this.getBBPluginChoiceAutoConvenio().getSelectedCodigo());
            recebimentoDBT.getIdentificadorDBT().getIdentificacaoDBT().setNumeroIdentificador((String)o[3]);
            recebimentoDBT.getIdentificadorDBT().getConvenioDBT().setNumeroConvenioDBT(this.getBBPluginChoiceAutoConvenio().getSelectedCodigo());
            recebimentoDBT.setCodigoSituacaoRecebimentoRel("G");
            recebimentoDBT.getSituacaoRecebimento().setCodigoSituacaoRecebimento("G");
            recebimentoDBT.setValorRecebimento(Double.valueOf(Util.desformatarValor((String)o[10])) / 100.0);
            recebimentoDBT.setDataRecebimento(Util.strdataToDate((String)o[9]));
            ControleMovimento.getControleMovimento().setIndicadorOperacao('I');
            ControleMovimento.getControleMovimento().incluirRecebimento(recebimentoDBT);
            barraProgresso.add(1);
            ++i;
        }
        barraProgresso.finalizar();
    }

    private BBPluginChoiceAuto getBBPluginChoiceAutoConvenio() {
        if (this.ivjBBPluginChoiceAutoConvenio == null) {
            try {
                this.ivjBBPluginChoiceAutoConvenio = new BBPluginChoiceAuto();
                this.ivjBBPluginChoiceAutoConvenio.setName("BBPluginChoiceAutoConvenio");
                this.ivjBBPluginChoiceAutoConvenio.setToolTipText("Informe o Conv\u00eanio para gera\u00e7\u00e3o dos recebimentos");
                this.ivjBBPluginChoiceAutoConvenio.setBackground(Color.white);
                this.ivjBBPluginChoiceAutoConvenio.setBounds(79, 9, 365, 23);
                this.ivjBBPluginChoiceAutoConvenio.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBBPluginChoiceAutoConvenio;
    }

    private BBPluginChoiceAuto getBBPluginChoiceAutoGrupo() {
        if (this.ivjBBPluginChoiceAutoGrupo == null) {
            try {
                this.ivjBBPluginChoiceAutoGrupo = new BBPluginChoiceAuto();
                this.ivjBBPluginChoiceAutoGrupo.setName("BBPluginChoiceAutoGrupo");
                this.ivjBBPluginChoiceAutoGrupo.setToolTipText("Selecione o Grupo para gera\u00e7\u00e3o dos recebimentos");
                this.ivjBBPluginChoiceAutoGrupo.setBackground(Color.white);
                this.ivjBBPluginChoiceAutoGrupo.setBounds(79, 36, 365, 20);
                this.ivjBBPluginChoiceAutoGrupo.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBBPluginChoiceAutoGrupo;
    }

    private BBPluginLabel getBBPluginLabelConvenio() {
        if (this.ivjBBPluginLabelConvenio == null) {
            try {
                this.ivjBBPluginLabelConvenio = new BBPluginLabel();
                this.ivjBBPluginLabelConvenio.setName("BBPluginLabelConvenio");
                this.ivjBBPluginLabelConvenio.setText("Conv\u00eanio:");
                this.ivjBBPluginLabelConvenio.setBounds(12, 9, 55, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBBPluginLabelConvenio;
    }

    private BBPluginLabel getBBPluginLabelGrupo() {
        if (this.ivjBBPluginLabelGrupo == null) {
            try {
                this.ivjBBPluginLabelGrupo = new BBPluginLabel();
                this.ivjBBPluginLabelGrupo.setName("BBPluginLabelGrupo");
                this.ivjBBPluginLabelGrupo.setText("Grupo:");
                this.ivjBBPluginLabelGrupo.setBounds(12, 36, 45, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBBPluginLabelGrupo;
    }

    private BBPluginMaskedTextField getBBPluginMaskedTextFieldData() {
        if (this.ivjBBPluginMaskedTextFieldData == null) {
            try {
                this.ivjBBPluginMaskedTextFieldData = new BBPluginMaskedTextField();
                this.ivjBBPluginMaskedTextFieldData.setName("BBPluginMaskedTextFieldData");
                this.ivjBBPluginMaskedTextFieldData.setReturnLiterals(false);
                this.ivjBBPluginMaskedTextFieldData.setTamanhoMaximo(10);
                this.ivjBBPluginMaskedTextFieldData.setMask("##/##/####");
                this.ivjBBPluginMaskedTextFieldData.setReturnBlanks(true);
                this.ivjBBPluginMaskedTextFieldData.setTransferirFocoPorEnter(true);
                this.ivjBBPluginMaskedTextFieldData.setBounds(511, 9, 132, 21);
                this.ivjBBPluginMaskedTextFieldData.setBlankChar(' ');
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBBPluginMaskedTextFieldData;
    }

    private BorderPanel getBorderPanelMovimento() {
        if (this.ivjBorderPanelMovimento == null) {
            try {
                this.ivjBorderPanelMovimento = new BorderPanel();
                this.ivjBorderPanelMovimento.setName("BorderPanelMovimento");
                this.ivjBorderPanelMovimento.setLayout(null);
                this.ivjBorderPanelMovimento.setText("Recebimentos");
                this.ivjBorderPanelMovimento.setTextFont(new Font("sansserif", 1, 14));
                this.ivjBorderPanelMovimento.setForeground(new Color(0, 64, 127));
                this.ivjBorderPanelMovimento.setColor(new Color(0, 64, 127));
                this.ivjBorderPanelMovimento.setBounds(8, 65, 644, 337);
                this.getBorderPanelMovimento().add((Component)this.getMultiColumnListboxMovimento(), this.getMultiColumnListboxMovimento().getName());
                this.getBorderPanelMovimento().add((Component)this.getlabelQuantidade(), this.getlabelQuantidade().getName());
                this.getBorderPanelMovimento().add((Component)this.gettxtQuantidade(), this.gettxtQuantidade().getName());
                this.getBorderPanelMovimento().add((Component)this.getlabelValorTotal(), this.getlabelValorTotal().getName());
                this.getBorderPanelMovimento().add((Component)this.gettxtValorTotal(), this.gettxtValorTotal().getName());
                this.getBorderPanelMovimento().add((Component)this.getLabelInformacao(), this.getLabelInformacao().getName());
                this.getBorderPanelMovimento().add((Component)this.getButtonRetirarCliente(), this.getButtonRetirarCliente().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBorderPanelMovimento;
    }

    private BBPluginButtonAjuda getButtonAjuda() {
        if (this.ivjButtonAjuda == null) {
            try {
                this.ivjButtonAjuda = new BBPluginButtonAjuda();
                this.ivjButtonAjuda.setName("ButtonAjuda");
                this.ivjButtonAjuda.setArquivoHTML("inclusaorecebimentosgrupos.htm");
                this.ivjButtonAjuda.setLabel("Ajuda");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonAjuda;
    }

    private BBPluginButton getButtonRetirarCliente() {
        if (this.ivjButtonRetirarCliente == null) {
            try {
                this.ivjButtonRetirarCliente = new BBPluginButton();
                this.ivjButtonRetirarCliente.setName("ButtonRetirarCliente");
                this.ivjButtonRetirarCliente.setToolTipText("N\u00e3o gera recebimento para cliente selecionado");
                this.ivjButtonRetirarCliente.setBounds(510, 286, 119, 20);
                this.ivjButtonRetirarCliente.setEnabled(false);
                this.ivjButtonRetirarCliente.setLabel("Retirar");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonRetirarCliente;
    }

    private BBPluginButton getButtonSair() {
        if (this.ivjButtonSair == null) {
            try {
                this.ivjButtonSair = new BBPluginButton();
                this.ivjButtonSair.setName("ButtonSair");
                this.ivjButtonSair.setLabel("Sair");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonSair;
    }

    private BBPluginButton getButtonSalvar() {
        if (this.ivjButtonSalvar == null) {
            try {
                this.ivjButtonSalvar = new BBPluginButton();
                this.ivjButtonSalvar.setName("ButtonSalvar");
                this.ivjButtonSalvar.setToolTipText("Inclui Recebimentos");
                this.ivjButtonSalvar.setLabel("Incluir Recebimentos");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjButtonSalvar;
    }

    private BBPluginLabel getLabelDataDebito() {
        if (this.ivjLabelDataDebito == null) {
            try {
                this.ivjLabelDataDebito = new BBPluginLabel();
                this.ivjLabelDataDebito.setName("LabelDataDebito");
                this.ivjLabelDataDebito.setText("Data:");
                this.ivjLabelDataDebito.setBounds(462, 9, 35, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLabelDataDebito;
    }

    private BBPluginLabel getLabelInformacao() {
        if (this.ivjLabelInformacao == null) {
            try {
                this.ivjLabelInformacao = new BBPluginLabel();
                this.ivjLabelInformacao.setName("LabelInformacao");
                this.ivjLabelInformacao.setFont(new Font("monospaced", 2, 12));
                this.ivjLabelInformacao.setText("Para alterar os recebimentos utilize a op\u00e7\u00e3o: Recebimentos/Manuten\u00e7\u00e3o");
                this.ivjLabelInformacao.setBounds(15, 309, 611, 16);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLabelInformacao;
    }

    private BBPluginLabel getlabelQuantidade() {
        if (this.ivjlabelQuantidade == null) {
            try {
                this.ivjlabelQuantidade = new BBPluginLabel();
                this.ivjlabelQuantidade.setName("labelQuantidade");
                this.ivjlabelQuantidade.setText("Quantidade:");
                this.ivjlabelQuantidade.setBounds(15, 286, 75, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlabelQuantidade;
    }

    private BBPluginLabel getLabelValorDebito() {
        if (this.ivjLabelValorDebito == null) {
            try {
                this.ivjLabelValorDebito = new BBPluginLabel();
                this.ivjLabelValorDebito.setName("LabelValorDebito");
                this.ivjLabelValorDebito.setText("Valor:");
                this.ivjLabelValorDebito.setBounds(461, 36, 41, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLabelValorDebito;
    }

    private BBPluginLabel getlabelValorTotal() {
        if (this.ivjlabelValorTotal == null) {
            try {
                this.ivjlabelValorTotal = new BBPluginLabel();
                this.ivjlabelValorTotal.setName("labelValorTotal");
                this.ivjlabelValorTotal.setText("Valor Total:");
                this.ivjlabelValorTotal.setBounds(260, 286, 63, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlabelValorTotal;
    }

    private MultiColumnListbox getMultiColumnListboxMovimento() {
        if (this.ivjMultiColumnListboxMovimento == null) {
            try {
                this.ivjMultiColumnListboxMovimento = new MultiColumnListbox();
                this.ivjMultiColumnListboxMovimento.setName("MultiColumnListboxMovimento");
                this.ivjMultiColumnListboxMovimento.setCaptionBarForeground(new Color(0, 64, 127));
                this.ivjMultiColumnListboxMovimento.setSelectionForeground(SystemColor.activeCaptionText);
                this.ivjMultiColumnListboxMovimento.setBackground(Color.white);
                this.ivjMultiColumnListboxMovimento.setCaptionBarHeight(20);
                this.ivjMultiColumnListboxMovimento.setForeground(new Color(0, 64, 127));
                this.ivjMultiColumnListboxMovimento.setVerticalSeparatorVisible(true);
                this.ivjMultiColumnListboxMovimento.setHorizontalSeparatorVisible(true);
                this.ivjMultiColumnListboxMovimento.setContinuousDrag(true);
                this.ivjMultiColumnListboxMovimento.setSeparatorColor(Color.lightGray);
                this.ivjMultiColumnListboxMovimento.setBounds(13, 21, 619, 259);
                this.ivjMultiColumnListboxMovimento.setSelectionBackground(new Color(0, 64, 127));
                this.ivjMultiColumnListboxMovimento.addColumn("CodigoPessoa");
                this.ivjMultiColumnListboxMovimento.addColumn("CodigoIdentificador");
                this.ivjMultiColumnListboxMovimento.addColumn("CodigoPessoaIdentificador");
                this.ivjMultiColumnListboxMovimento.addColumn("NumeroIdentificadorDBT");
                this.ivjMultiColumnListboxMovimento.addColumn("Nome");
                this.ivjMultiColumnListboxMovimento.addColumn("Identifica\u00e7\u00e3o P/D\u00e9bito");
                this.ivjMultiColumnListboxMovimento.addColumn("Banco");
                this.ivjMultiColumnListboxMovimento.addColumn("Ag\u00eancia");
                this.ivjMultiColumnListboxMovimento.addColumn("Conta");
                this.ivjMultiColumnListboxMovimento.addColumn("Data");
                this.ivjMultiColumnListboxMovimento.addColumn("Valor");
                ListboxColumn column = this.ivjMultiColumnListboxMovimento.getColumnInfo(0);
                column.setVisible(false);
                column.setWidth(0);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(1);
                column.setVisible(false);
                column.setWidth(0);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(2);
                column.setVisible(false);
                column.setWidth(0);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(3);
                column.setVisible(false);
                column.setWidth(0);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(4);
                column.setWidth(200);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(5);
                column.setWidth(200);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(6);
                column.setWidth(50);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(7);
                column.setWidth(70);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(8);
                column.setWidth(100);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(9);
                column.setWidth(100);
                column.setSorter(new SelectionSorter());
                column = this.ivjMultiColumnListboxMovimento.getColumnInfo(10);
                column.setWidth(100);
                column.setSorter(new SelectionSorter());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMultiColumnListboxMovimento;
    }

    private Panel getPanelBotoes() {
        if (this.ivjPanelBotoes == null) {
            try {
                this.ivjPanelBotoes = new Panel();
                this.ivjPanelBotoes.setName("PanelBotoes");
                this.ivjPanelBotoes.setLayout(this.getPanelBotoesGridLayout());
                this.ivjPanelBotoes.setBounds(234, 408, 413, 24);
                this.getPanelBotoes().add((Component)this.getButtonSalvar(), this.getButtonSalvar().getName());
                this.getPanelBotoes().add((Component)this.getButtonAjuda(), this.getButtonAjuda().getName());
                this.getPanelBotoes().add((Component)this.getButtonSair(), this.getButtonSair().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPanelBotoes;
    }

    private GridLayout getPanelBotoesGridLayout() {
        GridLayout ivjPanelBotoesGridLayout = null;
        try {
            ivjPanelBotoesGridLayout = new GridLayout();
            ivjPanelBotoesGridLayout.setHgap(0);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjPanelBotoesGridLayout;
    }

    private BBPluginMaskedTextField getTextFieldValor() {
        if (this.ivjTextFieldValor == null) {
            try {
                this.ivjTextFieldValor = new BBPluginMaskedTextField();
                this.ivjTextFieldValor.setName("TextFieldValor");
                this.ivjTextFieldValor.setToolTipText("Informe o valor para os recebimentos");
                this.ivjTextFieldValor.setReturnLiterals(false);
                this.ivjTextFieldValor.setMask("###.###.###,##");
                this.ivjTextFieldValor.setInputDirection(InputDirection.LEFT);
                this.ivjTextFieldValor.setBounds(511, 36, 132, 20);
                this.ivjTextFieldValor.setEditable(true);
                this.ivjTextFieldValor.setBlankChar(' ');
                this.ivjTextFieldValor.setBackground(Color.white);
                this.ivjTextFieldValor.setForeground(Color.black);
                this.ivjTextFieldValor.setTamanhoMaximo(50);
                this.ivjTextFieldValor.setMoveCursor(false);
                this.ivjTextFieldValor.setReturnBlanks(true);
                this.ivjTextFieldValor.setFont(new Font("monospaced", 0, 12));
                this.ivjTextFieldValor.setTransferirFocoPorEnter(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTextFieldValor;
    }

    private BBPluginLabel gettxtQuantidade() {
        if (this.ivjtxtQuantidade == null) {
            try {
                this.ivjtxtQuantidade = new BBPluginLabel();
                this.ivjtxtQuantidade.setName("txtQuantidade");
                this.ivjtxtQuantidade.setAlignment(2);
                this.ivjtxtQuantidade.setText("0");
                this.ivjtxtQuantidade.setBounds(87, 286, 58, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjtxtQuantidade;
    }

    private BBPluginLabel gettxtValorTotal() {
        if (this.ivjtxtValorTotal == null) {
            try {
                this.ivjtxtValorTotal = new BBPluginLabel();
                this.ivjtxtValorTotal.setName("txtValorTotal");
                this.ivjtxtValorTotal.setAlignment(2);
                this.ivjtxtValorTotal.setText("0,00");
                this.ivjtxtValorTotal.setBounds(330, 286, 109, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjtxtValorTotal;
    }

    private void handleException(Throwable exception) {
        Util.exibirMensagemErro(exception);
    }

    private void initConnections() throws Exception {
        this.getButtonSair().addActionListener(this.ivjEventHandler);
        this.getButtonSalvar().addActionListener(this.ivjEventHandler);
        this.getBBPluginChoiceAutoConvenio().addItemListener(this.ivjEventHandler);
        this.getBBPluginChoiceAutoGrupo().addItemListener(this.ivjEventHandler);
        this.getBBPluginMaskedTextFieldData().addFocusListener(this.ivjEventHandler);
        this.getTextFieldValor().addFocusListener(this.ivjEventHandler);
        this.getButtonRetirarCliente().addActionListener(this.ivjEventHandler);
        this.getMultiColumnListboxMovimento().addListboxListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("MovimentoCadastroGrupo");
            this.setCentralizado(true);
            this.setLayout(null);
            this.setBorda(true);
            this.setSize(661, 460);
            this.setModal(true);
            this.add((Component)this.getBBPluginLabelConvenio(), this.getBBPluginLabelConvenio().getName());
            this.add((Component)this.getBBPluginChoiceAutoConvenio(), this.getBBPluginChoiceAutoConvenio().getName());
            this.add((Component)this.getLabelDataDebito(), this.getLabelDataDebito().getName());
            this.add((Component)this.getBBPluginChoiceAutoGrupo(), this.getBBPluginChoiceAutoGrupo().getName());
            this.add((Component)this.getBBPluginMaskedTextFieldData(), this.getBBPluginMaskedTextFieldData().getName());
            this.add((Component)this.getBBPluginLabelGrupo(), this.getBBPluginLabelGrupo().getName());
            this.add((Component)this.getLabelValorDebito(), this.getLabelValorDebito().getName());
            this.add((Component)this.getTextFieldValor(), this.getTextFieldValor().getName());
            this.add((Component)this.getBorderPanelMovimento(), this.getBorderPanelMovimento().getName());
            this.add((Component)this.getPanelBotoes(), this.getPanelBotoes().getName());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.getBBPluginChoiceAutoConvenio().removeAll();
        this.limparTodosCampos();
    }

    public void limparTodosCampos() {
        this.getBBPluginChoiceAutoGrupo().removeAll();
        this.getTextFieldValor().setText("");
        this.getBBPluginMaskedTextFieldData().setText("");
        this.getMultiColumnListboxMovimento().removeAllRows();
        this.gettxtValorTotal().setText("0,00");
        this.gettxtQuantidade().setText("0");
    }

    public static void main(String[] args) {
        try {
            Frame frame = new Frame();
            MovimentoCadastroGrupo aMovimentoCadastroGrupo = new MovimentoCadastroGrupo();
            frame.add("Center", aMovimentoCadastroGrupo);
            ((Component)frame).setSize(aMovimentoCadastroGrupo.getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            ((Component)frame).setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Ocorreu uma exce\u00e7\u00e3o no main() do br.com.bb.plugins.interfaces.infraestrutura.PanelBB");
            exception.printStackTrace(System.out);
        }
    }

    public void multiColumnListboxMovimento_RowSelected(ListboxEvent arg1) {
        this.getButtonRetirarCliente().setEnabled(true);
    }

    public void popular() {
        try {
            this.popularChoiceConvenio();
            this.popularChoiceGrupo();
        }
        catch (Throwable e) {
            this.getRoteador().exibirMensagemErro(e);
        }
    }

    public void popularChoiceConvenio() throws Throwable {
        try {
            this.getBBPluginChoiceAutoConvenio().removeAll();
            ConvenioDBT convenio = new ConvenioDBT();
            convenio.setCodigoPessoaConvenenteDBT(ControleAplicacao.getConvenente().getPessoa().getCodigoPessoa());
            this.getBBPluginChoiceAutoConvenio().add(ControleConvenente.getControleConvenente().obterListaConvenioDBT(convenio));
        }
        catch (Throwable t) {
            this.getRoteador().exibirMensagemErro(t);
        }
    }

    public void popularChoiceGrupo() throws Throwable {
        try {
            GrupoClienteRecebimento grupoClienteDBT = new GrupoClienteRecebimento();
            grupoClienteDBT.setNumeroConvenioDBT(this.getBBPluginChoiceAutoConvenio().getSelectedCodigo());
            this.getBBPluginChoiceAutoGrupo().removeAll();
            this.getBBPluginChoiceAutoGrupo().add("");
            this.getBBPluginChoiceAutoGrupo().add("TODOS", "*** TODOS OS CLIENTES DO CONV\u00caNIO ***");
            this.getBBPluginChoiceAutoGrupo().add("NULO", "*** TODOS OS CLIENTES SEM GRUPO ***");
            this.getBBPluginChoiceAutoGrupo().add(ControleGrupoClientes.getControleGrupoClientes().obterListaGrupo(grupoClienteDBT));
        }
        catch (Throwable t) {
            this.getRoteador().exibirMensagemErro(t);
        }
    }

    public void popularGridMovimento() {
        try {
            IdentificadorDBT identificadorDBT = new IdentificadorDBT();
            IBarraProgresso barraProgresso = this.getRoteador().getFramePlugin().obterBarraProgresso();
            barraProgresso.inicializar("Gerando recebimentos para o grupo. Aguarde...", this.vetorClientes.size(), false);
            int tamanhoVetorClientes = this.vetorClientes.size();
            barraProgresso.setValorMaximo(tamanhoVetorClientes);
            this.getMultiColumnListboxMovimento().removeAllRows();
            this.gettxtValorTotal().setText("0,00");
            this.gettxtQuantidade().setText("0");
            Object[][] idDBT = new String[this.vetorClientes.size()][11];
            double total = 0.0;
            int qtd = 0;
            int i = 0;
            while (i < tamanhoVetorClientes) {
                identificadorDBT = (IdentificadorDBT)this.vetorClientes.elementAt(i);
                idDBT[i][0] = identificadorDBT.getIdentificacaoDBT().getCodigoPessoaRel();
                idDBT[i][1] = identificadorDBT.getIdentificacaoDBT().getCodigoIdentificador();
                idDBT[i][2] = identificadorDBT.getIdentificacaoDBT().getCodigoPessoaIdentificadorRel();
                idDBT[i][3] = identificadorDBT.getIdentificacaoDBT().getNumeroIdentificador();
                idDBT[i][4] = identificadorDBT.getContaCorrente().getPessoa().getNomePessoa();
                idDBT[i][5] = Util.formatarString(identificadorDBT.getIdentificacaoDBT().getNumeroIdentificador(), identificadorDBT.getIdentificacaoDBT().getIdentificador().getMascara());
                idDBT[i][6] = identificadorDBT.getContaCorrente().getCodigoBancoRel();
                idDBT[i][7] = Util.formatarConta(identificadorDBT.getContaCorrente().getAgencia().getCodigoPrefixoAgencia());
                idDBT[i][8] = Util.formatarConta(identificadorDBT.getContaCorrente().getnumeroContaCorrente());
                idDBT[i][9] = this.getBBPluginMaskedTextFieldData().getText().trim().length() > 0 ? String.valueOf(this.getBBPluginMaskedTextFieldData().getText().substring(0, 2).trim()) + "/" + this.getBBPluginMaskedTextFieldData().getText().substring(2, 4).trim() + "/" + this.getBBPluginMaskedTextFieldData().getText().substring(4).trim() : "  /  /    ";
                if (this.getTextFieldValor().getText().trim().length() > 0) {
                    idDBT[i][10] = Util.formatarValor(Double.valueOf(this.getTextFieldValor().getText().trim()) / 100.0, 2);
                    total += Double.valueOf(this.getTextFieldValor().getText()) / 100.0;
                } else {
                    idDBT[i][10] = "0,00";
                }
                ++qtd;
                barraProgresso.add(1);
                ++i;
            }
            this.getMultiColumnListboxMovimento().addRows(idDBT);
            this.gettxtValorTotal().setText(Util.formatarValor(total, 2));
            this.gettxtQuantidade().setText(String.valueOf(qtd));
            barraProgresso.finalizar();
        }
        catch (Throwable e) {
            this.getRoteador().exibirMensagemErro(e);
        }
    }

    public void textFieldValor_FocusLost(FocusEvent focusEvent) {
        this.alterarValor();
    }

    class IvjEventHandler
    implements ListboxListener,
    ActionListener,
    FocusListener,
    ItemListener {
        IvjEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MovimentoCadastroGrupo.this.getButtonSair()) {
                MovimentoCadastroGrupo.this.connEtoC1(e);
            }
            if (e.getSource() == MovimentoCadastroGrupo.this.getButtonSalvar()) {
                MovimentoCadastroGrupo.this.connEtoC2(e);
            }
            if (e.getSource() == MovimentoCadastroGrupo.this.getButtonRetirarCliente()) {
                MovimentoCadastroGrupo.this.connEtoC7(e);
            }
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            if (e.getSource() == MovimentoCadastroGrupo.this.getBBPluginMaskedTextFieldData()) {
                MovimentoCadastroGrupo.this.connEtoC5(e);
            }
            if (e.getSource() == MovimentoCadastroGrupo.this.getTextFieldValor()) {
                MovimentoCadastroGrupo.this.connEtoC6(e);
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == MovimentoCadastroGrupo.this.getBBPluginChoiceAutoConvenio()) {
                MovimentoCadastroGrupo.this.connEtoC3(e);
            }
            if (e.getSource() == MovimentoCadastroGrupo.this.getBBPluginChoiceAutoGrupo()) {
                MovimentoCadastroGrupo.this.connEtoC4(e);
            }
        }

        public void rowDeselected(ListboxEvent arg1) {
        }

        public void rowSelected(ListboxEvent arg1) {
            if (arg1.getSource() == MovimentoCadastroGrupo.this.getMultiColumnListboxMovimento()) {
                MovimentoCadastroGrupo.this.connEtoC8(arg1);
            }
        }
    }
}

