/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.ObjectDeletedException;
import net.sf.hibernate.ObjectNotFoundException;
import net.sf.hibernate.PersistentObjectException;
import net.sf.hibernate.Query;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.StaleObjectStateException;
import net.sf.hibernate.TransientObjectException;
import net.sf.hibernate.UnresolvableObjectException;
import net.sf.hibernate.WrongClassException;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.orm.hibernate.HibernateJdbcException;
import org.springframework.orm.hibernate.HibernateObjectRetrievalFailureException;
import org.springframework.orm.hibernate.HibernateOptimisticLockingFailureException;
import org.springframework.orm.hibernate.HibernateQueryException;
import org.springframework.orm.hibernate.HibernateSystemException;
import org.springframework.orm.hibernate.LocalDataSourceConnectionProvider;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class SessionFactoryUtils {
    public static final int SESSION_SYNCHRONIZATION_ORDER = 900;
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$orm$hibernate$SessionFactoryUtils == null ? (class$org$springframework$orm$hibernate$SessionFactoryUtils = SessionFactoryUtils.class$("org.springframework.orm.hibernate.SessionFactoryUtils")) : class$org$springframework$orm$hibernate$SessionFactoryUtils));
    private static ThreadLocal deferredCloseHolder = new ThreadLocal();
    static /* synthetic */ Class class$org$springframework$orm$hibernate$SessionFactoryUtils;

    public static DataSource getDataSource(SessionFactory sessionFactory) {
        ConnectionProvider cp;
        if (sessionFactory instanceof SessionFactoryImplementor && (cp = ((SessionFactoryImplementor)sessionFactory).getConnectionProvider()) instanceof LocalDataSourceConnectionProvider) {
            return ((LocalDataSourceConnectionProvider)cp).getDataSource();
        }
        return null;
    }

    public static SQLExceptionTranslator newJdbcExceptionTranslator(SessionFactory sessionFactory) {
        DataSource ds = SessionFactoryUtils.getDataSource(sessionFactory);
        if (ds != null) {
            return new SQLErrorCodeSQLExceptionTranslator(ds);
        }
        return new SQLStateSQLExceptionTranslator();
    }

    public static TransactionManager getJtaTransactionManager(SessionFactory sessionFactory, Session session) {
        SessionFactory internalFactory;
        SessionFactoryImplementor sessionFactoryImpl = null;
        if (sessionFactory instanceof SessionFactoryImplementor) {
            sessionFactoryImpl = (SessionFactoryImplementor)sessionFactory;
        } else if (session != null && (internalFactory = session.getSessionFactory()) instanceof SessionFactoryImplementor) {
            sessionFactoryImpl = (SessionFactoryImplementor)internalFactory;
        }
        return sessionFactoryImpl != null ? sessionFactoryImpl.getTransactionManager() : null;
    }

    public static Session getSession(SessionFactory sessionFactory, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        return SessionFactoryUtils.getSession(sessionFactory, null, null, allowCreate);
    }

    public static Session getSession(SessionFactory sessionFactory, Interceptor entityInterceptor, SQLExceptionTranslator jdbcExceptionTranslator) throws DataAccessResourceFailureException {
        return SessionFactoryUtils.getSession(sessionFactory, entityInterceptor, jdbcExceptionTranslator, true);
    }

    private static Session getSession(SessionFactory sessionFactory, Interceptor entityInterceptor, SQLExceptionTranslator jdbcExceptionTranslator, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        Session session;
        Assert.notNull((Object)sessionFactory, (String)"No SessionFactory specified");
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder != null && !sessionHolder.isEmpty()) {
            if (TransactionSynchronizationManager.isSynchronizationActive() && sessionHolder.doesNotHoldNonDefaultSession()) {
                if (!sessionHolder.isSynchronizedWithTransaction()) {
                    logger.debug((Object)"Registering Spring transaction synchronization for existing Hibernate Session");
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(sessionHolder, sessionFactory, jdbcExceptionTranslator, false));
                    sessionHolder.setSynchronizedWithTransaction(true);
                    FlushMode flushMode = sessionHolder.getSession().getFlushMode();
                    if (FlushMode.NEVER.equals(flushMode) && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                        sessionHolder.getSession().setFlushMode(FlushMode.AUTO);
                        sessionHolder.setPreviousFlushMode(flushMode);
                    }
                }
                return sessionHolder.getSession();
            }
            session = SessionFactoryUtils.getJtaSynchronizedSession(sessionHolder, sessionFactory, jdbcExceptionTranslator);
            if (session != null) {
                return session;
            }
        }
        try {
            logger.debug((Object)"Opening Hibernate Session");
            Session session2 = session = entityInterceptor != null ? sessionFactory.openSession(entityInterceptor) : sessionFactory.openSession();
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                logger.debug((Object)"Registering Spring transaction synchronization for new Hibernate Session");
                SessionHolder holderToUse = sessionHolder;
                if (holderToUse == null) {
                    holderToUse = new SessionHolder(session);
                } else {
                    holderToUse.addSession(session);
                }
                if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
                    session.setFlushMode(FlushMode.NEVER);
                }
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpringSessionSynchronization(holderToUse, sessionFactory, jdbcExceptionTranslator, true));
                holderToUse.setSynchronizedWithTransaction(true);
                if (holderToUse != sessionHolder) {
                    TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)holderToUse));
                }
            } else {
                SessionFactoryUtils.registerJtaSynchronization(session, sessionFactory, jdbcExceptionTranslator, sessionHolder);
            }
            if (!allowCreate && !SessionFactoryUtils.isSessionTransactional(session, sessionFactory)) {
                SessionFactoryUtils.doClose(session);
                throw new IllegalStateException("No Hibernate Session bound to thread, and configuration does not allow creation of non-transactional one here");
            }
            return session;
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", (Throwable)ex);
        }
    }

    private static Session getJtaSynchronizedSession(SessionHolder sessionHolder, SessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator) throws DataAccessResourceFailureException {
        TransactionManager jtaTm = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, sessionHolder.getAnySession());
        if (jtaTm != null) {
            try {
                int jtaStatus = jtaTm.getStatus();
                if (jtaStatus == 0 || jtaStatus == 1) {
                    Transaction jtaTx = jtaTm.getTransaction();
                    Session session = sessionHolder.getSession(jtaTx);
                    if (session == null && !sessionHolder.isSynchronizedWithTransaction() && (session = sessionHolder.getSession()) != null) {
                        logger.debug((Object)"Registering JTA transaction synchronization for existing Hibernate Session");
                        sessionHolder.addSession(jtaTx, session);
                        jtaTx.registerSynchronization((Synchronization)new JtaSessionSynchronization(new SpringSessionSynchronization(sessionHolder, sessionFactory, jdbcExceptionTranslator, false), jtaTm));
                        sessionHolder.setSynchronizedWithTransaction(true);
                        FlushMode flushMode = sessionHolder.getSession().getFlushMode();
                        if (FlushMode.NEVER.equals(flushMode)) {
                            sessionHolder.getSession().setFlushMode(FlushMode.AUTO);
                            sessionHolder.setPreviousFlushMode(flushMode);
                        }
                    }
                    return session;
                }
                return sessionHolder.getSession();
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not check JTA transaction", (Throwable)ex);
            }
        }
        return sessionHolder.getSession();
    }

    private static void registerJtaSynchronization(Session session, SessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator, SessionHolder sessionHolder) {
        TransactionManager jtaTm = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, session);
        if (jtaTm != null) {
            try {
                int jtaStatus = jtaTm.getStatus();
                if (jtaStatus == 0 || jtaStatus == 1) {
                    logger.debug((Object)"Registering JTA transaction synchronization for new Hibernate Session");
                    Transaction jtaTx = jtaTm.getTransaction();
                    SessionHolder holderToUse = sessionHolder;
                    if (holderToUse == null) {
                        holderToUse = new SessionHolder(jtaTx, session);
                    } else {
                        holderToUse.addSession(jtaTx, session);
                    }
                    jtaTx.registerSynchronization((Synchronization)new JtaSessionSynchronization(new SpringSessionSynchronization(holderToUse, sessionFactory, jdbcExceptionTranslator, true), jtaTm));
                    holderToUse.setSynchronizedWithTransaction(true);
                    if (holderToUse != sessionHolder) {
                        TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)holderToUse));
                    }
                }
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not register synchronization with JTA TransactionManager", (Throwable)ex);
            }
        }
    }

    public static Session getNewSession(SessionFactory sessionFactory) {
        return SessionFactoryUtils.getNewSession(sessionFactory, null);
    }

    public static Session getNewSession(SessionFactory sessionFactory, Interceptor entityInterceptor) {
        Assert.notNull((Object)sessionFactory, (String)"No SessionFactory specified");
        try {
            SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
            if (sessionHolder != null && !sessionHolder.isEmpty()) {
                if (entityInterceptor != null) {
                    return sessionFactory.openSession(sessionHolder.getAnySession().connection(), entityInterceptor);
                }
                return sessionFactory.openSession(sessionHolder.getAnySession().connection());
            }
            if (entityInterceptor != null) {
                return sessionFactory.openSession(entityInterceptor);
            }
            return sessionFactory.openSession();
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", (Throwable)ex);
        }
    }

    public static boolean isSessionTransactional(Session session, SessionFactory sessionFactory) {
        if (sessionFactory == null) {
            return false;
        }
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        return sessionHolder != null && sessionHolder.containsSession(session);
    }

    public static void applyTransactionTimeout(Query query, SessionFactory sessionFactory) {
        SessionHolder sessionHolder;
        Assert.notNull((Object)query, (String)"No Query object specified");
        if (sessionFactory != null && (sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory))) != null && sessionHolder.hasTimeout()) {
            query.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public static void applyTransactionTimeout(Criteria criteria, SessionFactory sessionFactory) {
        Assert.notNull((Object)criteria, (String)"No Criteria object specified");
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder != null && sessionHolder.hasTimeout()) {
            criteria.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public static DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCException) {
            return new HibernateJdbcException((JDBCException)((Object)ex));
        }
        if (ex instanceof UnresolvableObjectException) {
            return new HibernateObjectRetrievalFailureException((UnresolvableObjectException)ex);
        }
        if (ex instanceof ObjectNotFoundException) {
            return new HibernateObjectRetrievalFailureException((ObjectNotFoundException)ex);
        }
        if (ex instanceof ObjectDeletedException) {
            return new HibernateObjectRetrievalFailureException((ObjectDeletedException)ex);
        }
        if (ex instanceof WrongClassException) {
            return new HibernateObjectRetrievalFailureException((WrongClassException)ex);
        }
        if (ex instanceof StaleObjectStateException) {
            return new HibernateOptimisticLockingFailureException((StaleObjectStateException)ex);
        }
        if (ex instanceof QueryException) {
            return new HibernateQueryException((QueryException)ex);
        }
        if (ex instanceof PersistentObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof TransientObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        return new HibernateSystemException(ex);
    }

    public static boolean isDeferredCloseActive(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"No SessionFactory specified");
        Map holderMap = (Map)deferredCloseHolder.get();
        return holderMap != null && holderMap.containsKey(sessionFactory);
    }

    public static void initDeferredClose(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"No SessionFactory specified");
        logger.debug((Object)"Initializing deferred close of Hibernate Sessions");
        HashMap holderMap = (HashMap)deferredCloseHolder.get();
        if (holderMap == null) {
            holderMap = new HashMap();
            deferredCloseHolder.set(holderMap);
        }
        holderMap.put(sessionFactory, new HashSet());
    }

    public static void processDeferredClose(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"No SessionFactory specified");
        Map holderMap = (Map)deferredCloseHolder.get();
        if (holderMap == null || !holderMap.containsKey(sessionFactory)) {
            throw new IllegalStateException("Deferred close not active for SessionFactory [" + sessionFactory + "]");
        }
        logger.debug((Object)"Processing deferred close of Hibernate Sessions");
        Set sessions = (Set)holderMap.remove(sessionFactory);
        Iterator it = sessions.iterator();
        while (it.hasNext()) {
            SessionFactoryUtils.doClose((Session)it.next());
        }
        if (holderMap.isEmpty()) {
            deferredCloseHolder.set(null);
        }
    }

    public static void closeSessionIfNecessary(Session session, SessionFactory sessionFactory) {
        SessionFactoryUtils.releaseSession(session, sessionFactory);
    }

    public static void releaseSession(Session session, SessionFactory sessionFactory) {
        if (session == null) {
            return;
        }
        if (!SessionFactoryUtils.isSessionTransactional(session, sessionFactory)) {
            SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, sessionFactory);
        }
    }

    private static void closeSessionOrRegisterDeferredClose(Session session, SessionFactory sessionFactory) {
        Map holderMap = (Map)deferredCloseHolder.get();
        if (holderMap != null && sessionFactory != null && holderMap.containsKey(sessionFactory)) {
            logger.debug((Object)"Registering Hibernate Session for deferred close");
            Set sessions = (Set)holderMap.get(sessionFactory);
            sessions.add(session);
        } else {
            SessionFactoryUtils.doClose(session);
        }
    }

    private static void doClose(Session session) {
        logger.debug((Object)"Closing Hibernate Session");
        try {
            session.close();
        }
        catch (JDBCException ex) {
            logger.error((Object)"Could not close Hibernate Session", (Throwable)ex.getSQLException());
        }
        catch (HibernateException ex) {
            logger.error((Object)"Could not close Hibernate Session", (Throwable)ex);
        }
        catch (RuntimeException ex) {
            logger.error((Object)"Unexpected exception on closing Hibernate Session", (Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class JtaSessionSynchronization
    implements Synchronization {
        private final SpringSessionSynchronization springSessionSynchronization;
        private final TransactionManager jtaTransactionManager;
        private boolean beforeCompletionCalled = false;

        public JtaSessionSynchronization(SpringSessionSynchronization springSessionSynchronization, TransactionManager jtaTransactionManager) {
            this.springSessionSynchronization = springSessionSynchronization;
            this.jtaTransactionManager = jtaTransactionManager;
        }

        public void beforeCompletion() {
            try {
                boolean readOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
                this.springSessionSynchronization.beforeCommit(readOnly);
            }
            catch (Throwable ex) {
                logger.error((Object)"beforeCommit callback threw exception", ex);
                try {
                    this.jtaTransactionManager.setRollbackOnly();
                }
                catch (SystemException ex2) {
                    logger.error((Object)"Could not set JTA transaction rollback-only", (Throwable)ex2);
                }
            }
            this.beforeCompletionCalled = true;
            this.springSessionSynchronization.beforeCompletion();
        }

        public void afterCompletion(int status) {
            if (!this.beforeCompletionCalled) {
                this.springSessionSynchronization.beforeCompletion();
            }
            switch (status) {
                case 3: {
                    this.springSessionSynchronization.afterCompletion(0);
                    break;
                }
                case 4: {
                    this.springSessionSynchronization.afterCompletion(1);
                    break;
                }
                default: {
                    this.springSessionSynchronization.afterCompletion(2);
                }
            }
        }
    }

    private static class SpringSessionSynchronization
    implements TransactionSynchronization,
    Ordered {
        private final SessionHolder sessionHolder;
        private final SessionFactory sessionFactory;
        private final SQLExceptionTranslator jdbcExceptionTranslator;
        private final boolean newSession;
        private boolean hibernateTransactionCompletion = false;
        private Transaction jtaTransaction;
        private boolean holderActive = true;

        public SpringSessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator, boolean newSession) {
            this.sessionHolder = sessionHolder;
            this.sessionFactory = sessionFactory;
            this.jdbcExceptionTranslator = jdbcExceptionTranslator;
            this.newSession = newSession;
            TransactionManager jtaTm = SessionFactoryUtils.getJtaTransactionManager(sessionFactory, sessionHolder.getAnySession());
            if (jtaTm != null) {
                this.hibernateTransactionCompletion = true;
                try {
                    int jtaStatus = jtaTm.getStatus();
                    if (jtaStatus == 0 || jtaStatus == 1) {
                        this.jtaTransaction = jtaTm.getTransaction();
                    }
                }
                catch (SystemException ex) {
                    throw new DataAccessResourceFailureException("Could not check JTA transaction", (Throwable)ex);
                }
            }
        }

        public int getOrder() {
            return 900;
        }

        public void suspend() {
            if (this.holderActive) {
                TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            }
        }

        public void resume() {
            if (this.holderActive) {
                TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.sessionHolder));
            }
        }

        public void beforeCommit(boolean readOnly) throws DataAccessException {
            if (!readOnly) {
                logger.debug((Object)"Flushing Hibernate Session on transaction synchronization");
                Session session = null;
                if (this.jtaTransaction != null) {
                    session = this.sessionHolder.getSession(this.jtaTransaction);
                }
                if (session == null) {
                    session = this.sessionHolder.getSession();
                }
                if (!session.getFlushMode().equals(FlushMode.NEVER)) {
                    try {
                        session.flush();
                    }
                    catch (JDBCException ex) {
                        if (this.jdbcExceptionTranslator != null) {
                            throw this.jdbcExceptionTranslator.translate("Hibernate transaction synchronization", null, ex.getSQLException());
                        }
                        throw new HibernateJdbcException(ex);
                    }
                    catch (HibernateException ex) {
                        throw SessionFactoryUtils.convertHibernateAccessException(ex);
                    }
                }
            }
        }

        public void beforeCompletion() {
            Session session;
            if (this.jtaTransaction != null && (session = this.sessionHolder.removeSession(this.jtaTransaction)) != null) {
                if (this.sessionHolder.isEmpty()) {
                    if (TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
                        TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                    }
                    this.holderActive = false;
                }
                if (session != this.sessionHolder.getSession()) {
                    SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.sessionFactory);
                } else if (this.sessionHolder.getPreviousFlushMode() != null) {
                    session.setFlushMode(this.sessionHolder.getPreviousFlushMode());
                }
                return;
            }
            if (this.newSession) {
                TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                this.holderActive = false;
                if (this.hibernateTransactionCompletion) {
                    SessionFactoryUtils.closeSessionOrRegisterDeferredClose(this.sessionHolder.getSession(), this.sessionFactory);
                }
            } else if (this.sessionHolder.getPreviousFlushMode() != null) {
                this.sessionHolder.getSession().setFlushMode(this.sessionHolder.getPreviousFlushMode());
            }
        }

        public void afterCompletion(int status) {
            if (!this.hibernateTransactionCompletion || !this.newSession) {
                Session session = this.sessionHolder.getSession();
                if (session instanceof SessionImplementor) {
                    ((SessionImplementor)session).afterTransactionCompletion(status == 0);
                }
                if (this.newSession) {
                    SessionFactoryUtils.closeSessionOrRegisterDeferredClose(session, this.sessionFactory);
                }
            }
            if (!this.newSession && status != 0) {
                this.sessionHolder.getSession().clear();
            }
            if (this.sessionHolder.doesNotHoldNonDefaultSession()) {
                this.sessionHolder.setSynchronizedWithTransaction(false);
            }
        }
    }
}

